/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.JPanel0;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Timer;

public class BinauralCoincidence
extends NeurolabExhibit {
    JPanel mainpanel;
    WorldPanel world;
    EarPanel ear;

    public String getExhibitName() {
        return "Binaural Coincidence";
    }

    public void init() {
        super.init();
        this.createComponents();
    }

    public void createComponents() {
        this.getMainContainer().setLayout(new BorderLayout());
        this.getMainContainer().add((Component)new ReturnButton(), "South");
        this.mainpanel = new JPanel();
        this.getMainContainer().add((Component)this.mainpanel, "North");
        this.mainpanel.setBorder(NeurolabExhibit.loweredbevel);
        NeurolabExhibit.setBG(this.mainpanel);
        this.mainpanel.setLayout(new BorderLayout());
        this.world = new WorldPanel();
        this.mainpanel.add((Component)this.world, "North");
        this.world.setPreferredSize(new Dimension(520, 200));
        this.ear = new EarPanel();
        this.mainpanel.add((Component)this.ear, "South");
        this.ear.setPreferredSize(new Dimension(520, 90));
        this.ear.setBorder(NeurolabExhibit.raisedbevel);
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        this.world.timer.stop();
        this.ear.timer.stop();
    }

    public class EarPanel
    extends JPanel0
    implements ActionListener {
        public static final int CELL_TIMER_MS = 250;
        Point2D[] p0 = new Point2D[2];
        Point2D[] p1 = new Point2D[2];
        final int gutter = 5;
        final int NUMCELLS = 18;
        boolean initing = true;
        boolean[] celllit = new boolean[18];
        int[] earlit = new int[2];
        Vector[] ap = new Vector[2];
        Timer timer = new Timer(250, this);
        int thick = 5;

        public EarPanel() {
            this.ap[0] = new Vector();
            this.ap[1] = new Vector();
        }

        public void paint(Graphics g) {
            if (this.initing) {
                this.p0[0] = new Point2D.Float(20.0f, 20.0f);
                this.p1[0] = new Point2D.Float(this.getWidth() - 5 - 30, 20.0f);
                this.p1[1] = new Point2D.Float(35.0f, 40.0f);
                this.p0[1] = new Point2D.Float(this.getWidth() - 5 - 15, 40.0f);
                this.initing = false;
            }
            super.paint(g);
            NeurolabExhibit.antiAlias(g);
            NeurolabExhibit.setStrokeThickness(g, this.thick);
            int i = 0;
            while (i < 2) {
                this.paintear(g, i);
                g.setColor(Color.black);
                g.drawLine((int)this.p0[i].getX(), (int)this.p0[i].getY(), (int)this.p1[i].getX(), (int)this.p1[i].getY());
                ++i;
            }
            int i2 = 0;
            while (i2 < 18) {
                this.paintcell(g, i2);
                ++i2;
            }
        }

        public void paintear(Graphics g, int i) {
            int n = i;
            int n2 = this.earlit[n] - 1;
            this.earlit[n] = n2;
            g.setColor(n2 > 3 || this.earlit[i] < 1 ? Color.black : Color.red);
            g.drawLine((int)this.p0[i].getX(), (int)this.p0[i].getY(), (int)this.p0[i].getX(), 0);
            g.fillOval((int)this.p0[i].getX() - 10, (int)this.p0[i].getY() - 10, 20, 20);
        }

        public void paintcell(Graphics g, int i) {
            g.setColor(this.celllit[i] ? Color.red : Color.black);
            double cx = this.p1[1].getX() + (this.p1[0].getX() - this.p1[1].getX()) * (double)(i + 1) / 19.0;
            g.fillOval((int)cx - 10, 60, 20, 20);
            g.drawLine((int)cx, 60, (int)cx, 10);
        }

        public void fireEar(int e) {
            this.earlit[e] = 5;
            this.paintear(this.getGraphics(), e);
            this.ap[e].add(new Integer(0));
            this.timer.start();
        }

        public void clearneurones() {
            Graphics g = this.getGraphics();
            NeurolabExhibit.setStrokeThickness(g, this.thick);
            int i = 0;
            while (i < 18) {
                this.celllit[i] = false;
                this.paintcell(g, i);
                ++i;
            }
        }

        public void actionPerformed(ActionEvent ev) {
            int p;
            Enumeration e;
            int numaps = 0;
            Graphics g = this.getGraphics();
            NeurolabExhibit.setStrokeThickness(g, this.thick);
            int i = 0;
            while (i < 2) {
                if (this.earlit[i] > 0) {
                    this.paintear(g, i);
                }
                e = this.ap[i].elements();
                while (e.hasMoreElements()) {
                    Integer o = (Integer)e.nextElement();
                    p = o;
                    g.setColor(Color.black);
                    if (p > 0) {
                        this.drawAP(g, i, p);
                    }
                    if (++p < 20) {
                        g.setColor(Color.red);
                        this.drawAP(g, i, p);
                        this.ap[i].set(this.ap[i].indexOf(o), new Integer(p));
                        ++numaps;
                        continue;
                    }
                    this.ap[i].remove(o);
                }
                ++i;
            }
            if (numaps != 0) {
                e = this.ap[0].elements();
                while (e.hasMoreElements()) {
                    p = (Integer)e.nextElement();
                    Enumeration f = this.ap[1].elements();
                    while (f.hasMoreElements()) {
                        int q = (Integer)f.nextElement();
                        if (p != 18 - q && p != 18 - q + 1 || p <= 0 || p >= 19) continue;
                        this.celllit[p - 1] = true;
                        this.paintcell(g, p - 1);
                    }
                }
            }
        }

        public void drawAP(Graphics g, int i, int pos) {
            double dx = (double)(1 - 2 * i) * (this.p1[0].getX() - this.p1[1].getX()) / 19.0;
            double cx = this.p1[1 - i].getX() + dx * (double)(pos - 1);
            if (dx < 0.0) {
                cx += dx;
                dx = Math.abs(dx);
            }
            g.drawLine((int)cx, i == 0 ? 20 : 40, (int)(cx + dx), i == 0 ? 20 : 40);
        }
    }

    public class WorldPanel
    extends JPanel
    implements MouseListener,
    ActionListener {
        String clicktext = "Click in the black area";
        final int gutter = 5;
        final int textheight = 15;
        Timer timer;
        Vector radii;
        Vector centres;
        Point2D[] earhole;
        int[] earred;
        boolean initing;
        Vector collisions;
        int ringstroke;
        static final int PROPAGATION_RATE = 25;

        public WorldPanel() {
            NeurolabExhibit.setBG(this);
            this.timer = new Timer(100, this);
            this.centres = new Vector();
            this.radii = new Vector();
            this.collisions = new Vector();
            this.addMouseListener(this);
            this.earhole = new Point2D[2];
            this.earred = new int[2];
            this.initing = true;
            this.ringstroke = 3;
        }

        public void paint(Graphics g) {
            super.paint(g);
            NeurolabExhibit.antiAlias(g);
            g.setFont(new Font("Arial", 1, 16));
            NeurolabExhibit.paintText3D(g, this.clicktext, (this.getWidth() - NeurolabExhibit.getTextWidth(g, this.clicktext)) / 2, 16);
            g.setColor(Color.black);
            g.fillRect(5, 20, this.getWidth() - 10, this.getHeight() - 15 - 30 - 5);
            int i = 0;
            while (i < 2) {
                this.drawEarHole(g, i);
                ++i;
            }
        }

        public void drawEarHole(Graphics g, int i) {
            if (this.initing) {
                this.earhole[0] = new Point2D.Double(20.0, this.getHeight() - 30);
                this.earhole[1] = new Point2D.Double(this.getWidth() - 5 - 15, this.getHeight() - 30);
                this.initing = false;
            }
            if (this.earred[i] > 0) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            NeurolabExhibit.setStrokeThickness(g, 4.0f);
            g.fillOval((int)this.earhole[i].getX() - 10, (int)this.earhole[i].getY() - 10, 20, 20);
            g.drawLine((int)this.earhole[i].getX(), (int)this.earhole[i].getY(), (int)this.earhole[i].getX(), this.getHeight());
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent w) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.centres.add(e.getPoint());
            this.radii.add(new Integer(0));
            Boolean[] coll = new Boolean[2];
            this.collisions.add(coll);
            coll[0] = new Boolean(false);
            coll[1] = new Boolean(false);
            BinauralCoincidence.this.ear.clearneurones();
            this.timer.start();
        }

        public void actionPerformed(ActionEvent e) {
            Graphics g = this.getGraphics();
            int i = 0;
            while (i < 2) {
                if (this.earred[i] > 0) {
                    int n = i;
                    this.earred[n] = this.earred[n] - 1;
                    this.drawEarHole(g, i);
                }
                ++i;
            }
            g.clipRect(5, 20, this.getWidth() - 10, this.getHeight() - 15 - 5 - 30);
            g.setColor(Color.black);
            NeurolabExhibit.setStrokeThickness(g, this.ringstroke);
            Point2D[] c = new Point2D[this.radii.size()];
            int[] r = new int[this.radii.size()];
            int i2 = 0;
            while (i2 < this.radii.size()) {
                c[i2] = (Point2D)this.centres.get(i2);
                r[i2] = (Integer)this.radii.get(i2);
                g.drawOval((int)c[i2].getX() - r[i2] / 2, (int)c[i2].getY() - r[i2] / 2, r[i2], r[i2]);
                ++i2;
            }
            g.setColor(Color.red);
            i2 = 0;
            while (i2 < this.radii.size()) {
                int n = i2;
                r[n] = r[n] + 25;
                g.drawOval((int)c[i2].getX() - r[i2] / 2, (int)c[i2].getY() - r[i2] / 2, r[i2], r[i2]);
                this.radii.set(i2, new Integer(r[i2]));
                int j = 0;
                while (j < 2) {
                    if ((double)(r[i2] / 2) > c[i2].distance(this.earhole[j]) && !((Boolean[])this.collisions.get(i2))[j].booleanValue()) {
                        this.earred[j] = 3;
                        BinauralCoincidence.this.ear.fireEar(j);
                        ((Boolean[])this.collisions.get((int)i2))[j] = new Boolean(true);
                    }
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.radii.size()) {
                if (r[i2] > 2 * this.getWidth()) {
                    this.radii.remove(i2);
                    this.centres.remove(i2);
                    this.collisions.remove(i2);
                    g.setColor(Color.black);
                    g.drawOval((int)c[i2].getX() - r[i2] / 2, (int)c[i2].getY() - r[i2] / 2, r[i2], r[i2]);
                }
                ++i2;
            }
        }

        public void finalize() throws Throwable {
            this.timer.stop();
            super.finalize();
        }
    }
}

