/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.RadioPanel;
import com.neurolab.common.ReturnButton;
import com.neurolab.common.ThickPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;

public class BasilarMembrane
extends NeurolabExhibit
implements ActionListener {
    private Timer timer;
    private double[] env;
    private int npoints = 240;
    double invspeed = 2.0;
    JPanel lpanel;
    JPanel rpanel;
    JPanel blpanel;
    JPanel trpanel;
    JButton start;
    JButton stop;
    RadioPanel freqpanel;
    TitledBorder tborder1;
    ThickPanel tlpanel;
    GraphPanel graph;
    String[] freqnames = new String[]{"100 Hz", "300 Hz", "1 kHz", "2 kHz", "5 kHz", "10 kHz"};
    int[] freqpeak = new int[]{160, 135, 100, 85, 70, 55};
    int[] freqvalues = new int[]{100, 300, 1000, 2000, 5000, 10000};
    int[] freqspeeds = new int[]{6, 5, 4, 3, 2, 1};
    JCheckBox envelopeCheck;
    public ActionListener radioListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            BasilarMembrane.this.selectedFreq = BasilarMembrane.this.freqpanel.getSelected();
            BasilarMembrane.this.initCochlea();
            BasilarMembrane.this.graph.repaint();
        }
    };
    int selectedFreq = 0;
    int time;
    boolean overlay = false;

    public String getExhibitName() {
        return "Basilar Membrane";
    }

    public void init() {
        super.init();
        this.getMainContainer().setLayout(new BorderLayout());
        this.env = new double[this.npoints];
        this.createComponents();
        this.timer = new Timer((int)(100.0 / this.invspeed), this);
    }

    public void createComponents() {
        this.lpanel = new JPanel();
        this.getMainContainer().add((Component)this.lpanel, "West");
        this.rpanel = new JPanel();
        this.getMainContainer().add((Component)this.rpanel, "East");
        this.lpanel.setLayout(new BorderLayout());
        this.blpanel = new JPanel();
        this.lpanel.add((Component)this.blpanel, "South");
        this.tlpanel = new ThickPanel(19);
        this.lpanel.add((Component)this.tlpanel, "North");
        NeurolabExhibit.setBG(this.lpanel);
        NeurolabExhibit.setBG(this.rpanel);
        NeurolabExhibit.setBG(this.blpanel);
        this.tlpanel.setFont(new Font("Dialog", 1, 14));
        this.tlpanel.setText("Stapes                                                 Helicotrema");
        this.graph = new GraphPanel();
        this.tlpanel.inner.add(this.graph);
        this.blpanel.setLayout(new GridLayout(1, 2));
        this.start = new JButton("Start");
        this.blpanel.add(this.start);
        this.stop = new JButton("Stop");
        this.blpanel.add(this.stop);
        this.start.addActionListener(this);
        this.stop.addActionListener(this);
        NeurolabExhibit.setBG(this.start);
        NeurolabExhibit.setBG(this.stop);
        this.rpanel.setLayout(new BorderLayout());
        this.rpanel.add((Component)new ReturnButton(), "South");
        this.trpanel = new JPanel();
        this.rpanel.add((Component)this.trpanel, "North");
        NeurolabExhibit.setBG(this.trpanel);
        this.tborder1 = BorderFactory.createTitledBorder(NeurolabExhibit.etched, "Frequency");
        this.trpanel.setBorder(this.tborder1);
        this.freqpanel = new RadioPanel(this.freqnames, this.radioListener);
        this.trpanel.add((Component)this.freqpanel, "Center");
        this.envelopeCheck = new JCheckBox("Show envelope");
        this.rpanel.add((Component)this.envelopeCheck, "Center");
        NeurolabExhibit.setBG(this.envelopeCheck);
        NeurolabExhibit.setBG(this.freqpanel);
        this.freqpanel.setSelected(2);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Start") {
            this.graph.repaint();
            this.initCochlea();
            this.timer.start();
        } else if (e.getActionCommand() == "Stop") {
            this.timer.stop();
        } else {
            this.tick();
        }
    }

    public void initCochlea() {
        double pk = this.freqpeak[this.freqpanel.getSelected()];
        int i = 0;
        while (i < this.npoints) {
            double X = 240.0 * ((double)i - pk) / (double)this.npoints;
            this.env[i] = 100.0 * this.sfun(1.5 * X / pk) * this.sfun(-10.0 * X / pk);
            ++i;
        }
        this.time = 0;
    }

    double sfun(double x) {
        return 0.5 * (1.0 + x / Math.sqrt(1.0 + x * x));
    }

    void paintmemb(Graphics g) {
        int base = (this.graph.getHeight() - 4) / 2;
        int wid = this.graph.getWidth();
        int freq = this.freqvalues[this.selectedFreq];
        Point curr = new Point(2, base);
        ++this.time;
        g.setColor(Color.green);
        NeurolabExhibit.setStrokeThickness(g, 1.0f);
        curr = new Point(2, base);
        int i = 0;
        while (i < this.npoints) {
            Point prev = curr;
            curr = new Point(2 + i * (wid - 4) / this.npoints, (int)((double)base + this.env[i] * Math.sin((double)(2 * (i * 240 / this.npoints)) * Math.PI * ((double)freq / 80000.0) - (double)this.time / (double)this.freqspeeds[this.selectedFreq])));
            g.drawLine(prev.x, prev.y, curr.x, curr.y);
            ++i;
        }
    }

    public void tick() {
        boolean bl2 = this.overlay = this.envelopeCheck != null && this.envelopeCheck.isSelected();
        if (!this.overlay) {
            this.graph.repaint();
        } else {
            this.paintmemb(this.graph.getGraphics());
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        this.timer.stop();
    }

    class GraphPanel
    extends JPanel {
        public int base;

        GraphPanel() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            NeurolabExhibit.antiAlias(g);
            g.setColor(Color.black);
            g.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
            g.setColor(Color.gray);
            this.base = (this.getHeight() - 4) / 2;
            g.drawLine(2, this.base, this.getWidth() - 4, this.base);
            g.setColor(Color.gray);
            BasilarMembrane.this.paintmemb(g);
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 230);
        }
    }
}

