/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.Label3D;
import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.ReturnButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AnatomicalPathways
extends NeurolabExhibit {
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JButton showall = new JButton();
    ReturnButton returnButton1 = new ReturnButton();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    Label3D label3D1 = new Label3D();
    Label3D label3D2 = new Label3D();
    JList destlist = new JList();
    JPanel jPanel7 = new JPanel();
    Label3D label3D3 = new Label3D();
    JList tractlist = new JList();
    JTextArea jTextPane1 = new JTextArea();
    Border border1;
    Border border2;
    Border border3;
    Vector nuclei;
    Vector pathways;
    DefaultListModel sourcemodel = new DefaultListModel();
    DefaultListModel destmodel = new DefaultListModel();
    DefaultListModel tractmodel = new DefaultListModel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList sourcelist = new JList();
    JScrollPane jScrollPane2 = new JScrollPane();
    JScrollPane jScrollPane3 = new JScrollPane();

    public String getExhibitName() {
        return "Neural Pathways";
    }

    public void init() {
        super.init();
        InputStream is = null;
        try {
            this.jbInit();
            is = this.getURL("resources/pathways.txt").openStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (is != null) {
            try {
                this.readText(is);
            }
            catch (IOException e) {
                throw new RuntimeException("cannot load textfile");
            }
        }
        this.showall.doClick();
        MouseAdapter dcl = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (e.getSource() == AnatomicalPathways.this.sourcelist) {
                        AnatomicalPathways.this.sourcedcl();
                    } else if (e.getSource() == AnatomicalPathways.this.destlist) {
                        AnatomicalPathways.this.destdcl();
                    }
                }
            }
        };
        this.sourcelist.addMouseListener(dcl);
        this.destlist.addMouseListener(dcl);
    }

    void readText(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String s = "";
        this.nuclei = new Vector();
        while (s != null && !s.startsWith("*")) {
            s = br.readLine();
            this.nuclei.addElement(s);
        }
        this.pathways = new Vector();
        s = "";
        while (s != null && !s.startsWith("*")) {
            String name;
            s = "";
            while (s.length() == 0) {
                s = br.readLine();
            }
            if (s.startsWith("*")) break;
            Pathway p = new Pathway();
            p.name = name = s;
            s = "";
            while (s.length() == 0) {
                s = br.readLine();
            }
            StringTokenizer st = new StringTokenizer(s, " ,;\t", false);
            p.conn = new int[1][2];
            int c = 0;
            while (st.hasMoreElements()) {
                p.conn[c][0] = Integer.parseInt(st.nextToken());
                p.conn[c++][1] = Integer.parseInt(st.nextToken());
                --c;
                this.pathways.addElement(p);
                p = new Pathway();
                p.name = name;
                p.conn = new int[1][2];
            }
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(162, 147, 159), new Color(113, 102, 111)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(162, 147, 159), new Color(113, 102, 111)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border3 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(162, 147, 159), new Color(113, 102, 111)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.getMainContainer().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.showall.setBackground(Color.lightGray);
        this.showall.setText("Show all");
        this.showall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnatomicalPathways.this.showall_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout(this.borderLayout3);
        this.jPanel4.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.label3D1.setPreferredSize(new Dimension(90, 30));
        this.label3D1.setFont(new Font("Dialog", 1, 16));
        this.label3D1.setText("Source");
        this.label3D2.setText("Destination");
        this.label3D2.setFont(new Font("Dialog", 1, 16));
        this.label3D2.setPreferredSize(new Dimension(120, 30));
        this.destlist.setModel(this.destmodel);
        this.destlist.setSelectionMode(0);
        this.destlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AnatomicalPathways.this.destinationchange(e);
            }
        });
        this.jPanel7.setBackground(Color.lightGray);
        this.jPanel7.setPreferredSize(new Dimension(10, 120));
        this.label3D3.setText("Tract");
        this.label3D3.setFont(new Font("Dialog", 1, 16));
        this.label3D3.setPreferredSize(new Dimension(70, 30));
        this.tractlist.setModel(this.tractmodel);
        this.tractlist.setSelectionMode(0);
        this.tractlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AnatomicalPathways.this.tractchange(e);
            }
        });
        this.jTextPane1.setPreferredSize(new Dimension(150, 100));
        this.jTextPane1.setOpaque(false);
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setText("Double-click on a destination to go one stage on, on a source to go one stage back");
        this.jTextPane1.setLineWrap(true);
        this.jTextPane1.setWrapStyleWord(true);
        this.jTextPane1.setFont(new Font("Dialog", 0, 13));
        this.jTextPane1.setBackground(NeurolabExhibit.systemGray);
        this.sourcelist.setModel(this.sourcemodel);
        this.sourcelist.setSelectionMode(0);
        this.sourcelist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AnatomicalPathways.this.sourcechange(e);
            }
        });
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jScrollPane1.setPreferredSize(new Dimension(260, 120));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jScrollPane2.setPreferredSize(new Dimension(260, 120));
        this.jScrollPane3.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jScrollPane3.setPreferredSize(new Dimension(300, 90));
        this.jPanel3.setBackground(Color.lightGray);
        this.jPanel6.setBackground(Color.lightGray);
        this.jPanel5.setBackground(Color.lightGray);
        this.getMainContainer().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.label3D1, null);
        this.jPanel5.add((Component)this.jScrollPane1, null);
        this.jScrollPane1.getViewport().add((Component)this.sourcelist, null);
        this.jPanel4.add((Component)this.jPanel6, null);
        this.jPanel6.add((Component)this.label3D2, null);
        this.jPanel6.add((Component)this.jScrollPane2, null);
        this.jScrollPane2.getViewport().add((Component)this.destlist, null);
        this.jPanel2.add((Component)this.jPanel7, "South");
        this.jPanel7.add((Component)this.label3D3, null);
        this.jPanel7.add((Component)this.jScrollPane3, null);
        this.jScrollPane3.getViewport().add((Component)this.tractlist, null);
        this.jPanel7.add((Component)this.jTextPane1, null);
        this.jPanel1.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.showall, null);
        this.jPanel3.add((Component)this.returnButton1, null);
    }

    Vector find(int which, String name) {
        Vector<Pathway> f = new Vector<Pathway>();
        int p = 0;
        while (p < this.pathways.size()) {
            Pathway a = (Pathway)this.pathways.elementAt(p);
            if (which < 2) {
                int i = 0;
                while (i < a.conn.length) {
                    int c = a.conn[i][which];
                    if (name.equals(this.nuclei.elementAt(c))) {
                        f.addElement(a);
                    }
                    ++i;
                }
            } else if (a.name.equals(name)) {
                f.addElement(a);
            }
            ++p;
        }
        return f;
    }

    void showsource(Vector v) {
        Vector w = this.displayableStrings(0, v);
        this.sourcemodel.removeAllElements();
        int i = 0;
        while (i < w.size()) {
            this.sourcemodel.addElement(w.elementAt(i));
            ++i;
        }
    }

    Vector displayableStrings(int which, Vector v) {
        Vector<String> w = new Vector<String>();
        int i = 0;
        while (i < v.size()) {
            Pathway p = (Pathway)v.elementAt(i);
            int j = 0;
            while (j < p.conn.length) {
                String s = which < 2 ? this.nuclei.elementAt(p.conn[j][which]) : p.name;
                if (w.indexOf(s) < 0) {
                    w.addElement(s);
                }
                ++j;
            }
            ++i;
        }
        return w;
    }

    void showdest(Vector v) {
        Vector w = this.displayableStrings(1, v);
        this.destmodel.removeAllElements();
        int i = 0;
        while (i < w.size()) {
            this.destmodel.addElement(w.elementAt(i));
            ++i;
        }
    }

    void showtract(Vector v) {
        Vector w = this.displayableStrings(2, v);
        this.tractmodel.removeAllElements();
        int i = 0;
        while (i < w.size()) {
            this.tractmodel.addElement(w.elementAt(i));
            ++i;
        }
    }

    void sourcedcl() {
        String s = (String)this.sourcelist.getSelectedValue();
        this.destmodel.removeAllElements();
        this.destmodel.addElement(s);
        Vector v = this.find(1, s);
        this.showsource(v);
        this.showtract(v);
    }

    void destdcl() {
        String s = (String)this.destlist.getSelectedValue();
        this.sourcemodel.removeAllElements();
        this.sourcemodel.addElement(s);
        Vector v = this.find(0, s);
        this.showdest(v);
        this.showtract(v);
    }

    void sourcechange(ListSelectionEvent e) {
        String s = (String)this.sourcelist.getSelectedValue();
        if (s != null) {
            Vector v = this.find(0, s);
            this.showdest(v);
            this.showtract(v);
        }
    }

    void destinationchange(ListSelectionEvent e) {
        String s = (String)this.destlist.getSelectedValue();
        if (s != null) {
            Vector v = this.find(1, s);
            this.showsource(v);
            this.showtract(v);
        }
    }

    void tractchange(ListSelectionEvent e) {
        String s = (String)this.tractlist.getSelectedValue();
        if (s != null) {
            Vector v = this.find(2, s);
            this.showsource(v);
            this.showdest(v);
        }
    }

    void showall_actionPerformed(ActionEvent e) {
        this.showsource(this.pathways);
        this.showdest(this.pathways);
        this.showtract(this.pathways);
    }

    void sourcelist_valueChanged(ListSelectionEvent e) {
    }

    public void close() {
    }

    class Pathway {
        int[][] conn;
        String name;

        Pathway() {
        }
    }
}

