/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.Oscilloscope;
import com.neurolab.common.RadioPanel;
import com.neurolab.common.ReturnButton;
import com.neurolab.common.SignalGenerator;
import com.neurolab.common.SignalListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Adaptation
extends NeurolabExhibit
implements ActionListener,
ChangeListener,
SignalListener {
    private Color[] oscColors = new Color[]{Color.yellow, Color.green};
    private int[] base = new int[]{40, 100};
    private String[] label = new String[]{"Response", "Stimulus"};
    Timer timer;
    JButton waterfall;
    JButton plateau;
    JPanel controls;
    JPanel srpanel;
    JPanel spanel;
    JPanel rpanel;
    JPanel buttons;
    Oscilloscope osc;
    NeurolabExhibit.NamedSliderPanel completeness;
    NeurolabExhibit.NamedSliderPanel timeconstant;
    NeurolabExhibit.NamedSliderPanel freq;
    RadioPanel s_type;
    String[] s_typenames = new String[]{"Step", "Ramp", "Sinusoidal"};
    SignalGenerator siggen = new SignalGenerator();
    static int ampl = 90;
    int time;
    double z = 0.0;

    public String getExhibitName() {
        return "Adaptation";
    }

    public void init() {
        super.init();
        this.getMainContainer().setLayout(new BorderLayout());
        this.createComponents();
        this.timer = new Timer(100, this);
        this.timer.start();
        this.siggen.timer.start();
    }

    public void createComponents() {
        this.osc = new Oscilloscope(2, this){

            public void drawScreenElements(Graphics g) {
                g.setFont(new Font("Ariel", 1, 12));
                int i = 0;
                while (i < 2) {
                    int gut = this.getGutter();
                    g.setColor(this.getColors()[i]);
                    g.drawString(Adaptation.this.label[i], gut + 5, gut + 15 + i * (this.getHeight() - 4 * gut - 30));
                    ++i;
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension(500, 200);
            }
        };
        this.osc.setColors(this.oscColors);
        this.osc.setBaseY(this.base);
        this.osc.timer.setDelay(50);
        this.getMainContainer().add((Component)this.osc, "North");
        this.controls = new JPanel();
        this.getMainContainer().add((Component)this.controls, "South");
        this.controls.setLayout(new BorderLayout());
        this.srpanel = new JPanel();
        this.controls.add((Component)this.srpanel, "West");
        this.buttons = new JPanel();
        this.controls.add((Component)this.buttons, "East");
        NeurolabExhibit.setBG(this.controls);
        NeurolabExhibit.setBG(this.buttons);
        NeurolabExhibit.setBG(this.srpanel);
        this.srpanel.setLayout(new BorderLayout());
        this.spanel = new JPanel();
        this.srpanel.add((Component)this.spanel, "West");
        this.rpanel = new JPanel();
        this.srpanel.add((Component)this.rpanel, "East");
        NeurolabExhibit.setBG(this.spanel);
        NeurolabExhibit.setBG(this.rpanel);
        this.buttons.setLayout(new GridLayout(3, 1));
        this.waterfall = new JButton("Waterfall illusion");
        this.buttons.add(this.waterfall);
        this.plateau = new JButton("Plateau spiral");
        this.buttons.add(this.plateau);
        this.buttons.add(new ReturnButton());
        NeurolabExhibit.setBG(this.waterfall);
        NeurolabExhibit.setBG(this.plateau);
        this.waterfall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Adaptation.this.getHolder().setExhibit("com.neurolab.WaterfallIllusion");
            }
        });
        this.plateau.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Adaptation.this.getHolder().setExhibit("com.neurolab.PlateauSpiral");
            }
        });
        this.spanel.setLayout(new BorderLayout());
        this.siggen.setSignalListener(this);
        this.siggen.optionPanel.setLayout(new FlowLayout());
        this.siggen.optionPanel.remove(this.siggen.squareramp);
        this.siggen.frequencyPanel.remove(this.siggen.freqLabel);
        this.siggen.frequencyPanel.add((Component)this.siggen.freqLabel, "West");
        this.siggen.amplitudePanel.remove(this.siggen.amplLabel);
        this.siggen.amplitudePanel.add((Component)this.siggen.amplLabel, "West");
        this.siggen.sinusoidal.setSelected(true);
        this.spanel.add(this.siggen);
        this.rpanel.setLayout(new BorderLayout());
        this.completeness = new NeurolabExhibit.NamedSliderPanel(this, "Completeness", 100, NeurolabExhibit.LABEL_POS_LEFT);
        this.rpanel.add((Component)this.completeness, "North");
        this.timeconstant = new NeurolabExhibit.NamedSliderPanel(this, "Time-constant", 100, NeurolabExhibit.LABEL_POS_LEFT);
        this.rpanel.add((Component)this.timeconstant, "South");
        this.rpanel.setBorder(BorderFactory.createTitledBorder(NeurolabExhibit.etched, "Response"));
        this.timeconstant.slider.setMinimum(3);
        this.completeness.slider.setValue(50);
        this.timeconstant.slider.setValue(30);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Sweep") {
            if (this.osc != null) {
                this.osc.graph.repaint();
            }
            this.z = 0.0;
        }
    }

    public void stateChanged(ChangeEvent e) {
    }

    public void signalEvent(double s) {
        double creep = (double)(this.timeconstant.slider.getValue() + 3) / 8.0;
        double complete = (double)this.completeness.slider.getValue() / 100.0;
        this.z += ((s *= 1.7) - this.z) / creep;
        double r = s - complete * this.z;
        int[] y = new int[]{(int)r, (int)s};
        this.osc.setPosY(y);
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        this.timer.stop();
        this.osc.timer.stop();
    }
}

