/*
 * Decompiled with CFR 0.152.
 */
package com.neurolab;

import com.neurolab.common.NeurolabExhibit;
import com.neurolab.common.Oscilloscope;
import com.neurolab.common.ReturnButton;
import com.neurolab.common.Spacer;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.Timer;

public class ActPots
extends NeurolabExhibit
implements ActionListener {
    Button returnbutton;
    Oscilloscope osc;
    JPanel rightpanel;
    JPanel rupper;
    JPanel rlower;
    JPanel stimparams;
    JPanel sizepanel;
    JPanel polpanel;
    JPanel cvpanel;
    JCheckBox tea;
    JCheckBox ttx;
    JCheckBox ramp;
    JRadioButton positive;
    JRadioButton negative;
    JRadioButton current;
    JRadioButton voltage;
    JSlider size;
    JButton on;
    JLabel sizelabel;
    ButtonGroup i_or_v;
    ButtonGroup pos_or_neg;
    GridLayout bl1;
    BorderLayout bl2;
    JPanel onPanel;
    JPanel a;
    boolean stimulus_on;
    private Color[] oscColors = new Color[]{Color.green, Color.red, Color.blue, Color.yellow, Color.magenta};
    private int[] base = new int[]{60, 150, 151, 220, 260};
    private String[] label = new String[]{" V", " gNa", " gK", " I", " Stim"};
    Timer timer;
    private final float gK0 = 0.005f;
    private final float gKmax = 5.0f;
    private final float gNa0 = 2.0E-4f;
    private final float gNamax = 10.0f;
    float stim_size = 0.0f;
    float l10;
    float scale;
    float gNa;
    float gK;
    float Erest;
    float ENa;
    float EK;
    float E;
    float I;
    double n;
    double m;
    double h;

    public String getExhibitName() {
        return "Action Potentials";
    }

    public void init() {
        super.init();
        this.getMainContainer().setLayout(new BorderLayout());
        this.getMainContainer().setBackground(NeurolabExhibit.systemGray);
        this.createComponents();
        this.current.setSelected(true);
        this.positive.setSelected(true);
        this.size.setValue(75);
        this.initCalc();
        this.timer = new Timer(30, this);
        this.timer.start();
    }

    public void createComponents() {
        this.osc = new Oscilloscope(5, this){

            public void drawScreenElements(Graphics g) {
                g.setFont(new Font("Ariel", 1, 14));
                int i = 0;
                while (i < 5) {
                    g.setColor(Color.gray);
                    int gut = this.getGutter();
                    g.drawLine(gut, gut + this.baseY[i], this.getWidth() - 2 * gut, gut + this.baseY[i]);
                    if (i == 0) {
                        int yk = (int)ActPots.this.osc.graph.calcY(-2.0f * ActPots.this.EK, this.baseY[i]);
                        int yna = (int)ActPots.this.osc.graph.calcY(-2.0f * ActPots.this.ENa, this.baseY[i]);
                        g.drawLine(gut, yk, this.getWidth() - 2 * gut, yk);
                        g.drawLine(gut, yna, this.getWidth() - 2 * gut, yna);
                        g.drawString(" E(K)", gut, yk + 12);
                        g.drawString(" E(Na)", gut, yna);
                    }
                    g.setColor(this.getColors()[i]);
                    g.drawString(ActPots.this.label[i], gut, gut - 5 + this.baseY[i] + (i == 2 ? 20 : 0));
                    ++i;
                }
            }

            public Dimension getPreferredSize() {
                return new Dimension(400, 300);
            }
        };
        this.osc.setColors(this.oscColors);
        this.osc.setBaseY(this.base);
        this.osc.timer.setDelay(130);
        this.osc.xSpeed = 2;
        this.osc.buttons.remove(this.osc.clear);
        this.getMainContainer().add((Component)this.osc, "West");
        this.rightpanel = new JPanel();
        this.getMainContainer().add((Component)this.rightpanel, "East");
        this.rightpanel.setLayout(new BorderLayout());
        this.rupper = new JPanel();
        this.rightpanel.add((Component)this.rupper, "North");
        this.rlower = new JPanel();
        this.rightpanel.add((Component)this.rlower, "South");
        NeurolabExhibit.setBG(this.rightpanel);
        NeurolabExhibit.setBG(this.rupper);
        NeurolabExhibit.setBG(this.rlower);
        this.rlower.setLayout(new FlowLayout());
        this.tea = new JCheckBox("TEA");
        this.rlower.add(this.tea);
        this.ttx = new JCheckBox("TTX");
        this.rlower.add(this.ttx);
        this.rlower.add(new ReturnButton());
        NeurolabExhibit.setBG(this.tea);
        NeurolabExhibit.setBG(this.ttx);
        this.bl1 = new GridLayout(3, 1);
        this.rupper.setLayout(this.bl1);
        this.rupper.setBorder(BorderFactory.createTitledBorder(NeurolabExhibit.etched, "Stimulus"));
        this.cvpanel = new JPanel();
        this.rupper.add(this.cvpanel);
        this.cvpanel.setLayout(new BorderLayout());
        this.current = new JRadioButton("Current");
        this.cvpanel.add((Component)this.current, "North");
        this.voltage = new JRadioButton("Voltage, Clamped");
        this.cvpanel.add((Component)this.voltage, "Center");
        this.i_or_v = new ButtonGroup();
        this.i_or_v.add(this.current);
        this.i_or_v.add(this.voltage);
        this.cvpanel.add((Component)new Spacer(20, 20), "South");
        NeurolabExhibit.setBG(this.cvpanel);
        NeurolabExhibit.setBG(this.current);
        NeurolabExhibit.setBG(this.voltage);
        this.stimparams = new JPanel();
        this.rupper.add(this.stimparams);
        this.bl2 = new BorderLayout();
        this.stimparams.setLayout(this.bl2);
        this.stimparams.setBorder(NeurolabExhibit.etched);
        NeurolabExhibit.setBG(this.stimparams);
        this.sizepanel = new JPanel();
        this.stimparams.add((Component)this.sizepanel, "North");
        this.sizepanel.setLayout(new BorderLayout());
        this.sizelabel = new JLabel("          Size");
        this.sizepanel.add((Component)this.sizelabel, "West");
        this.size = new JSlider(0, 0, 100, 1){

            public Dimension getPreferredSize() {
                return new Dimension(100, 30);
            }
        };
        this.sizepanel.add((Component)this.size, "East");
        NeurolabExhibit.setBG(this.size);
        NeurolabExhibit.setBG(this.sizelabel);
        NeurolabExhibit.setBG(this.sizepanel);
        this.polpanel = new JPanel();
        this.stimparams.add((Component)this.polpanel, "West");
        this.polpanel.setLayout(new BorderLayout());
        this.positive = new JRadioButton("Positive");
        this.polpanel.add((Component)this.positive, "North");
        this.negative = new JRadioButton("Negative");
        this.polpanel.add((Component)this.negative, "South");
        this.pos_or_neg = new ButtonGroup();
        this.pos_or_neg.add(this.positive);
        this.pos_or_neg.add(this.negative);
        NeurolabExhibit.setBG(this.polpanel);
        NeurolabExhibit.setBG(this.positive);
        NeurolabExhibit.setBG(this.negative);
        this.ramp = new JCheckBox("Ramp");
        this.stimparams.add((Component)this.ramp, "East");
        NeurolabExhibit.setBG(this.ramp);
        this.onPanel = new JPanel();
        this.rupper.add(this.onPanel);
        this.onPanel.setBackground(NeurolabExhibit.systemGray);
        this.onPanel.setLayout(new GridLayout(3, 1));
        this.a = new JPanel();
        this.a.setBackground(NeurolabExhibit.systemGray);
        this.onPanel.add(this.a);
        this.on = new JButton("ON");
        this.onPanel.add(this.on);
        this.on.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ActPots.this.stimulus_on = true;
            }

            public void mouseReleased(MouseEvent e) {
                ActPots.this.stimulus_on = false;
            }
        });
        NeurolabExhibit.setBG(this.on);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Sweep") {
            this.restart();
            if (this.osc != null) {
                this.osc.graph.repaint();
            }
        } else {
            this.tick();
        }
    }

    public void initCalc() {
        this.l10 = (float)(1.0 / Math.log(10.0));
        this.EK = this.goldman(0.0f, 100.0f);
        this.ENa = this.goldman(100.0f, 0.0f);
        this.Erest = this.goldman(2.0E-4f, 0.005f);
        this.scale = 0.05f;
        this.restart();
    }

    public void restart() {
        this.gNa = 2.0E-4f;
        this.gK = 0.005f;
        this.E = this.Erest;
        this.n = 0.0;
        this.m = 0.0;
        this.h = 1.0;
    }

    public float goldman(float gn, float gk) {
        float r = (gn * 440.0f + gk * 20.0f) / (gn * 50.0f + gk * 400.0f);
        if (r > 0.0f) {
            return (float)((double)(61.0f * this.l10) * Math.log(r));
        }
        return 0.0f;
    }

    public void tick() {
        this.stim_size = this.stimulus_on ? (this.ramp.isSelected() ? (this.stim_size += (float)this.size.getValue() * 5.0E-4f * (this.negative.isSelected() ? -1.0f : 1.0f)) : (float)this.size.getValue() * 0.03f * (this.negative.isSelected() ? -1.0f : 1.0f)) : 0.0f;
        this.calculate_g();
        this.E = this.getVoltage(this.stim_size);
        this.displayValues();
    }

    public void displayValues() {
        int[] newpos = new int[]{(int)(-2.0f * this.E), (int)(-50.0f * this.gNa), (int)(-50.0f * this.gK), (int)(-1.0f * this.I), (int)(-50.0f * this.stim_size)};
        int i = 0;
        while (i < 5) {
            if (newpos[i] > 500 || newpos[i] < -500) {
                newpos[i] = 0;
            }
            ++i;
        }
        this.osc.setPosY(newpos);
    }

    public void calculate_g() {
        double vv = -50 - (int)this.E;
        double an = vv == -10.0 ? 0.1 : 0.01 * (vv + 10.0) / (Math.exp(vv / 10.0 + 1.0) - 1.0);
        double bn = 0.125 * Math.exp(vv / 80.0);
        double am = vv == -25.0 ? 1.0 : 0.1 * (vv + 25.0) / (Math.exp(vv / 10.0 + 2.5) - 1.0);
        double bm = 4.0 * Math.exp(vv / 18.0);
        double ah = 0.07 * Math.exp(vv / 20.0);
        double bh = 1.0 / (Math.exp(vv / 10.0 + 3.0) + 1.0);
        this.n += (double)this.scale * (an * (1.0 - this.n) - bn * this.n);
        this.m += (double)this.scale * (am * (1.0 - this.m) - bm * this.m);
        this.h += (double)this.scale * (ah * (1.0 - this.h) - bh * this.h);
        this.gK = this.tea.isSelected() ? 0.005f : (float)((double)0.005f + 5.0 * Math.pow(this.n, 4.0));
        this.gNa = this.ttx.isSelected() ? 2.0E-4f : (float)((double)2.0E-4f + 10.0 * this.h * Math.pow(this.m, 3.0));
    }

    public int getVoltage(float X) {
        int V = this.voltage.isSelected() ? -60 + (int)(X * 100.0f) : (int)this.goldman(this.gNa, this.gK);
        this.I = (float)(V - (int)this.ENa) * this.gNa + (float)(V - (int)this.EK) * this.gK;
        if (!this.voltage.isSelected()) {
            this.I += X / 1000.0f;
            V += (int)(0.02 * (double)X / (double)(this.gNa + this.gK));
        }
        return V;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        this.timer.stop();
        this.osc.timer.stop();
    }
}

