/*
 * Decompiled with CFR 0.152.
 */
package unit;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import unit.Units;

public class Unit
implements Serializable,
Cloneable {
    Vector bases = new Vector();
    boolean isBasis = false;
    public double multiplier = 1.0;
    public String commonName;
    public String abbreviation;
    public String quantity;
    public boolean canPrefix = true;
    private static final String digits = "012345";
    String[] prefix = new String[]{"n", "\u00b5", "m", "", "k", "M", "T"};
    private static String CONST = "None";

    Basis getBasis(Unit u) {
        int i = 0;
        while (i < this.bases.size()) {
            Basis b = (Basis)this.bases.elementAt(i);
            if (b.baseUnit == u) {
                return b;
            }
            ++i;
        }
        Basis b = new Basis();
        this.bases.addElement(b);
        b.baseUnit = u;
        return b;
    }

    protected Unit(String name, String abbr, String q) {
        this.commonName = name;
        this.abbreviation = abbr;
        this.quantity = q;
        this.isBasis = true;
    }

    public Unit(String unitString, double multiplier, String name, String abbr, String q, boolean canPrefix) {
        this(unitString, name, abbr, q);
        this.multiplier = multiplier;
        this.canPrefix = canPrefix;
    }

    public Unit(String unitString, double multiplier, String name, String abbr, String q) {
        this(unitString, name, abbr, q);
        this.multiplier = multiplier;
    }

    public Unit(String unitString, String name, String abbr, String q) {
        this(name, abbr, q);
        this.isBasis = false;
        int index = 1;
        boolean minus = false;
        boolean power = false;
        Unit lastUnit = null;
        StringTokenizer e = new StringTokenizer(unitString, "* ./^-12345", true);
        while (e.hasMoreTokens()) {
            int i;
            String token = e.nextToken();
            Enumeration ee = Units.elements();
            while (ee.hasMoreElements()) {
                String prefix;
                double mul;
                Unit u = (Unit)ee.nextElement();
                if (!u.commonName.equals(token) && !token.endsWith(u.abbreviation)) continue;
                this.multiplyBy(u, index);
                if (!(token.equals(u.abbreviation) || token.equals(u.commonName) || Double.isNaN(mul = this.getMultiplierFromPrefix(prefix = token.substring(0, token.length() - u.abbreviation.length()))))) {
                    this.multiplier *= Math.pow(this.getMultiplierFromPrefix(prefix), index);
                }
                if (index != -1) {
                    index = 1;
                }
                lastUnit = u;
                minus = false;
                power = false;
                break;
            }
            if (token.equals("/")) {
                index = -1;
            } else if (token.equals("-")) {
                minus = true;
            } else if (token.equals("^")) {
                power = true;
            }
            if (!power || (i = digits.indexOf(token)) < 0) continue;
            this.multiplyBy(lastUnit, index * (i - 1));
            minus = false;
            power = false;
            index = 1;
        }
    }

    public Unit(String unitString) {
        this(unitString, "", "", "");
    }

    public void multiplyBy(Unit u, int index) {
        if (u.isBasis) {
            Basis b = this.getBasis(u);
            b.power += index;
        } else {
            this.multiplier *= Math.pow(u.multiplier, index);
            int i = 0;
            while (i < u.bases.size()) {
                Basis b = (Basis)u.bases.elementAt(i);
                this.multiplyBy(b.baseUnit, b.power * index);
                ++i;
            }
        }
    }

    public String baseString() {
        String s = "";
        s = String.valueOf(s) + this.getMultiplierString();
        boolean first = true;
        int i = 0;
        while (i < this.bases.size()) {
            Basis b = (Basis)this.bases.elementAt(i);
            if (b.power != 0) {
                s = String.valueOf(s) + this.istr(b.power, b.baseUnit.abbreviation, first) + ' ';
                first = false;
            }
            ++i;
        }
        return s;
    }

    String istr(int i, String s, boolean first) {
        if (i == 0) {
            return "";
        }
        if (i == 1) {
            return s;
        }
        if (first || i > 0) {
            return String.valueOf(s) + "^" + i;
        }
        if (i == -1) {
            return "/" + s;
        }
        return "/" + s + "^" + -i;
    }

    public String getDescription() {
        String s = "";
        s = String.valueOf(s) + this.getMultiplierString();
        int i = 0;
        while (i < this.bases.size()) {
            Basis b = (Basis)this.bases.elementAt(i);
            s = String.valueOf(s) + b.baseUnit.abbreviation + ": " + b.power;
            ++i;
        }
        return s;
    }

    public String getMultiplierString() {
        if (!this.canPrefix) {
            return "";
        }
        if (this.multiplier == 1.0) {
            return "";
        }
        double k = Math.log(this.multiplier) / Math.log(10.0);
        int kk = (int)Math.round(k);
        if (Math.abs((double)kk - k) < 0.001) {
            if ((double)(kk / 3) == (double)kk / 3.0 && kk < 10 && kk > -10) {
                return this.prefix[kk / 3 + 3];
            }
            return "E" + kk + " ";
        }
        return "x" + this.multiplier + " ";
    }

    public double getMultiplierFromPrefix(String p) {
        String test = p.trim();
        int i = 0;
        while (i < this.prefix.length) {
            if (test.equals(this.prefix[i])) {
                return Math.pow(10.0, i * 3 - 9);
            }
            ++i;
        }
        return Double.NaN;
    }

    public String getSimpleName() {
        String s = this.tryFindSingleName();
        if (s != null) {
            return s;
        }
        return this.baseString();
    }

    public String toString() {
        return this.getSimpleName();
    }

    public boolean equalsInBasis(Unit u) {
        if (u == null) {
            return false;
        }
        if (u.isBasis && this.isBasis) {
            return this.commonName.equals(u.commonName);
        }
        if (u.isBasis) {
            if (this.bases.size() != 1) {
                return false;
            }
            Basis b = (Basis)this.bases.get(0);
            if (!b.baseUnit.commonName.equals(u.commonName)) {
                return false;
            }
            return b.power == 1;
        }
        if (this.isBasis) {
            return u.equalsInBasis(this);
        }
        if (this.bases.size() != u.bases.size()) {
            return false;
        }
        int found = 0;
        int i = 0;
        while (i < this.bases.size()) {
            Basis b = (Basis)this.bases.get(i);
            int j = 0;
            while (j < this.bases.size()) {
                Basis bb = (Basis)u.bases.get(j);
                if (b.baseUnit == bb.baseUnit) {
                    ++found;
                    if (b.power == bb.power) break;
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return found == this.bases.size();
    }

    public boolean equals(Unit u) {
        if (!this.equalsInBasis(u)) {
            return false;
        }
        return this.multiplier == u.multiplier;
    }

    String tryFindSingleName() {
        Enumeration e = Units.elements();
        while (e.hasMoreElements()) {
            Unit u = (Unit)e.nextElement();
            if (!this.equals(u)) continue;
            return u.abbreviation;
        }
        if (this.bases.size() == 0) {
            return CONST;
        }
        return null;
    }

    public Vector getCompatibleUnits() {
        Vector source = Units.units;
        Vector<Unit> result = new Vector<Unit>();
        boolean includesCurrent = false;
        int i = 0;
        while (i < source.size()) {
            Unit testUnit = (Unit)source.get(i);
            if (this.equalsInBasis(testUnit)) {
                result.add(testUnit);
                if (this.equals(testUnit)) {
                    includesCurrent = true;
                }
            }
            ++i;
        }
        if (!includesCurrent) {
            result.add(this);
        }
        return result;
    }

    public double getConversionTo(Unit u) {
        return this.multiplier / u.multiplier;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    class Basis
    implements Serializable {
        Unit baseUnit;
        int power = 0;

        Basis() {
        }
    }
}

