/*
 * Decompiled with CFR 0.152.
 */
package optimization;

import optimization.Blas_f77;
import optimization.Uncmin_methods;

public class Uncmin_f77 {
    public static void optif0_f77(int n, double[] x, Uncmin_methods minclass, double[] xpls, double[] fpls, double[] gpls, int[] itrmcd, double[][] a, double[] udiag) {
        int[] msg = new int[2];
        double[] typsiz = new double[n + 1];
        double[] g = new double[n + 1];
        double[] p = new double[n + 1];
        double[] sx = new double[n + 1];
        double[] wrk0 = new double[n + 1];
        double[] wrk1 = new double[n + 1];
        double[] wrk2 = new double[n + 1];
        double[] wrk3 = new double[n + 1];
        double[] dlt = new double[2];
        double[] fscale = new double[2];
        double[] stepmx = new double[2];
        int[] ndigit = new int[2];
        int[] method = new int[2];
        int[] iexp = new int[2];
        int[] itnlim = new int[2];
        int[] iagflg = new int[2];
        int[] iahflg = new int[2];
        double[] gradtl = new double[2];
        double[] steptl = new double[2];
        Uncmin_f77.dfault_f77(n, x, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl);
        Uncmin_f77.optdrv_f77(n, x, minclass, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl, xpls, fpls, gpls, itrmcd, a, udiag, g, p, sx, wrk0, wrk1, wrk2, wrk3);
        if (itrmcd[1] == 1) {
            System.out.print("\nUncmin WARNING --- itrmcd = 1, probably converged, gradient small\n\n");
        } else if (itrmcd[1] == 2) {
            System.out.print("\nUncmin WARNING --- itrmcd = 2, probably converged, stepsize small\n\n");
        } else if (itrmcd[1] == 3) {
            System.out.print("\nUncmin WARNING --- itrmcd = 3, cannot find lower point\n\n");
        } else if (itrmcd[1] == 4) {
            System.out.print("\nUncmin WARNING --- itrmcd = 4, too many iterations\n\n");
        } else if (itrmcd[1] == 5) {
            System.out.print("\nUncmin WARNING --- itrmcd = 5, too many large steps, possibly unbounded\n\n");
        }
    }

    public static void optif9_f77(int n, double[] x, Uncmin_methods minclass, double[] typsiz, double[] fscale, int[] method, int[] iexp, int[] msg, int[] ndigit, int[] itnlim, int[] iagflg, int[] iahflg, double[] dlt, double[] gradtl, double[] stepmx, double[] steptl, double[] xpls, double[] fpls, double[] gpls, int[] itrmcd, double[][] a, double[] udiag) {
        double[] g = new double[n + 1];
        double[] p = new double[n + 1];
        double[] sx = new double[n + 1];
        double[] wrk0 = new double[n + 1];
        double[] wrk1 = new double[n + 1];
        double[] wrk2 = new double[n + 1];
        double[] wrk3 = new double[n + 1];
        Uncmin_f77.optdrv_f77(n, x, minclass, typsiz, fscale, method, iexp, msg, ndigit, itnlim, iagflg, iahflg, dlt, gradtl, stepmx, steptl, xpls, fpls, gpls, itrmcd, a, udiag, g, p, sx, wrk0, wrk1, wrk2, wrk3);
        if (itrmcd[1] == 1) {
            System.out.print("\nUncmin WARNING --- itrmcd = 1, probably converged, gradient small\n\n");
        } else if (itrmcd[1] == 2) {
            System.out.print("\nUncmin WARNING --- itrmcd = 2, probably converged, stepsize small\n\n");
        } else if (itrmcd[1] == 3) {
            System.out.print("\nUncmin WARNING --- itrmcd = 3, cannot find lower point\n\n");
        } else if (itrmcd[1] == 4) {
            System.out.print("\nUncmin WARNING --- itrmcd = 4, too many iterations\n\n");
        } else if (itrmcd[1] == 5) {
            System.out.print("\nUncmin WARNING --- itrmcd = 5, too many large steps, possibly unbounded\n\n");
        }
    }

    public static void bakslv_f77(int n, double[][] a, double[] x, double[] b) {
        int i = n;
        x[i] = b[i] / a[i][i];
        while (i > 1) {
            int ip1 = i--;
            double sum = 0.0;
            int j = ip1;
            while (j <= n) {
                sum += a[j][i] * x[j];
                ++j;
            }
            x[i] = (b[i] - sum) / a[i][i];
        }
    }

    public static void chlhsn_f77(int n, double[][] a, double epsm, double[] sx, double[] udiag) {
        int im1;
        double amu;
        int i;
        double[] addmax = new double[2];
        int j = 1;
        while (j <= n) {
            i = j;
            while (i <= n) {
                double[] dArray = a[i];
                int n2 = j;
                dArray[n2] = dArray[n2] / (sx[i] * sx[j]);
                ++i;
            }
            ++j;
        }
        double tol = Math.sqrt(epsm);
        double diagmx = a[1][1];
        double diagmn = a[1][1];
        i = 2;
        while (i <= n) {
            if (a[i][i] < diagmn) {
                diagmn = a[i][i];
            }
            if (a[i][i] > diagmx) {
                diagmx = a[i][i];
            }
            ++i;
        }
        double posmax = Math.max(diagmx, 0.0);
        if (diagmn <= posmax * tol) {
            amu = tol * (posmax - diagmn) - diagmn;
            if (amu == 0.0) {
                double offmax = 0.0;
                i = 2;
                while (i <= n) {
                    im1 = i - 1;
                    j = 1;
                    while (j <= im1) {
                        if (Math.abs(a[i][j]) > offmax) {
                            offmax = Math.abs(a[i][j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                amu = offmax;
                amu = amu == 0.0 ? 1.0 : (amu *= 1.0 + tol);
            }
            i = 1;
            while (i <= n) {
                double[] dArray = a[i];
                int n3 = i++;
                dArray[n3] = dArray[n3] + amu;
            }
            diagmx += amu;
        }
        j = 1;
        while (j <= n) {
            udiag[j] = a[j][j];
            i = j + 1;
            while (i <= n) {
                a[j][i] = a[i][j];
                ++i;
            }
            ++j;
        }
        Uncmin_f77.choldc_f77(n, a, diagmx, tol, addmax);
        if (addmax[1] > 0.0) {
            j = 1;
            while (j <= n) {
                a[j][j] = udiag[j];
                i = j + 1;
                while (i <= n) {
                    a[i][j] = a[j][i];
                    ++i;
                }
                ++j;
            }
            double evmin = 0.0;
            double evmax = a[1][1];
            i = 1;
            while (i <= n) {
                double offrow = 0.0;
                im1 = i - 1;
                j = 1;
                while (j <= im1) {
                    offrow += Math.abs(a[i][j]);
                    ++j;
                }
                j = i + 1;
                while (j <= n) {
                    offrow += Math.abs(a[j][i]);
                    ++j;
                }
                evmin = Math.min(evmin, a[i][i] - offrow);
                evmax = Math.max(evmax, a[i][i] + offrow);
                ++i;
            }
            double sdd = tol * (evmax - evmin) - evmin;
            amu = Math.min(sdd, addmax[1]);
            i = 1;
            while (i <= n) {
                double[] dArray = a[i];
                int n4 = i;
                dArray[n4] = dArray[n4] + amu;
                udiag[i] = a[i][i];
                ++i;
            }
            Uncmin_f77.choldc_f77(n, a, 0.0, tol, addmax);
        }
        j = 1;
        while (j <= n) {
            i = j;
            while (i <= n) {
                double[] dArray = a[i];
                int n5 = j;
                dArray[n5] = dArray[n5] * sx[i];
                ++i;
            }
            int jm1 = j - 1;
            i = 1;
            while (i <= jm1) {
                double[] dArray = a[i];
                int n6 = j;
                dArray[n6] = dArray[n6] * (sx[i] * sx[j]);
                ++i;
            }
            int n7 = j;
            udiag[n7] = udiag[n7] * (sx[j] * sx[j]);
            ++j;
        }
    }

    public static void choldc_f77(int n, double[][] a, double diagmx, double tol, double[] addmax) {
        addmax[1] = 0.0;
        double aminl = Math.sqrt(diagmx * tol);
        double amnlsq = aminl * aminl;
        int j = 1;
        while (j <= n) {
            int i;
            double sum = 0.0;
            int jm1 = j - 1;
            int jp1 = j + 1;
            int k = 1;
            while (k <= jm1) {
                sum += a[j][k] * a[j][k];
                ++k;
            }
            double temp = a[j][j] - sum;
            if (temp >= amnlsq) {
                a[j][j] = Math.sqrt(temp);
            } else {
                double offmax = 0.0;
                i = jp1;
                while (i <= n) {
                    if (Math.abs(a[i][j]) > offmax) {
                        offmax = Math.abs(a[i][j]);
                    }
                    ++i;
                }
                if (offmax <= amnlsq) {
                    offmax = amnlsq;
                }
                a[j][j] = Math.sqrt(offmax);
                addmax[1] = Math.max(addmax[1], offmax - temp);
            }
            i = jp1;
            while (i <= n) {
                sum = 0.0;
                k = 1;
                while (k <= jm1) {
                    sum += a[i][k] * a[j][k];
                    ++k;
                }
                a[i][j] = (a[i][j] - sum) / a[j][j];
                ++i;
            }
            ++j;
        }
    }

    public static void dfault_f77(int n, double[] x, double[] typsiz, double[] fscale, int[] method, int[] iexp, int[] msg, int[] ndigit, int[] itnlim, int[] iagflg, int[] iahflg, double[] dlt, double[] gradtl, double[] stepmx, double[] steptl) {
        int i = 1;
        while (i <= n) {
            typsiz[i] = 1.0;
            ++i;
        }
        fscale[1] = 1.0;
        dlt[1] = -1.0;
        double epsm = 1.12E-16;
        gradtl[1] = Math.pow(epsm, 0.3333333333333333);
        steptl[1] = Math.sqrt(epsm);
        stepmx[1] = 0.0;
        method[1] = 1;
        iexp[1] = 1;
        msg[1] = 0;
        ndigit[1] = -1;
        itnlim[1] = 150;
        iagflg[1] = 0;
        iahflg[1] = 0;
    }

    public static void dogdrv_f77(int n, double[] x, double[] f, double[] g, double[][] a, double[] p, double[] xpls, double[] fpls, Uncmin_methods minclass, double[] sx, double[] stepmx, double[] steptl, double[] dlt, int[] iretcd, boolean[] mxtake, double[] sc, double[] wrk1, double[] wrk2, double[] wrk3) {
        double[] fplsp = new double[2];
        double[] cln = new double[2];
        double[] eta = new double[2];
        boolean[] fstdog = new boolean[2];
        boolean[] nwtake = new boolean[2];
        iretcd[1] = 4;
        fstdog[1] = true;
        double tmp = 0.0;
        int i = 1;
        while (i <= n) {
            tmp += sx[i] * sx[i] * p[i] * p[i];
            ++i;
        }
        double rnwtln = Math.sqrt(tmp);
        while (iretcd[1] > 1) {
            Uncmin_f77.dogstp_f77(n, g, a, p, sx, rnwtln, dlt, nwtake, fstdog, wrk1, wrk2, cln, eta, sc, stepmx);
            Uncmin_f77.tregup_f77(n, x, f, g, a, minclass, sc, sx, nwtake, stepmx, steptl, dlt, iretcd, wrk3, fplsp, xpls, fpls, mxtake, 2, wrk1);
        }
    }

    public static void dogstp_f77(int n, double[] g, double[][] a, double[] p, double[] sx, double rnwtln, double[] dlt, boolean[] nwtake, boolean[] fstdog, double[] ssd, double[] v, double[] cln, double[] eta, double[] sc, double[] stepmx) {
        if (rnwtln <= dlt[1]) {
            nwtake[1] = true;
            int i = 1;
            while (i <= n) {
                sc[i] = p[i];
                ++i;
            }
            dlt[1] = rnwtln;
        } else {
            int i;
            nwtake[1] = false;
            if (fstdog[1]) {
                fstdog[1] = false;
                double alpha = 0.0;
                i = 1;
                while (i <= n) {
                    alpha += g[i] * g[i] / (sx[i] * sx[i]);
                    ++i;
                }
                double beta = 0.0;
                i = 1;
                while (i <= n) {
                    double tmp = 0.0;
                    int j = i;
                    while (j <= n) {
                        tmp += a[j][i] * g[j] / (sx[j] * sx[j]);
                        ++j;
                    }
                    beta += tmp * tmp;
                    ++i;
                }
                i = 1;
                while (i <= n) {
                    ssd[i] = -(alpha / beta) * g[i] / sx[i];
                    ++i;
                }
                cln[1] = alpha * Math.sqrt(alpha) / beta;
                eta[1] = 0.2 + 0.8 * alpha * alpha / (-beta * Blas_f77.ddot_f77(n, g, 1, p, 1));
                i = 1;
                while (i <= n) {
                    v[i] = eta[1] * sx[i] * p[i] - ssd[i];
                    ++i;
                }
                if (dlt[1] == -1.0) {
                    dlt[1] = Math.min(cln[1], stepmx[1]);
                }
            }
            if (eta[1] * rnwtln <= dlt[1]) {
                i = 1;
                while (i <= n) {
                    sc[i] = dlt[1] / rnwtln * p[i];
                    ++i;
                }
            } else if (cln[1] >= dlt[1]) {
                i = 1;
                while (i <= n) {
                    sc[i] = dlt[1] / cln[1] * ssd[i] / sx[i];
                    ++i;
                }
            } else {
                double dot1 = Blas_f77.ddot_f77(n, v, 1, ssd, 1);
                double dot2 = Blas_f77.ddot_f77(n, v, 1, v, 1);
                double alam = (-dot1 + Math.sqrt(dot1 * dot1 - dot2 * (cln[1] * cln[1] - dlt[1] * dlt[1]))) / dot2;
                i = 1;
                while (i <= n) {
                    sc[i] = (ssd[i] + alam * v[i]) / sx[i];
                    ++i;
                }
            }
        }
    }

    public static void forslv_f77(int n, double[][] a, double[] x, double[] b) {
        x[1] = b[1] / a[1][1];
        int i = 2;
        while (i <= n) {
            double sum = 0.0;
            int im1 = i - 1;
            int j = 1;
            while (j <= im1) {
                sum += a[i][j] * x[j];
                ++j;
            }
            x[i] = (b[i] - sum) / a[i][i];
            ++i;
        }
    }

    public static void fstocd_f77(int n, double[] x, Uncmin_methods minclass, double[] sx, double rnoise, double[] g) {
        double xmult = Math.pow(rnoise, 0.3333333333333333);
        int i = 1;
        while (i <= n) {
            double stepi = xmult * Math.max(Math.abs(x[i]), 1.0 / sx[i]);
            double xtempi = x[i];
            x[i] = xtempi + stepi;
            double fplus = minclass.f_to_minimize(x);
            x[i] = xtempi - stepi;
            double fminus = minclass.f_to_minimize(x);
            x[i] = xtempi;
            g[i] = (fplus - fminus) / (2.0 * stepi);
            ++i;
        }
    }

    public static void fstofd_f77(int n, double[] xpls, Uncmin_methods minclass, double[] fpls, double[][] a, double[] sx, double rnoise, double[] fhat) {
        int i;
        double xmult = Math.sqrt(rnoise);
        int j = 1;
        while (j <= n) {
            double stepsz = xmult * Math.max(Math.abs(xpls[j]), 1.0 / sx[j]);
            double xtmpj = xpls[j];
            xpls[j] = xtmpj + stepsz;
            minclass.gradient(xpls, fhat);
            xpls[j] = xtmpj;
            i = 1;
            while (i <= n) {
                a[i][j] = (fhat[i] - fpls[i]) / stepsz;
                ++i;
            }
            ++j;
        }
        int nm1 = n - 1;
        j = 1;
        while (j <= nm1) {
            i = j + 1;
            while (i <= n) {
                a[i][j] = (a[i][j] + a[j][i]) / 2.0;
                ++i;
            }
            ++j;
        }
    }

    public static void fstofd_f77(int n, double[] xpls, Uncmin_methods minclass, double[] fpls, double[] g, double[] sx, double rnoise) {
        double xmult = Math.sqrt(rnoise);
        int j = 1;
        while (j <= n) {
            double stepsz = xmult * Math.max(Math.abs(xpls[j]), 1.0 / sx[j]);
            double xtmpj = xpls[j];
            xpls[j] = xtmpj + stepsz;
            double fhat = minclass.f_to_minimize(xpls);
            xpls[j] = xtmpj;
            g[j] = (fhat - fpls[1]) / stepsz;
            ++j;
        }
    }

    public static void grdchk_f77(int n, double[] x, Uncmin_methods minclass, double[] f, double[] g, double[] typsiz, double[] sx, double[] fscale, double rnf, double analtl, double[] gest) {
        Uncmin_f77.fstofd_f77(n, x, minclass, f, gest, sx, rnf);
        boolean ker = false;
        int i = 1;
        while (i <= n) {
            double gs = Math.max(Math.abs(f[1]), fscale[1]) / Math.max(Math.abs(x[i]), typsiz[i]);
            if (Math.abs(g[i] - gest[i]) > Math.max(Math.abs(g[i]), gs) * analtl) {
                ker = true;
            }
            ++i;
        }
        if (!ker) {
            return;
        }
        System.out.print("\nThere appears to be an error in the coding");
        System.out.print(" of the gradient method.\n\n\n");
        System.out.print("Component   Analytic   Finite Difference\n\n");
        i = 1;
        while (i <= n) {
            System.out.println(String.valueOf(i) + "  " + g[i] + "  " + gest[i]);
            ++i;
        }
        throw new IllegalArgumentException("gradient error");
    }

    public static void heschk_f77(int n, double[] x, Uncmin_methods minclass, double[] f, double[] g, double[][] a, double[] typsiz, double[] sx, double rnf, double analtl, int[] iagflg, double[] udiag, double[] wrk1, double[] wrk2) {
        int i;
        if (iagflg[1] == 1) {
            Uncmin_f77.fstofd_f77(n, x, minclass, g, a, sx, rnf, wrk1);
        }
        if (iagflg[1] != 1) {
            Uncmin_f77.sndofd_f77(n, x, minclass, f, a, sx, rnf, wrk1, wrk2);
        }
        boolean ker = false;
        int j = 1;
        while (j <= n) {
            udiag[j] = a[j][j];
            i = j + 1;
            while (i <= n) {
                a[j][i] = a[i][j];
                ++i;
            }
            ++j;
        }
        minclass.hessian(x, a);
        j = 1;
        while (j <= n) {
            double hs = Math.max(Math.abs(g[j]), 1.0) / Math.max(Math.abs(x[j]), typsiz[j]);
            if (Math.abs(a[j][j] - udiag[j]) > Math.max(Math.abs(udiag[j]), hs) * analtl) {
                ker = true;
            }
            i = j + 1;
            while (i <= n) {
                if (Math.abs(a[i][j] - a[j][i]) > Math.max(Math.abs(a[i][j]), hs) * analtl) {
                    ker = true;
                }
                ++i;
            }
            ++j;
        }
        if (!ker) {
            return;
        }
        System.out.print("\nThere appears to be an error in the coding");
        System.out.print(" of the Hessian method.\n\n\n");
        System.out.print("Row   Column   Analytic   Finite Difference\n\n");
        i = 1;
        while (i <= n) {
            j = 1;
            while (j < i) {
                System.out.println(String.valueOf(i) + "  " + j + "  " + a[i][j] + "  " + a[j][i]);
                ++j;
            }
            System.out.println(String.valueOf(i) + "  " + i + "  " + a[i][i] + "  " + udiag[i]);
            ++i;
        }
        throw new IllegalArgumentException("Error in hessian");
    }

    public static void hookdr_f77(int n, double[] x, double[] f, double[] g, double[][] a, double[] udiag, double[] p, double[] xpls, double[] fpls, Uncmin_methods minclass, double[] sx, double[] stepmx, double[] steptl, double[] dlt, int[] iretcd, boolean[] mxtake, double[] amu, double[] dltp, double[] phi, double[] phip0, double[] sc, double[] xplsp, double[] wrk0, double epsm, int[] itncnt) {
        boolean[] fstime = new boolean[2];
        boolean[] nwtake = new boolean[2];
        double[] fplsp = new double[2];
        iretcd[1] = 4;
        fstime[1] = true;
        double tmp = 0.0;
        int i = 1;
        while (i <= n) {
            tmp += sx[i] * sx[i] * p[i] * p[i];
            ++i;
        }
        double rnwtln = Math.sqrt(tmp);
        if (itncnt[1] == 1) {
            amu[1] = 0.0;
            if (dlt[1] == -1.0) {
                double alpha = 0.0;
                i = 1;
                while (i <= n) {
                    alpha += g[i] * g[i] / (sx[i] * sx[i]);
                    ++i;
                }
                double beta = 0.0;
                i = 1;
                while (i <= n) {
                    tmp = 0.0;
                    int j = i;
                    while (j <= n) {
                        tmp += a[j][i] * g[j] / (sx[j] * sx[j]);
                        ++j;
                    }
                    beta += tmp * tmp;
                    ++i;
                }
                dlt[1] = alpha * Math.sqrt(alpha) / beta;
                dlt[1] = Math.min(dlt[1], stepmx[1]);
            }
        }
        while (iretcd[1] > 1) {
            Uncmin_f77.hookst_f77(n, g, a, udiag, p, sx, rnwtln, dlt, amu, dltp, phi, phip0, fstime, sc, nwtake, wrk0, epsm);
            dltp[1] = dlt[1];
            Uncmin_f77.tregup_f77(n, x, f, g, a, minclass, sc, sx, nwtake, stepmx, steptl, dlt, iretcd, xplsp, fplsp, xpls, fpls, mxtake, 3, udiag);
        }
    }

    public static void hookst_f77(int n, double[] g, double[][] a, double[] udiag, double[] p, double[] sx, double rnwtln, double[] dlt, double[] amu, double[] dltp, double[] phi, double[] phip0, boolean[] fstime, double[] sc, boolean[] nwtake, double[] wrk0, double epsm) {
        int i;
        double[] addmax = new double[2];
        double phip = 0.0;
        double hi = 1.5;
        double alo = 0.75;
        if (rnwtln <= hi * dlt[1]) {
            nwtake[1] = true;
            int i2 = 1;
            while (i2 <= n) {
                sc[i2] = p[i2];
                ++i2;
            }
            dlt[1] = Math.min(dlt[1], rnwtln);
            amu[1] = 0.0;
            return;
        }
        nwtake[1] = false;
        if (amu[1] > 0.0) {
            amu[1] = amu[1] - (phi[1] + dltp[1]) * (dltp[1] - dlt[1] + phi[1]) / (dlt[1] * phip);
        }
        phi[1] = rnwtln - dlt[1];
        if (fstime[1]) {
            i = 1;
            while (i <= n) {
                wrk0[i] = sx[i] * sx[i] * p[i];
                ++i;
            }
            Uncmin_f77.forslv_f77(n, a, wrk0, wrk0);
            phip0[1] = -Math.pow(Blas_f77.dnrm2_f77(n, wrk0, 1), 2.0) / rnwtln;
            fstime[1] = false;
        }
        phip = phip0[1];
        double amulo = -phi[1] / phip;
        double amuup = 0.0;
        i = 1;
        while (i <= n) {
            amuup += g[i] * g[i] / (sx[i] * sx[i]);
            ++i;
        }
        amuup = Math.sqrt(amuup) / dlt[1];
        boolean done = false;
        while (!done) {
            if (amu[1] < amulo || amu[1] > amuup) {
                amu[1] = Math.max(Math.sqrt(amulo * amuup), amuup * 0.001);
            }
            int j = 1;
            while (j <= n) {
                a[j][j] = udiag[j] + amu[1] * sx[j] * sx[j];
                i = j + 1;
                while (i <= n) {
                    a[i][j] = a[j][i];
                    ++i;
                }
                ++j;
            }
            Uncmin_f77.choldc_f77(n, a, 0.0, Math.sqrt(epsm), addmax);
            i = 1;
            while (i <= n) {
                wrk0[i] = -g[i];
                ++i;
            }
            Uncmin_f77.lltslv_f77(n, a, sc, wrk0);
            double stepln = 0.0;
            i = 1;
            while (i <= n) {
                stepln += sx[i] * sx[i] * sc[i] * sc[i];
                ++i;
            }
            stepln = Math.sqrt(stepln);
            phi[1] = stepln - dlt[1];
            i = 1;
            while (i <= n) {
                wrk0[i] = sx[i] * sx[i] * sc[i];
                ++i;
            }
            Uncmin_f77.forslv_f77(n, a, wrk0, wrk0);
            phip = -Math.pow(Blas_f77.dnrm2_f77(n, wrk0, 1), 2.0) / stepln;
            if (alo * dlt[1] <= stepln && stepln <= hi * dlt[1] || amuup - amulo <= 0.0) {
                done = true;
                continue;
            }
            amulo = Math.max(amulo, amu[1] - phi[1] / phip);
            if (phi[1] < 0.0) {
                amuup = Math.min(amuup, amu[1]);
            }
            amu[1] = amu[1] - stepln * phi[1] / (dlt[1] * phip);
        }
    }

    public static void hsnint_f77(int n, double[][] a, double[] sx, int[] method) {
        int j = 1;
        while (j <= n) {
            a[j][j] = method[1] == 3 ? sx[j] * sx[j] : sx[j];
            int i = j + 1;
            while (i <= n) {
                a[i][j] = 0.0;
                ++i;
            }
            ++j;
        }
    }

    public static void lltslv_f77(int n, double[][] a, double[] x, double[] b) {
        Uncmin_f77.forslv_f77(n, a, x, b);
        Uncmin_f77.bakslv_f77(n, a, x, x);
    }

    public static void lnsrch_f77(int n, double[] x, double[] f, double[] g, double[] p, double[] xpls, double[] fpls, Uncmin_methods minclass, boolean[] mxtake, int[] iretcd, double[] stepmx, double[] steptl, double[] sx) {
        double pfpls = 0.0;
        double plmbda = 0.0;
        mxtake[1] = false;
        iretcd[1] = 2;
        double tmp = 0.0;
        int i = 1;
        while (i <= n) {
            tmp += sx[i] * sx[i] * p[i] * p[i];
            ++i;
        }
        double sln = Math.sqrt(tmp);
        if (sln > stepmx[1]) {
            double scl = stepmx[1] / sln;
            Uncmin_f77.sclmul_f77(n, scl, p, p);
            sln = stepmx[1];
        }
        double slp = Blas_f77.ddot_f77(n, g, 1, p, 1);
        double rln = 0.0;
        i = 1;
        while (i <= n) {
            rln = Math.max(rln, Math.abs(p[i]) / Math.max(Math.abs(x[i]), 1.0 / sx[i]));
            ++i;
        }
        double rmnlmb = steptl[1] / rln;
        double almbda = 1.0;
        while (iretcd[1] >= 2) {
            double tlmbda;
            i = 1;
            while (i <= n) {
                xpls[i] = x[i] + almbda * p[i];
                ++i;
            }
            fpls[1] = minclass.f_to_minimize(xpls);
            if (fpls[1] <= f[1] + slp * 1.0E-4 * almbda) {
                iretcd[1] = 0;
                if (almbda != 1.0 || !(sln > 0.99 * stepmx[1])) continue;
                mxtake[1] = true;
                continue;
            }
            if (almbda < rmnlmb) {
                iretcd[1] = 1;
                continue;
            }
            if (almbda == 1.0) {
                tlmbda = -slp / (2.0 * (fpls[1] - f[1] - slp));
            } else {
                double t3 = 1.0 / (almbda - plmbda);
                double t2 = pfpls - f[1] - plmbda * slp;
                double t1 = fpls[1] - f[1] - almbda * slp;
                double b = t3 * (t2 * almbda / (plmbda * plmbda) - t1 * plmbda / (almbda * almbda));
                double a = t3 * (t1 / (almbda * almbda) - t2 / (plmbda * plmbda));
                double disc = b * b - 3.0 * a * slp;
                tlmbda = disc > b * b ? (-b + Blas_f77.sign_f77(1.0, a) * Math.sqrt(disc)) / (3.0 * a) : (-b - Blas_f77.sign_f77(1.0, a) * Math.sqrt(disc)) / (3.0 * a);
                if (tlmbda > 0.5 * almbda) {
                    tlmbda = 0.5 * almbda;
                }
            }
            plmbda = almbda;
            pfpls = fpls[1];
            if (tlmbda < almbda / 10.0) {
                almbda *= 0.1;
                continue;
            }
            almbda = tlmbda;
        }
    }

    public static void mvmltl_f77(int n, double[][] a, double[] x, double[] y) {
        int i = 1;
        while (i <= n) {
            double sum = 0.0;
            int j = 1;
            while (j <= i) {
                sum += a[i][j] * x[j];
                ++j;
            }
            y[i] = sum;
            ++i;
        }
    }

    public static void mvmlts_f77(int n, double[][] a, double[] x, double[] y) {
        int i = 1;
        while (i <= n) {
            double sum = 0.0;
            int j = 1;
            while (j <= i) {
                sum += a[i][j] * x[j];
                ++j;
            }
            j = i + 1;
            while (j <= n) {
                sum += a[j][i] * x[j];
                ++j;
            }
            y[i] = sum;
            ++i;
        }
    }

    public static void mvmltu_f77(int n, double[][] a, double[] x, double[] y) {
        int i = 1;
        while (i <= n) {
            double sum = 0.0;
            int j = i;
            while (j <= n) {
                sum += a[j][i] * x[j];
                ++j;
            }
            y[i] = sum;
            ++i;
        }
    }

    public static void optchk_f77(int n, double[] x, double[] typsiz, double[] sx, double[] fscale, double[] gradtl, int[] itnlim, int[] ndigit, double epsm, double[] dlt, int[] method, int[] iexp, int[] iagflg, int[] iahflg, double[] stepmx, int[] msg) {
        if (method[1] < 1 || method[1] > 3) {
            method[1] = 1;
        }
        if (iagflg[1] != 1) {
            iagflg[1] = 0;
        }
        if (iahflg[1] != 1) {
            iahflg[1] = 0;
        }
        if (iexp[1] != 0) {
            iexp[1] = 1;
        }
        if (msg[1] / 2 % 2 == 1 && iagflg[1] == 0) {
            System.out.print("\n\nOPTCHK   User requests that analytic gradient");
            System.out.print(" be accepted as properly coded,\n");
            System.out.print("OPTCHK   msg = " + msg + ",\n");
            System.out.print("OPTCHK   but an analytic gradient is not");
            System.out.print(" supplied,\n");
            System.out.print("OPTCHK   iagflg = " + iagflg[1] + ".\n\n");
            throw new IllegalArgumentException("Analytic gradient not supplied");
        }
        if (msg[1] / 4 % 2 == 1 && iahflg[1] == 0) {
            System.out.print("\n\nOPTCHK   User requests that analytic Hessian");
            System.out.print(" be accepted as properly coded,\n");
            System.out.print("OPTCHK   msg = " + msg + ",\n");
            System.out.print("OPTCHK   but an analytic Hessian is not");
            System.out.print(" supplied,\n");
            System.out.print("OPTCHK   iahflg = " + iahflg[1] + ".\n\n");
            throw new IllegalArgumentException("Analytic hessian not supplied");
        }
        if (n <= 0) {
            System.out.print("\n\nOPTCHK   Illegal dimension, n = " + n + "\n\n");
            throw new IllegalArgumentException("Illegal dimension");
        }
        if (n == 1 && msg[1] % 2 == 0) {
            System.out.print("\n\nOPTCHK   !!!WARNING!!!  This class is ");
            System.out.print("inefficient for problems of size 1.\n");
            System.out.print("OPTCHK   You might want to try Fmin instead.\n\n");
            msg[1] = -2;
        }
        int i = 1;
        while (i <= n) {
            if (typsiz[i] == 0.0) {
                typsiz[i] = 1.0;
            }
            if (typsiz[i] < 0.0) {
                typsiz[i] = -typsiz[i];
            }
            sx[i] = 1.0 / typsiz[i];
            ++i;
        }
        if (stepmx[1] <= 0.0) {
            double stpsiz = 0.0;
            i = 1;
            while (i <= n) {
                stpsiz += x[i] * x[i] * sx[i] * sx[i];
                ++i;
            }
            stpsiz = Math.sqrt(stpsiz);
            stepmx[1] = Math.max(1000.0 * stpsiz, 1000.0);
        }
        if (fscale[1] == 0.0) {
            fscale[1] = 1.0;
        }
        if (fscale[1] < 0.0) {
            fscale[1] = -fscale[1];
        }
        if (gradtl[1] < 0.0) {
            System.out.print("\n\nOPTCHK   Illegal tolerance, gradtl = " + gradtl[1] + "\n\n");
            throw new IllegalArgumentException("Illegal tolerance");
        }
        if (itnlim[1] < 0) {
            System.out.print("\n\nOPTCHK   Illegal iteration limit,");
            System.out.print(" itnlim = " + itnlim[1] + "\n\n");
            throw new IllegalArgumentException("Illegal iteration limit");
        }
        if (ndigit[1] == 0) {
            System.out.print("\n\nOPTCHK   Minimization function has no good");
            System.out.print(" digits, ndigit = " + ndigit + "\n\n");
            throw new IllegalArgumentException("Minimisation function has no good digits");
        }
        if (ndigit[1] < 0) {
            ndigit[1] = (int)(-Math.log(epsm) / Math.log(10.0));
        }
        if (dlt[1] <= 0.0) {
            dlt[1] = -1.0;
        }
        if (dlt[1] > stepmx[1]) {
            dlt[1] = stepmx[1];
        }
    }

    public static void optdrv_f77(int n, double[] x, Uncmin_methods minclass, double[] typsiz, double[] fscale, int[] method, int[] iexp, int[] msg, int[] ndigit, int[] itnlim, int[] iagflg, int[] iahflg, double[] dlt, double[] gradtl, double[] stepmx, double[] steptl, double[] xpls, double[] fpls, double[] gpls, int[] itrmcd, double[][] a, double[] udiag, double[] g, double[] p, double[] sx, double[] wrk0, double[] wrk1, double[] wrk2, double[] wrk3) {
        boolean[] noupdt = new boolean[2];
        boolean[] mxtake = new boolean[2];
        int[] icscmx = new int[2];
        int[] iretcd = new int[2];
        int[] itncnt = new int[2];
        double[] f = new double[2];
        double[] amu = new double[2];
        double[] dltp = new double[2];
        double[] phi = new double[2];
        double[] phip0 = new double[2];
        double phpsav = 0.0;
        double phisav = 0.0;
        double dlpsav = 0.0;
        double amusav = 0.0;
        double dltsav = 0.0;
        int i = 1;
        while (i <= n) {
            p[i] = 0.0;
            ++i;
        }
        itncnt[1] = 0;
        iretcd[1] = -1;
        double epsm = 1.12E-16;
        Uncmin_f77.optchk_f77(n, x, typsiz, sx, fscale, gradtl, itnlim, ndigit, epsm, dlt, method, iexp, iagflg, iahflg, stepmx, msg);
        double rnf = Math.max(Math.pow(10.0, -ndigit[1]), epsm);
        double analtl = Math.max(0.01, Math.sqrt(rnf));
        if (msg[1] / 8 % 2 != 1) {
            int j;
            int num5 = n / 5;
            int remain = n % 5;
            System.out.print("\n\nOPTDRV          Typical x\n\n");
            int ilow = -4;
            int ihigh = 0;
            i = 1;
            while (i <= num5) {
                System.out.print(String.valueOf(ilow += 5) + "--" + (ihigh += 5) + "     ");
                j = 1;
                while (j <= 5) {
                    System.out.print(String.valueOf(typsiz[ilow + j - 1]) + "  ");
                    ++j;
                }
                System.out.print("\n");
                ++i;
            }
            ihigh = (ilow += 5) + remain - 1;
            System.out.print(String.valueOf(ilow) + "--" + ihigh + "     ");
            j = 1;
            while (j <= remain) {
                System.out.print(String.valueOf(typsiz[ilow + j - 1]) + "  ");
                ++j;
            }
            System.out.print("\n");
            System.out.print("\n\nOPTDRV      Scaling vector for x\n\n");
            ilow = -4;
            ihigh = 0;
            i = 1;
            while (i <= num5) {
                System.out.print(String.valueOf(ilow += 5) + "--" + (ihigh += 5) + "     ");
                j = 1;
                while (j <= 5) {
                    System.out.print(String.valueOf(sx[ilow + j - 1]) + "  ");
                    ++j;
                }
                System.out.print("\n");
                ++i;
            }
            ihigh = (ilow += 5) + remain - 1;
            System.out.print(String.valueOf(ilow) + "--" + ihigh + "     ");
            j = 1;
            while (j <= remain) {
                System.out.print(String.valueOf(sx[ilow + j - 1]) + "  ");
                ++j;
            }
            System.out.print("\n");
            System.out.println("\n\nOPTDRV      Typical f = " + fscale[1]);
            System.out.print("OPTDRV      Number of good digits in");
            System.out.println(" f_to_minimize = " + ndigit[1]);
            System.out.print("OPTDRV      Gradient flag");
            System.out.println(" = " + iagflg[1]);
            System.out.print("OPTDRV      Hessian flag");
            System.out.println(" = " + iahflg[1]);
            System.out.print("OPTDRV      Expensive function calculation flag");
            System.out.println(" = " + iexp[1]);
            System.out.print("OPTDRV      Method to use");
            System.out.println(" = " + method[1]);
            System.out.print("OPTDRV      Iteration limit");
            System.out.println(" = " + itnlim[1]);
            System.out.print("OPTDRV      Machine epsilon");
            System.out.println(" = " + epsm);
            System.out.print("OPTDRV      Maximum step size");
            System.out.println(" = " + stepmx[1]);
            System.out.print("OPTDRV      Step tolerance");
            System.out.println(" = " + steptl[1]);
            System.out.print("OPTDRV      Gradient tolerance");
            System.out.println(" = " + gradtl[1]);
            System.out.print("OPTDRV      Trust region radius");
            System.out.println(" = " + dlt[1]);
            System.out.print("OPTDRV      Relative noise in");
            System.out.println(" f_to_minimize = " + rnf);
            System.out.print("OPTDRV      Analytical fd tolerance");
            System.out.println(" = " + analtl);
        }
        f[1] = minclass.f_to_minimize(x);
        if (iagflg[1] == 0) {
            Uncmin_f77.fstofd_f77(n, x, minclass, f, g, sx, rnf);
        } else {
            minclass.gradient(x, g);
            if (msg[1] / 2 % 2 == 0) {
                Uncmin_f77.grdchk_f77(n, x, minclass, f, g, typsiz, sx, fscale, rnf, analtl, wrk1);
            }
        }
        Uncmin_f77.optstp_f77(n, x, f, g, wrk1, itncnt, icscmx, itrmcd, gradtl, steptl, sx, fscale, itnlim, iretcd, mxtake, msg);
        if (itrmcd[1] != 0) {
            fpls[1] = f[1];
            i = 1;
            while (i <= n) {
                xpls[i] = x[i];
                gpls[i] = g[i];
                ++i;
            }
        } else {
            if (iexp[1] == 1) {
                Uncmin_f77.hsnint_f77(n, a, sx, method);
            } else if (iahflg[1] == 0) {
                if (iagflg[1] == 1) {
                    Uncmin_f77.fstofd_f77(n, x, minclass, g, a, sx, rnf, wrk1);
                } else {
                    Uncmin_f77.sndofd_f77(n, x, minclass, f, a, sx, rnf, wrk1, wrk2);
                }
            } else if (msg[1] / 4 % 2 == 1) {
                minclass.hessian(x, a);
            } else {
                Uncmin_f77.heschk_f77(n, x, minclass, f, g, a, typsiz, sx, rnf, analtl, iagflg, udiag, wrk1, wrk2);
            }
            if (msg[1] / 8 % 2 == 0) {
                Uncmin_f77.result_f77(n, x, f, g, a, p, itncnt, 1);
            }
            while (itrmcd[1] == 0) {
                itncnt[1] = itncnt[1] + 1;
                if (iexp[1] != 1 || method[1] == 3) {
                    Uncmin_f77.chlhsn_f77(n, a, epsm, sx, udiag);
                }
                i = 1;
                while (i <= n) {
                    wrk1[i] = -g[i];
                    ++i;
                }
                Uncmin_f77.lltslv_f77(n, a, p, wrk1);
                if (iagflg[1] == 0 && method[1] != 1) {
                    dltsav = dlt[1];
                    if (method[1] != 2) {
                        amusav = amu[1];
                        dlpsav = dltp[1];
                        phisav = phi[1];
                        phpsav = phip0[1];
                    }
                }
                if (method[1] == 1) {
                    Uncmin_f77.lnsrch_f77(n, x, f, g, p, xpls, fpls, minclass, mxtake, iretcd, stepmx, steptl, sx);
                } else if (method[1] == 2) {
                    Uncmin_f77.dogdrv_f77(n, x, f, g, a, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, wrk0, wrk1, wrk2, wrk3);
                } else {
                    Uncmin_f77.hookdr_f77(n, x, f, g, a, udiag, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, amu, dltp, phi, phip0, wrk0, wrk1, wrk2, epsm, itncnt);
                }
                if (iretcd[1] == 1 && iagflg[1] == 0) {
                    iagflg[1] = -1;
                    System.out.print("\nOPTDRV      Shift from forward to central");
                    System.out.print(" differences");
                    System.out.print("\nOPTDRV      in iteration " + itncnt[1]);
                    System.out.print("\n");
                    Uncmin_f77.fstocd_f77(n, x, minclass, sx, rnf, g);
                    if (method[1] == 1) {
                        i = 1;
                        while (i <= n) {
                            wrk1[i] = -g[i];
                            ++i;
                        }
                        Uncmin_f77.lltslv_f77(n, a, p, wrk1);
                        Uncmin_f77.lnsrch_f77(n, x, f, g, p, xpls, fpls, minclass, mxtake, iretcd, stepmx, steptl, sx);
                    } else {
                        dlt[1] = dltsav;
                        if (method[1] == 2) {
                            i = 1;
                            while (i <= n) {
                                wrk1[i] = -g[i];
                                ++i;
                            }
                            Uncmin_f77.lltslv_f77(n, a, p, wrk1);
                            Uncmin_f77.dogdrv_f77(n, x, f, g, a, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, wrk0, wrk1, wrk2, wrk3);
                        } else {
                            amu[1] = amusav;
                            dltp[1] = dlpsav;
                            phi[1] = phisav;
                            phip0[1] = phpsav;
                            Uncmin_f77.chlhsn_f77(n, a, epsm, sx, udiag);
                            i = 1;
                            while (i <= n) {
                                wrk1[i] = -g[i];
                                ++i;
                            }
                            Uncmin_f77.lltslv_f77(n, a, p, wrk1);
                            Uncmin_f77.hookdr_f77(n, x, f, g, a, udiag, p, xpls, fpls, minclass, sx, stepmx, steptl, dlt, iretcd, mxtake, amu, dltp, phi, phip0, wrk0, wrk1, wrk2, epsm, itncnt);
                        }
                    }
                }
                i = 1;
                while (i <= n) {
                    p[i] = xpls[i] - x[i];
                    ++i;
                }
                if (iagflg[1] == -1) {
                    Uncmin_f77.fstocd_f77(n, xpls, minclass, sx, rnf, gpls);
                } else if (iagflg[1] == 0) {
                    Uncmin_f77.fstofd_f77(n, xpls, minclass, fpls, gpls, sx, rnf);
                } else {
                    minclass.gradient(xpls, gpls);
                }
                Uncmin_f77.optstp_f77(n, xpls, fpls, gpls, x, itncnt, icscmx, itrmcd, gradtl, steptl, sx, fscale, itnlim, iretcd, mxtake, msg);
                if (itrmcd[1] != 0) continue;
                if (iexp[1] != 0) {
                    if (method[1] == 3) {
                        Uncmin_f77.secunf_f77(n, x, g, a, udiag, xpls, gpls, epsm, itncnt, rnf, iagflg, noupdt, wrk1, wrk2, wrk3);
                    } else {
                        Uncmin_f77.secfac_f77(n, x, g, a, xpls, gpls, epsm, itncnt, rnf, iagflg, noupdt, wrk0, wrk1, wrk2, wrk3);
                    }
                } else if (iahflg[1] == 1) {
                    minclass.hessian(xpls, a);
                } else if (iagflg[1] == 1) {
                    Uncmin_f77.fstofd_f77(n, xpls, minclass, gpls, a, sx, rnf, wrk1);
                } else {
                    Uncmin_f77.sndofd_f77(n, xpls, minclass, fpls, a, sx, rnf, wrk1, wrk2);
                }
                if (msg[1] / 16 % 2 == 1) {
                    Uncmin_f77.result_f77(n, xpls, fpls, gpls, a, p, itncnt, 1);
                }
                f[1] = fpls[1];
                i = 1;
                while (i <= n) {
                    x[i] = xpls[i];
                    g[i] = gpls[i];
                    ++i;
                }
            }
            if (itrmcd[1] == 3) {
                fpls[1] = f[1];
                i = 1;
                while (i <= n) {
                    xpls[i] = x[i];
                    gpls[i] = g[i];
                    ++i;
                }
            }
        }
        if (msg[1] / 8 % 2 == 0) {
            Uncmin_f77.result_f77(n, xpls, fpls, gpls, a, p, itncnt, 0);
        }
        msg[1] = 0;
    }

    public static void optstp_f77(int n, double[] xpls, double[] fpls, double[] gpls, double[] x, int[] itncnt, int[] icscmx, int[] itrmcd, double[] gradtl, double[] steptl, double[] sx, double[] fscale, int[] itnlim, int[] iretcd, boolean[] mxtake, int[] msg) {
        itrmcd[1] = 0;
        if (iretcd[1] == 1) {
            itrmcd[1] = 3;
            if (msg[1] / 8 % 2 == 0) {
                System.out.print("\n\nOPTSTP    The last global step failed");
                System.out.print(" to locate a point lower than x.\n");
                System.out.print("OPTSTP    Either x is an approximate local");
                System.out.print(" minimum of the function,\n");
                System.out.print("OPTSTP    the function is too nonlinear for");
                System.out.print(" this algorithm, or\n");
                System.out.print("OPTSTP    steptl is too large.\n");
            }
            return;
        }
        double d = Math.max(Math.abs(fpls[1]), fscale[1]);
        double rgx = 0.0;
        int i = 1;
        while (i <= n) {
            double relgrd = Math.abs(gpls[i]) * Math.max(Math.abs(xpls[i]), 1.0 / sx[i]) / d;
            rgx = Math.max(rgx, relgrd);
            ++i;
        }
        if (rgx <= gradtl[1]) {
            itrmcd[1] = 1;
            if (msg[1] / 8 % 2 == 0) {
                System.out.print("\n\nOPTSTP    The relative gradient is close");
                System.out.print(" to zero.\n");
                System.out.print("OPTSTP    The current iterate is probably");
                System.out.print(" a solution.\n");
            }
            return;
        }
        if (itncnt[1] == 0) {
            return;
        }
        double rsx = 0.0;
        i = 1;
        while (i <= n) {
            double relstp = Math.abs(xpls[i] - x[i]) / Math.max(Math.abs(xpls[i]), 1.0 / sx[i]);
            rsx = Math.max(rsx, relstp);
            ++i;
        }
        if (rsx <= steptl[1]) {
            itrmcd[1] = 2;
            if (msg[1] / 8 % 2 == 0) {
                System.out.print("\n\nOPTSTP    Successive iterates are within");
                System.out.print(" steptl.\n");
                System.out.print("OPTSTP    The current iterate is probably");
                System.out.print(" a solution.\n");
            }
            return;
        }
        if (itncnt[1] >= itnlim[1]) {
            itrmcd[1] = 4;
            if (msg[1] / 8 % 2 == 0) {
                System.out.print("\n\nOPTSTP    The iteration limit was reached.\n");
                System.out.print("OPTSTP    The algorithm failed.\n");
            }
            return;
        }
        if (!mxtake[1]) {
            icscmx[1] = 0;
            return;
        }
        if (msg[1] / 8 % 2 == 0) {
            System.out.print("\n\nOPTSTP    Step of maximum length (stepmx)");
            System.out.print(" taken.\n");
        }
        icscmx[1] = icscmx[1] + 1;
        if (icscmx[1] < 5) {
            return;
        }
        itrmcd[1] = 5;
        if (msg[1] / 8 % 2 == 0) {
            System.out.print("\n\nOPTSTP    Maximum step size exceeded");
            System.out.print(" five consecutive times.\n");
            System.out.print("OPTSTP    Either the function is unbounded");
            System.out.print(" below,\n");
            System.out.print("OPTSTP    becomes asymptotic to a finite value");
            System.out.print(" from above in some direction, or\n");
            System.out.print("OPTSTP    stepmx is too small.\n");
        }
    }

    public static void qraux1_f77(int n, double[][] r, int i) {
        int ip1 = i + 1;
        int j = i;
        while (j <= n) {
            double tmp = r[i][j];
            r[i][j] = r[ip1][j];
            r[ip1][j] = tmp;
            ++j;
        }
    }

    public static void qraux2_f77(int n, double[][] r, int i, double a, double b) {
        int ip1 = i + 1;
        double den = Math.sqrt(a * a + b * b);
        double c = a / den;
        double s = b / den;
        int j = i;
        while (j <= n) {
            double y = r[i][j];
            double z = r[ip1][j];
            r[i][j] = c * y - s * z;
            r[ip1][j] = s * y + c * z;
            ++j;
        }
    }

    public static void qrupdt_f77(int n, double[][] a, double[] u, double[] v) {
        int i;
        int k = n;
        while (u[k] == 0.0 && k > 1) {
            --k;
        }
        int km1 = k - 1;
        int ii = 1;
        while (ii <= km1) {
            i = km1 - ii + 1;
            if (u[i] == 0.0) {
                Uncmin_f77.qraux1_f77(n, a, i);
                u[i] = u[i + 1];
            } else {
                Uncmin_f77.qraux2_f77(n, a, i, u[i], -u[i + 1]);
                u[i] = Math.sqrt(u[i] * u[i] + u[i + 1] * u[i + 1]);
            }
            ++ii;
        }
        int j = 1;
        while (j <= n) {
            double[] dArray = a[1];
            int n2 = j;
            dArray[n2] = dArray[n2] + u[1] * v[j];
            ++j;
        }
        km1 = k - 1;
        i = 1;
        while (i <= km1) {
            if (a[i][i] == 0.0) {
                Uncmin_f77.qraux1_f77(n, a, i);
            } else {
                double t1 = a[i][i];
                double t2 = -a[i + 1][i];
                Uncmin_f77.qraux2_f77(n, a, i, t1, t2);
            }
            ++i;
        }
    }

    public static void result_f77(int n, double[] x, double[] f, double[] g, double[][] a, double[] p, int[] itncnt, int iflg) {
        int j;
        int i;
        int ihigh;
        int ilow;
        int num5 = n / 5;
        int remain = n % 5;
        System.out.print("\n\nRESULT      Iterate k = " + itncnt[1] + "\n");
        if (iflg != 0) {
            System.out.print("\n\nRESULT      Step\n\n");
            ilow = -4;
            ihigh = 0;
            i = 1;
            while (i <= num5) {
                System.out.print(String.valueOf(ilow += 5) + "--" + (ihigh += 5) + "     ");
                j = 1;
                while (j <= 5) {
                    System.out.print(String.valueOf(p[ilow + j - 1]) + "  ");
                    ++j;
                }
                System.out.print("\n");
                ++i;
            }
            ihigh = (ilow += 5) + remain - 1;
            System.out.print(String.valueOf(ilow) + "--" + ihigh + "     ");
            j = 1;
            while (j <= remain) {
                System.out.print(String.valueOf(p[ilow + j - 1]) + "  ");
                ++j;
            }
            System.out.print("\n");
        }
        System.out.print("\n\nRESULT      Current x\n\n");
        ilow = -4;
        ihigh = 0;
        i = 1;
        while (i <= num5) {
            System.out.print(String.valueOf(ilow += 5) + "--" + (ihigh += 5) + "     ");
            j = 1;
            while (j <= 5) {
                System.out.print(String.valueOf(x[ilow + j - 1]) + "  ");
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
        ihigh = (ilow += 5) + remain - 1;
        System.out.print(String.valueOf(ilow) + "--" + ihigh + "     ");
        j = 1;
        while (j <= remain) {
            System.out.print(String.valueOf(x[ilow + j - 1]) + "  ");
            ++j;
        }
        System.out.print("\n");
        System.out.print("\n\nRESULT      f_to_minimize at x = " + f[1] + "\n");
        System.out.print("\n\nRESULT      Gradient at x\n\n");
        ilow = -4;
        ihigh = 0;
        i = 1;
        while (i <= num5) {
            System.out.print(String.valueOf(ilow += 5) + "--" + (ihigh += 5) + "     ");
            j = 1;
            while (j <= 5) {
                System.out.print(String.valueOf(g[ilow + j - 1]) + "  ");
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
        ihigh = (ilow += 5) + remain - 1;
        System.out.print(String.valueOf(ilow) + "--" + ihigh + "     ");
        j = 1;
        while (j <= remain) {
            System.out.print(String.valueOf(g[ilow + j - 1]) + "  ");
            ++j;
        }
        System.out.print("\n");
        if (iflg != 0) {
            System.out.print("\n\nRESULT      Hessian at x\n\n");
            int iii = 1;
            while (iii <= n) {
                int iii5 = iii / 5;
                int iiir = iii % 5;
                ilow = -4;
                ihigh = 0;
                i = 1;
                while (i <= iii5) {
                    System.out.print("i = " + iii + ", j = ");
                    System.out.print(String.valueOf(ilow += 5) + "--" + (ihigh += 5) + "     ");
                    j = 1;
                    while (j <= 5) {
                        System.out.print(String.valueOf(a[iii][ilow + j - 1]) + "  ");
                        ++j;
                    }
                    System.out.print("\n");
                    ++i;
                }
                ihigh = (ilow += 5) + iiir - 1;
                System.out.print("i = " + iii + ", j = ");
                System.out.print(String.valueOf(ilow) + "--" + ihigh + "     ");
                j = 1;
                while (j <= iiir) {
                    System.out.print(String.valueOf(a[iii][ilow + j - 1]) + "  ");
                    ++j;
                }
                System.out.print("\n");
                ++iii;
            }
        }
    }

    public static void sclmul_f77(int n, double s, double[] v, double[] z) {
        int i = 1;
        while (i <= n) {
            z[i] = s * v[i];
            ++i;
        }
    }

    public static void secfac_f77(int n, double[] x, double[] g, double[][] a, double[] xpls, double[] gpls, double epsm, int[] itncnt, double rnf, int[] iagflg, boolean[] noupdt, double[] s, double[] y, double[] u, double[] w) {
        if (itncnt[1] == 1) {
            noupdt[1] = true;
        }
        int i = 1;
        while (i <= n) {
            s[i] = xpls[i] - x[i];
            y[i] = gpls[i] - g[i];
            ++i;
        }
        double den1 = Blas_f77.ddot_f77(n, s, 1, y, 1);
        double snorm2 = Blas_f77.dnrm2_f77(n, s, 1);
        double ynrm2 = Blas_f77.dnrm2_f77(n, y, 1);
        if (den1 >= Math.sqrt(epsm) * snorm2 * ynrm2) {
            int j;
            Uncmin_f77.mvmltu_f77(n, a, s, u);
            double den2 = Blas_f77.ddot_f77(n, u, 1, u, 1);
            double alp = Math.sqrt(den1 / den2);
            if (noupdt[1]) {
                j = 1;
                while (j <= n) {
                    int n2 = j;
                    u[n2] = u[n2] * alp;
                    i = j;
                    while (i <= n) {
                        double[] dArray = a[i];
                        int n3 = j;
                        dArray[n3] = dArray[n3] * alp;
                        ++i;
                    }
                    ++j;
                }
                noupdt[1] = false;
                den2 = den1;
                alp = 1.0;
            }
            boolean skpupd = true;
            Uncmin_f77.mvmltl_f77(n, a, u, w);
            i = 1;
            double reltol = iagflg[1] == 0 ? Math.sqrt(rnf) : rnf;
            while (i <= n && skpupd) {
                if (Math.abs(y[i] - w[i]) >= reltol * Math.max(Math.abs(g[i]), Math.abs(gpls[i]))) {
                    skpupd = false;
                    continue;
                }
                ++i;
            }
            if (!skpupd) {
                int im1;
                i = 1;
                while (i <= n) {
                    w[i] = y[i] - alp * w[i];
                    ++i;
                }
                alp /= den1;
                i = 1;
                while (i <= n) {
                    int n4 = i++;
                    u[n4] = u[n4] * alp;
                }
                i = 2;
                while (i <= n) {
                    im1 = i - 1;
                    j = 1;
                    while (j <= im1) {
                        a[j][i] = a[i][j];
                        a[i][j] = 0.0;
                        ++j;
                    }
                    ++i;
                }
                Uncmin_f77.qrupdt_f77(n, a, u, w);
                i = 2;
                while (i <= n) {
                    im1 = i - 1;
                    j = 1;
                    while (j <= im1) {
                        a[i][j] = a[j][i];
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public static void secunf_f77(int n, double[] x, double[] g, double[][] a, double[] udiag, double[] xpls, double[] gpls, double epsm, int[] itncnt, double rnf, int[] iagflg, boolean[] noupdt, double[] s, double[] y, double[] t) {
        int i;
        int j = 1;
        while (j <= n) {
            a[j][j] = udiag[j];
            i = j + 1;
            while (i <= n) {
                a[i][j] = a[j][i];
                ++i;
            }
            ++j;
        }
        if (itncnt[1] == 1) {
            noupdt[1] = true;
        }
        i = 1;
        while (i <= n) {
            s[i] = xpls[i] - x[i];
            y[i] = gpls[i] - g[i];
            ++i;
        }
        double den1 = Blas_f77.ddot_f77(n, s, 1, y, 1);
        double snorm2 = Blas_f77.dnrm2_f77(n, s, 1);
        double ynrm2 = Blas_f77.dnrm2_f77(n, y, 1);
        if (den1 >= Math.sqrt(epsm) * snorm2 * ynrm2) {
            Uncmin_f77.mvmlts_f77(n, a, s, t);
            double den2 = Blas_f77.ddot_f77(n, s, 1, t, 1);
            if (noupdt[1]) {
                double gam = den1 / den2;
                den2 = gam * den2;
                j = 1;
                while (j <= n) {
                    int n2 = j;
                    t[n2] = t[n2] * gam;
                    i = j;
                    while (i <= n) {
                        double[] dArray = a[i];
                        int n3 = j;
                        dArray[n3] = dArray[n3] * gam;
                        ++i;
                    }
                    ++j;
                }
                noupdt[1] = false;
            }
            boolean skpupd = true;
            i = 1;
            while (i <= n) {
                double tol = rnf * Math.max(Math.abs(g[i]), Math.abs(gpls[i]));
                if (iagflg[1] == 0) {
                    tol /= Math.sqrt(rnf);
                }
                if (Math.abs(y[i] - t[i]) >= tol) {
                    skpupd = false;
                    break;
                }
                ++i;
            }
            if (!skpupd) {
                j = 1;
                while (j <= n) {
                    i = j;
                    while (i <= n) {
                        double[] dArray = a[i];
                        int n4 = j;
                        dArray[n4] = dArray[n4] + (y[i] * y[j] / den1 - t[i] * t[j] / den2);
                        ++i;
                    }
                    ++j;
                }
            }
        }
    }

    public static void sndofd_f77(int n, double[] xpls, Uncmin_methods minclass, double[] fpls, double[][] a, double[] sx, double rnoise, double[] stepsz, double[] anbr) {
        double xtmpi;
        double xmult = Math.pow(rnoise, 0.3333333333333333);
        int i = 1;
        while (i <= n) {
            stepsz[i] = xmult * Math.max(Math.abs(xpls[i]), 1.0 / sx[i]);
            xtmpi = xpls[i];
            xpls[i] = xtmpi + stepsz[i];
            anbr[i] = minclass.f_to_minimize(xpls);
            xpls[i] = xtmpi;
            ++i;
        }
        i = 1;
        while (i <= n) {
            xtmpi = xpls[i];
            xpls[i] = xtmpi + 2.0 * stepsz[i];
            double fhat = minclass.f_to_minimize(xpls);
            a[i][i] = (fpls[1] - anbr[i] + (fhat - anbr[i])) / (stepsz[i] * stepsz[i]);
            if (i != n) {
                xpls[i] = xtmpi + stepsz[i];
                int j = i + 1;
                while (j <= n) {
                    double xtmpj = xpls[j];
                    xpls[j] = xtmpj + stepsz[j];
                    fhat = minclass.f_to_minimize(xpls);
                    a[j][i] = (fpls[1] - anbr[i] + (fhat - anbr[j])) / (stepsz[i] * stepsz[j]);
                    xpls[j] = xtmpj;
                    ++j;
                }
            }
            xpls[i] = xtmpi;
            ++i;
        }
    }

    public static void tregup_f77(int n, double[] x, double[] f, double[] g, double[][] a, Uncmin_methods minclass, double[] sc, double[] sx, boolean[] nwtake, double[] stepmx, double[] steptl, double[] dlt, int[] iretcd, double[] xplsp, double[] fplsp, double[] xpls, double[] fpls, boolean[] mxtake, int method, double[] udiag) {
        mxtake[1] = false;
        int i = 1;
        while (i <= n) {
            xpls[i] = x[i] + sc[i];
            ++i;
        }
        fpls[1] = minclass.f_to_minimize(xpls);
        double dltf = fpls[1] - f[1];
        double slp = Blas_f77.ddot_f77(n, g, 1, sc, 1);
        if (iretcd[1] == 4) {
            fplsp[1] = 0.0;
        }
        if (iretcd[1] == 3 && (fpls[1] >= fplsp[1] || dltf > 1.0E-4 * slp)) {
            iretcd[1] = 0;
            i = 1;
            while (i <= n) {
                xpls[i] = xplsp[i];
                ++i;
            }
            fpls[1] = fplsp[1];
            dlt[1] = dlt[1] * 0.5;
        } else if (dltf > 1.0E-4 * slp) {
            double rln = 0.0;
            i = 1;
            while (i <= n) {
                rln = Math.max(rln, Math.abs(sc[i]) / Math.max(Math.abs(xpls[i]), 1.0 / sx[i]));
                ++i;
            }
            if (rln < steptl[1]) {
                iretcd[1] = 1;
            } else {
                iretcd[1] = 2;
                double dltmp = -slp * dlt[1] / (2.0 * (dltf - slp));
                dlt[1] = dltmp < 0.1 * dlt[1] ? dlt[1] * 0.1 : dltmp;
            }
        } else {
            int j;
            double temp;
            double dltfp = 0.0;
            if (method == 2) {
                i = 1;
                while (i <= n) {
                    temp = 0.0;
                    j = i;
                    while (j <= n) {
                        temp += a[j][i] * sc[j];
                        ++j;
                    }
                    dltfp += temp * temp;
                    ++i;
                }
            } else {
                i = 1;
                while (i <= n) {
                    dltfp += udiag[i] * sc[i] * sc[i];
                    temp = 0.0;
                    j = i + 1;
                    while (j <= n) {
                        temp += a[i][j] * sc[i] * sc[j];
                        ++j;
                    }
                    dltfp += 2.0 * temp;
                    ++i;
                }
            }
            dltfp = slp + dltfp / 2.0;
            if (iretcd[1] != 2 && Math.abs(dltfp - dltf) <= 0.1 * Math.abs(dltf) && !nwtake[1] && dlt[1] <= 0.99 * stepmx[1]) {
                iretcd[1] = 3;
                i = 1;
                while (i <= n) {
                    xplsp[i] = xpls[i];
                    ++i;
                }
                fplsp[1] = fpls[1];
                dlt[1] = Math.min(2.0 * dlt[1], stepmx[1]);
            } else {
                iretcd[1] = 0;
                if (dlt[1] > 0.99 * stepmx[1]) {
                    mxtake[1] = true;
                }
                if (dltf >= 0.1 * dltfp) {
                    dlt[1] = dlt[1] * 0.5;
                } else if (dltf <= 0.75 * dltfp) {
                    dlt[1] = Math.min(2.0 * dlt[1], stepmx[1]);
                }
            }
        }
    }
}

