/*
 * Decompiled with CFR 0.152.
 */
package optimization;

import java.io.IOException;

public class Console {
    public static void printPrompt(String prompt) {
        System.out.print(String.valueOf(prompt) + " ");
        System.out.flush();
    }

    public static String readString() {
        String r = "";
        boolean done = false;
        while (!done) {
            try {
                int ch = System.in.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                r = String.valueOf(r) + (char)ch;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return r;
    }

    public static String readString(String prompt) {
        Console.printPrompt(prompt);
        return Console.readString();
    }

    public static String readWord() {
        String r = "";
        boolean done = false;
        while (!done) {
            try {
                int ch = System.in.read();
                if (ch < 0 || Character.isSpace((char)ch)) {
                    done = true;
                    continue;
                }
                r = String.valueOf(r) + (char)ch;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return r;
    }

    public static int readInt(String prompt) {
        while (true) {
            Console.printPrompt(prompt);
            try {
                return Integer.valueOf(Console.readString().trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Not an integer. Please try again!");
                continue;
            }
            break;
        }
    }

    public static double readDouble(String prompt) {
        while (true) {
            Console.printPrompt(prompt);
            try {
                return Double.valueOf(Console.readString().trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Not a floating point number. Please try again!");
                continue;
            }
            break;
        }
    }
}

