/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.MathException;
import evaluator.NoSuchVariableException;
import evaluator.ObjectPath;
import evaluator.Operator;
import evaluator.ParseException;
import evaluator.PathHelper;
import evaluator.Stack;
import evaluator.StackException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import unit.Unit;

public class Variable
extends ObjectPath
implements Operator {
    static final int INTERNAL = 0;
    static final int EXTERNAL = 1;
    int type;
    String name;
    Unit unit = null;
    public static Hashtable table = new Hashtable();
    static /* synthetic */ Class class$0;

    public static void set(String name, double value) {
        table.put(name, new Double(value));
    }

    public static double get(String name) {
        Double d = (Double)table.get(name);
        if (d != null) {
            return d;
        }
        return Double.NaN;
    }

    public static Vector getDefinedNames() {
        Vector v = new Vector();
        Enumeration i = table.keys();
        while (i.hasMoreElements()) {
            v.add(i.nextElement());
        }
        return v;
    }

    public final int getStackCount() {
        return 1;
    }

    public Variable(String name) throws ParseException {
        this.name = name;
        if (table.get(name) != null) {
            this.type = 0;
            this.unit = new Unit("");
        } else {
            this.type = 1;
            try {
                this.createPath(name);
            }
            catch (ParseException e) {
                throw new NoSuchVariableException(name);
            }
            try {
                Object o = this.get();
                if (o instanceof Variable) {
                    this.unit = ((Variable)o).getUnit();
                } else if (o instanceof Number) {
                    this.unit = new Unit("");
                }
            }
            catch (Exception e) {
                Class clazz = this.getType();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.Number");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.unit = clazz.isAssignableFrom(clazz2) ? new Unit("") : null;
            }
        }
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void doStackOp(Stack stack) throws MathException, StackException {
        double ans = Double.NaN;
        switch (this.type) {
            case 0: {
                try {
                    ans = (Double)table.get(this.name);
                    break;
                }
                catch (NullPointerException e) {
                    throw new MathException(stack, "Variable has been removed: " + this.name);
                }
            }
            case 1: {
                if (this.member instanceof Method) {
                    Method method = (Method)this.member;
                    if (method.getReturnType() != Double.TYPE) {
                        throw new MathException(stack, method + " is not a double");
                    }
                    Class<?>[] paramtypes = method.getParameterTypes();
                    if (paramtypes.length != 0) {
                        throw new MathException(stack, method + " takes parameters");
                    }
                    try {
                        Double d = (Double)method.invoke(this.object, null);
                        ans = d;
                        break;
                    }
                    catch (Exception e) {
                        throw new MathException(stack, method + " could not be invoked" + " because of " + e.getMessage());
                    }
                }
                if (this.member instanceof Field) {
                    Field field = (Field)this.member;
                    if (field.getType() != Double.TYPE) {
                        throw new MathException(stack, field + " is not a double");
                    }
                    try {
                        ans = field.getDouble(this.object);
                        break;
                    }
                    catch (Exception e) {
                        throw new MathException(stack, field + " could not be read " + "because of " + e.getMessage());
                    }
                }
                ans = this.member instanceof PathHelper ? ((PathHelper)this.member).getObjectValue(this.object) : Double.NaN;
            }
        }
        stack.push(ans);
    }
}

