/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.ParseException;
import evaluator.PathHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public abstract class ObjectPath {
    Object object;
    Object member;
    static Object[] root;
    static String[] packages;
    static PathHelper[] pathHelper;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Object[] objectArray = new Object[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Math");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[0] = clazz;
        root = objectArray;
        packages = new String[]{"java.lang"};
        pathHelper = new PathHelper[0];
    }

    public static void setRoot(Object[] rroot) {
        root = rroot;
    }

    public static Object[] getRoot() {
        return root;
    }

    public static void setPackage(String[] rpackages) {
        packages = rpackages;
    }

    public static String[] getPackage() {
        return packages;
    }

    public static void setPathHelper(PathHelper[] helpers) {
        pathHelper = helpers;
    }

    public static PathHelper[] getPathHelper() {
        return pathHelper;
    }

    public static void appendRoot(Object o) {
        int i = 0;
        while (i < root.length) {
            if (root[i].equals(o)) {
                return;
            }
            ++i;
        }
        Object[] nroot = new Object[root.length + 1];
        int i2 = 0;
        while (i2 < root.length) {
            nroot[i2] = root[i2];
            ++i2;
        }
        nroot[ObjectPath.root.length] = o;
        root = nroot;
    }

    void createPath(String path) throws ParseException {
        int i = 0;
        while (i < ObjectPath.getRoot().length) {
            StringTokenizer st = new StringTokenizer(path, ".");
            Object o = ObjectPath.getRoot()[i];
            if (this.find(st, o, o.getClass())) break;
            st = new StringTokenizer(path, ".");
            if (o instanceof Class && this.find(st, null, (Class)o)) break;
            ++i;
        }
        if (this.member == null) {
            String[] packages = ObjectPath.getPackage();
            boolean found = false;
            int i2 = 0;
            while (i2 < packages.length) {
                try {
                    StringTokenizer st = new StringTokenizer(path, ".");
                    String token = st.nextToken();
                    Class<?> cls = Class.forName(String.valueOf(packages[i2]) + '.' + token);
                    found = this.find(st, null, cls);
                    if (found) break;
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                ++i2;
            }
            if (!found) {
                i2 = 0;
                while (i2 < pathHelper.length) {
                    this.member = pathHelper[i2];
                    this.object = pathHelper[i2].findObjectFromPath(path);
                    if (this.object != null) {
                        found = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (!found) {
                throw new ParseException("Cannot find object " + path);
            }
        }
    }

    boolean find(StringTokenizer st, Object newobject, Class cls) {
        try {
            while (st.hasMoreElements()) {
                block14: {
                    this.object = newobject;
                    String token = st.nextToken();
                    try {
                        Field field = cls.getField(token);
                        this.member = field;
                        if (st.hasMoreElements()) {
                            newobject = field.get(this.object);
                        }
                    }
                    catch (Exception e) {
                        try {
                            Method method;
                            try {
                                method = cls.getMethod(token, null);
                            }
                            catch (NoSuchMethodException ex) {
                                try {
                                    method = cls.getMethod(token, Double.TYPE);
                                }
                                catch (NoSuchMethodException exx) {
                                    method = cls.getMethod(token, Double.TYPE, Double.TYPE);
                                }
                            }
                            this.member = method;
                            if (st.hasMoreElements()) {
                                newobject = method.invoke(this.object, null);
                            }
                        }
                        catch (Exception ex) {
                            throw new ParseException("Can't find " + token + " in " + this.object);
                        }
                        if (newobject != null || !st.hasMoreElements()) break block14;
                        throw new ParseException("Null object " + token + " in " + this.object);
                    }
                }
                if (newobject == null) continue;
                cls = newobject.getClass();
            }
            if (this.member == null) {
                throw new ParseException("Error finding object " + st);
            }
        }
        catch (ParseException e) {
            this.object = null;
            return false;
        }
        return true;
    }

    public Object get() throws NeedsParametersException, ParseException {
        if (this.member instanceof Field) {
            Field f = (Field)this.member;
            try {
                return f.get(this.object);
            }
            catch (IllegalAccessException x) {
                throw new ParseException("Field " + this.object + "." + this.member + " not accessible");
            }
        }
        if (this.member instanceof Method) {
            Method m = (Method)this.member;
            if (m.getParameterTypes().length == 0) {
                try {
                    return m.invoke(this.object, null);
                }
                catch (Exception x) {
                    throw new ParseException("Method " + this.object + "." + this.member + " cannot be invoked");
                }
            }
            throw new NeedsParametersException(this.object + "." + this.member + " needs parameters for invocation");
        }
        if (this.member instanceof PathHelper) {
            return this.object;
        }
        return null;
    }

    public Class getType() {
        if (this.member instanceof Field) {
            return ((Field)this.member).getType();
        }
        if (this.member instanceof Method) {
            return ((Method)this.member).getReturnType();
        }
        if (this.member instanceof PathHelper) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        return null;
    }

    public static class NeedsParametersException
    extends Exception {
        protected NeedsParametersException(String s) {
            super(s);
        }
    }
}

