/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

public class MathExtra {
    static double DELTA = 1.0E-9;
    static double MAX_ITERATIONS = 10000.0;
    public static final double eulerGamma = 0.5772156649015329;

    public static final double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static final double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static final double tanh(double x) {
        return MathExtra.sinh(x) / MathExtra.cosh(x);
    }

    public static final double cosec(double x) {
        return 1.0 / Math.sin(x);
    }

    public static final double sec(double x) {
        return 1.0 / Math.cos(x);
    }

    public static final double cot(double x) {
        return 1.0 / Math.tan(x);
    }

    public static final double cosech(double x) {
        return 1.0 / MathExtra.sinh(x);
    }

    public static final double sech(double x) {
        return 1.0 / MathExtra.cosh(x);
    }

    public static final double coth(double x) {
        return MathExtra.cosh(x) / MathExtra.sinh(x);
    }

    public static final double acosec(double x) {
        return Math.asin(1.0 / x);
    }

    public static final double asec(double x) {
        return Math.acos(1.0 / x);
    }

    public static final double acot(double x) {
        return Math.atan(1.0 / x);
    }

    public static final double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static final double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static final double atanh(double x) {
        return Math.log((1.0 + x) / (1.0 - x)) / 2.0;
    }

    public static final double log10(double x) {
        return Math.log(x) / Math.log(10.0);
    }

    public static final double sgn(double x) {
        return x / Math.abs(x);
    }

    public static final double factorial(double x) {
        int r = 1;
        int i = 1;
        while ((double)i < x) {
            r *= i;
            ++i;
        }
        return r;
    }

    public static final double erf(double x) {
        double q = x;
        double t = x;
        int k = 1;
        while (Math.abs(t) > DELTA && (double)k < MAX_ITERATIONS) {
            q += (t *= -((double)(2 * ++k) - 1.0) / (double)k / (double)(2 * k + 1) * x * x);
        }
        return 2.0 / Math.sqrt(Math.PI) * q;
    }

    public static final double frac(double x) {
        return x - Math.floor(x);
    }

    public static final double nCr(double n, double k) {
        return MathExtra.factorial(n) / (MathExtra.factorial(k) * MathExtra.factorial(n - k));
    }

    public static final double ramp(double x) {
        return Math.floor(x) % 2.0 == 0.0 ? MathExtra.frac(x) : 1.0 - MathExtra.frac(x);
    }

    public static final double truncatedRamp(double x) {
        return Math.min(Math.max(MathExtra.ramp(x) * 2.0 - 0.5, 0.0), 1.0);
    }

    public static final double mod(double x, double b) {
        return x % b;
    }

    public static final double zeta(double s) {
        if (s <= 1.0) {
            return Double.NaN;
        }
        int n = 0;
        double e = 1.0;
        double t = 0.0;
        while ((double)n++ < MAX_ITERATIONS && e > DELTA) {
            e = Math.pow(n, -s);
            t += e;
        }
        return t;
    }

    public static final double bessel(double a, double x) {
        int m = 0;
        double t = 0.0;
        double e = 1.0;
        boolean neg = false;
        while ((double)m < MAX_ITERATIONS && e > DELTA) {
            e = (double)(neg ? -1 : 1) / MathExtra.factorial(m) / MathExtra.gamma((double)m + a + 1.0) * Math.pow(x / 2.0, (double)(2 * m) + a);
            t += e;
            neg = !neg;
            ++m;
        }
        return t;
    }

    public static final double gamma(double z) {
        return 0.5 * (Math.log(Math.PI * 2) - Math.log(z)) + z * (Math.log(z + 1.0 / (12.0 * z - 0.1 / z)) - 1.0);
    }
}

