/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.MathException;
import evaluator.ObjectPath;
import evaluator.Operator;
import evaluator.ParseException;
import evaluator.Stack;
import evaluator.StackException;
import java.lang.reflect.Method;
import unit.Unit;

class Function
extends ObjectPath
implements Operator {
    String function;
    int parameters;
    Unit unit = null;
    static /* synthetic */ Class class$0;

    public Function(String function, int parameters) throws ParseException {
        this.function = function;
        this.parameters = parameters;
        this.createPath(function);
        if (this.member instanceof Method) {
            Class<?> clazz = ((Method)this.member).getReturnType();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Number");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(clazz2)) {
                this.unit = new Unit("");
            }
        }
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int getStackCount() {
        return 1 - this.parameters;
    }

    public void doStackOp(Stack stack) throws MathException, StackException {
        Object[] parameterList = new Object[this.parameters];
        int i = this.parameters - 1;
        while (i >= 0) {
            parameterList[i] = new Double(stack.pop());
            --i;
        }
        double ans = Double.NaN;
        if (!(this.member instanceof Method)) {
            throw new MathException(stack, this.member + " is not a method");
        }
        Method method = (Method)this.member;
        if (method.getReturnType() != Double.TYPE) {
            throw new MathException(stack, method + " is not a double");
        }
        Class<?>[] paramtypes = method.getParameterTypes();
        if (paramtypes.length != this.parameters) {
            throw new MathException(stack, method + " does not take " + this.parameters + " parameters");
        }
        try {
            Double d = (Double)method.invoke(this.object, parameterList);
            ans = d;
        }
        catch (Exception e) {
            throw new MathException(stack, method + " could not be invoked" + " because of " + e.getMessage());
        }
        stack.push(ans);
    }
}

