/*
 * Decompiled with CFR 0.152.
 */
package evaluator;

import evaluator.BinaryOperator;
import evaluator.Function;
import evaluator.MathException;
import evaluator.Operator;
import evaluator.ParseException;
import evaluator.Stack;
import evaluator.StackException;
import evaluator.UnaryMinus;
import evaluator.Value;
import evaluator.Variable;
import java.io.Serializable;
import unit.Unit;

public class Expression
implements Serializable {
    private String definition;
    private Operator[] code;
    private Stack stack;
    private Unit unit;
    private int pos = 0;
    private int codeSize = 0;

    public Expression(String definition) throws ParseException {
        try {
            this.parse(definition);
        }
        catch (ParseException e) {
            e.position = this.pos;
            e.parseString = definition;
            throw e;
        }
    }

    public double value() throws StackException, MathException {
        return this.eval();
    }

    public String getDefinition() {
        return this.definition;
    }

    public String toString() {
        return this.definition;
    }

    public Unit getUnit() {
        return this.unit;
    }

    private double eval() throws MathException, StackException {
        double ans = Double.NaN;
        this.stack.reset();
        int i = 0;
        while (i < this.codeSize) {
            try {
                this.code[i].doStackOp(this.stack);
            }
            catch (MathException e) {
                e.code = this.code;
                e.location = i;
                throw e;
            }
            ++i;
        }
        ans = this.stack.pop();
        return ans;
    }

    private void parse(String definition) throws ParseException {
        if (definition == null || definition.trim().equals("")) {
            throw new ParseException("No data provided to Expression constructor");
        }
        this.definition = definition;
        this.code = new Operator[definition.length() * 2];
        this.unit = this.parseExpression();
        this.skip();
        if (this.next() != '\u0000') {
            throw new ParseException("Extra data found after the end of the expression.");
        }
        this.stack = new Stack();
        Operator[] c = new Operator[this.codeSize];
        System.arraycopy(this.code, 0, c, 0, this.codeSize);
        this.code = c;
    }

    private char next() {
        if (this.pos >= this.definition.length()) {
            return '\u0000';
        }
        return this.definition.charAt(this.pos);
    }

    private void skip() {
        while (Character.isSpaceChar(this.next())) {
            ++this.pos;
        }
    }

    private Unit parseExpression() throws ParseException {
        boolean neg = false;
        this.skip();
        if (this.next() == '+' || this.next() == '-') {
            neg = this.next() == '-';
            ++this.pos;
            this.skip();
        }
        Unit firstUnit = this.parseTerm();
        if (neg) {
            this.code[this.codeSize++] = new UnaryMinus();
        }
        this.skip();
        while (this.next() == '+' || this.next() == '-') {
            char op = this.next();
            ++this.pos;
            Unit unit = this.parseTerm();
            if (unit != null && firstUnit != null) {
                if (!unit.equalsInBasis(firstUnit)) {
                    throw new ParseException("Unit of term '" + unit + "'does not match unit '" + firstUnit + "'");
                }
                if (!unit.equals(firstUnit)) {
                    this.code[this.codeSize++] = new Value(unit.getConversionTo(firstUnit));
                    this.code[this.codeSize++] = new BinaryOperator(2);
                }
            }
            this.code[this.codeSize++] = op == '+' ? new BinaryOperator(0) : new BinaryOperator(1);
            this.skip();
        }
        return firstUnit;
    }

    private Unit parseTerm() throws ParseException {
        Unit u = new Unit("");
        Unit v = this.parseFactor();
        if (v == null) {
            u = null;
        } else {
            u.multiplyBy(v, 1);
        }
        this.skip();
        while (this.next() == '*' || this.next() == '/') {
            char op = this.next();
            ++this.pos;
            v = this.parseFactor();
            Operator operator = this.code[this.codeSize++] = op == '*' ? new BinaryOperator(2) : new BinaryOperator(3);
            if (v == null) {
                u = null;
            } else if (u != null) {
                u.multiplyBy(v, op == '*' ? 1 : -1);
            }
            this.skip();
        }
        return u;
    }

    private Unit parseFactor() throws ParseException {
        Unit u = this.parsePrimary();
        this.skip();
        while (this.next() == '^') {
            u = null;
            ++this.pos;
            this.parsePrimary();
            this.code[this.codeSize++] = new BinaryOperator(4);
            this.skip();
        }
        return u;
    }

    private Unit parsePrimary() throws ParseException {
        Unit u = null;
        this.skip();
        char ch = this.next();
        if (Character.isLetter(ch)) {
            return this.parseWord();
        }
        if (Character.isDigit(ch) || ch == '.') {
            return this.parseNumber();
        }
        if (ch == '(') {
            ++this.pos;
            u = this.parseExpression();
            this.skip();
            if (this.next() != ')') {
                throw new ParseException("Exprected a right parenthesis.");
            }
            ++this.pos;
            return u;
        }
        if (ch == ')') {
            throw new ParseException("Unmatched right parenthesis.");
        }
        if (ch == '+' || ch == '-' || ch == '*' || ch == '/' || ch == '^') {
            throw new ParseException("Operator '" + ch + "' found in an unexpected position.");
        }
        if (ch == '\u0000') {
            throw new ParseException("Unexpected end of data in the middle of an expression.");
        }
        throw new ParseException("Illegal character '" + ch + "' found in data.");
    }

    private Unit parseWord() throws ParseException {
        String w = "";
        while (Character.isLetterOrDigit(this.next()) || this.next() == '.') {
            w = String.valueOf(w) + this.next();
            ++this.pos;
        }
        this.skip();
        if (this.next() == '(') {
            ++this.pos;
            this.skip();
            int parameters = 0;
            while (this.next() != ')') {
                Unit z = this.parseExpression();
                ++parameters;
                this.skip();
                if (this.next() == ',') {
                    ++this.pos;
                    continue;
                }
                if (this.next() == ')') continue;
                throw new ParseException("Missing right parenthesis after parameter of function '" + w + "'.");
            }
            if (this.next() != ')') {
                throw new ParseException("Missing right parenthesis after parameter of function '" + w + "'.");
            }
            ++this.pos;
            Function f = new Function(w, parameters);
            this.code[this.codeSize++] = f;
            return f.getUnit();
        }
        Variable v = new Variable(w);
        this.code[this.codeSize++] = v;
        return v.getUnit();
    }

    /*
     * Unable to fully structure code
     */
    private Unit parseNumber() throws ParseException {
        block9: {
            w = "";
            while (Character.isDigit(this.next())) {
                w = String.valueOf(w) + this.next();
                ++this.pos;
            }
            if (this.next() == '.') {
                w = String.valueOf(w) + this.next();
                ++this.pos;
                while (Character.isDigit(this.next())) {
                    w = String.valueOf(w) + this.next();
                    ++this.pos;
                }
            }
            if (w.equals(".")) {
                throw new ParseException("Illegal number found, consisting of decimal point only.");
            }
            if (this.next() != 'E' && this.next() != 'e') break block9;
            w = String.valueOf(w) + this.next();
            ++this.pos;
            if (this.next() == '+' || this.next() == '-') {
                w = String.valueOf(w) + this.next();
                ++this.pos;
            }
            if (Character.isDigit(this.next())) ** GOTO lbl25
            throw new ParseException("Illegal number found, with no digits in its exponent.");
lbl-1000:
            // 1 sources

            {
                w = String.valueOf(w) + this.next();
                ++this.pos;
lbl25:
                // 2 sources

                ** while (Character.isDigit((char)this.next()))
            }
        }
        d = NaN;
        try {
            d = Double.valueOf(w);
        }
        catch (Exception var4_3) {
            // empty catch block
        }
        if (Double.isNaN(d)) {
            throw new ParseException("Illegal number '" + w + "' found in data.");
        }
        this.code[this.codeSize++] = new Value(d);
        return new Unit("");
    }
}

