/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.wind;

import com.cudos.common.DraggableComponent;
import com.cudos.wind.WindTunnel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;

public class WindWall
extends DraggableComponent {
    Shape shape;
    public Shape drawnshape;
    boolean canDragWholeComponent = true;
    Point lastMouse;
    double[] rotateHandle = new double[]{0.0, 0.0};
    boolean rotating = false;
    boolean shapeDragging = false;
    int rhandle = 3;
    AffineTransform ident = AffineTransform.getScaleInstance(1.0, 1.0);
    Point pold = null;

    public WindWall() {
        this(new Ellipse2D.Double(10.0, 10.0, 10.0, 10.0));
    }

    public WindWall(Shape s) {
        this.setShape(s);
    }

    Rectangle handleRectangle(double[] p) {
        return new Rectangle((int)p[0] - this.rhandle, (int)p[1] - this.rhandle, this.rhandle * 2, this.rhandle * 2);
    }

    Point getMidpoint(Shape s) {
        return new Point(s.getBounds().x + s.getBounds().width / 2, s.getBounds().y + s.getBounds().height / 2);
    }

    public void setShape(Shape s) {
        this.shape = s;
        this.setLocation(this.shape.getBounds().getLocation());
        Dimension sz = this.shape.getBounds().getSize();
        this.setSize(sz.width + 1, sz.height + 1);
        AffineTransform at = AffineTransform.getTranslateInstance(-this.getLocation().x, -this.getLocation().y);
        this.drawnshape = at.createTransformedShape(this.shape);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void paint(Graphics g_) {
        Graphics2D g = (Graphics2D)g_;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.red);
        g.fill(this.drawnshape);
        g.setColor(Color.black);
        g.draw(this.drawnshape);
    }

    public void setRotating(boolean b) {
        this.rotating = b;
        this.pold = null;
    }

    public boolean isRotating() {
        return this.rotating;
    }

    public void dragTo(Point p) {
        try {
            if (this.rotating) {
                int dx;
                if (this.pold == null) {
                    this.pold = p;
                }
                if ((dx = this.pold.x - p.x) > 5) {
                    dx = 5;
                }
                if (dx < -5) {
                    dx = -5;
                }
                Point c = this.getMidpoint(this.shape);
                AffineTransform tra = AffineTransform.getTranslateInstance(c.x, c.y);
                AffineTransform rot = AffineTransform.getRotateInstance((double)dx * 0.05);
                AffineTransform ttr = (AffineTransform)tra.clone();
                ttr.concatenate(rot);
                ttr.concatenate(tra.createInverse());
                this.setShape(ttr.createTransformedShape(this.shape));
                ((WindTunnel)this.getParent()).setupWalls();
                this.pold = p;
                return;
            }
            if (this.canDragWholeComponent) {
                super.dragTo(p);
                this.shape = AffineTransform.getTranslateInstance(p.x - this.shape.getBounds().x, p.y - this.shape.getBounds().y).createTransformedShape(this.shape);
                ((WindTunnel)this.getParent()).setupWalls();
            }
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
    }
}

