/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.wind;

import com.cudos.common.DraggableContainer;
import com.cudos.wind.Particle;
import com.cudos.wind.WindWall;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class WindTunnel
extends DraggableContainer
implements Runnable {
    int sx = 10;
    int sy = 15;
    int dwidth = 40;
    int dheight = 25;
    int W = this.sx * this.dwidth;
    int H = this.sy * this.dheight;
    double[][] p = new double[this.dwidth + 1][this.dheight + 1];
    double[][] np = new double[this.dwidth + 1][this.dheight + 1];
    double[][] vx = new double[this.dwidth + 1][this.dheight + 1];
    double[][] vy = new double[this.dwidth + 1][this.dheight + 1];
    double[][] nvx = new double[this.dwidth + 1][this.dheight + 1];
    double[][] nvy = new double[this.dwidth + 1][this.dheight + 1];
    boolean[][] fixp = new boolean[this.dwidth + 1][this.dheight + 1];
    boolean[][] wall = new boolean[this.dwidth + 1][this.dheight + 1];
    final int N = 1000;
    int v0 = 1;
    int[] x = new int[1000];
    int[] y = new int[1000];
    int[] a = new int[1000];
    boolean[] hit = new boolean[1000];
    public Vector walls = new Vector();
    private double drivingPressure = 1.0;
    Color[] cols = new Color[256];
    Color color1 = Color.black;
    Color color2 = Color.white;
    boolean running = false;
    double c = 0.5;
    double d = 0.5;
    WindTunnel me;
    int mx = 0;
    int my = 0;
    Thread thread = new Thread(this);
    Vector particles = new Vector();
    Point createFrom = null;
    Random rand = new Random();
    int particleDispersion = 20;
    double arrowscale = 100.0;
    int dr = 2;
    public boolean linesVisible = false;
    double linesProp = 0.2;

    public void restart() {
        int i = 0;
        while (i < 1000) {
            boolean h = true;
            while (h) {
                this.x[i] = (int)((double)this.dwidth * Math.random());
                this.y[i] = (int)((double)this.dheight * Math.random());
                this.a[i] = (int)(2.0 * Math.random() + 1.0);
                h = this.isHit(i);
            }
            ++i;
        }
        this.particles.removeAllElements();
        this.setupWalls();
    }

    public void addWall(WindWall w) {
        this.walls.add(w);
        this.add(w);
        this.setupWalls();
    }

    public void removeWall(WindWall w) {
        this.walls.remove(w);
        this.remove(w);
        this.setupWalls();
    }

    public void removeAllWalls() {
        int i = 0;
        while (i < this.walls.size()) {
            this.remove((Component)this.walls.get(i));
            ++i;
        }
        this.walls.removeAllElements();
        this.setupWalls();
    }

    public void setupWalls() {
        int i = 1;
        while (i < this.dwidth - 1) {
            int j = 1;
            while (j < this.dheight - 1) {
                Point pt = new Point(i * this.sx + this.sx / 2, j * this.sy + this.sy / 2);
                this.wall[i][j] = j < 2 || j > this.dheight - 3;
                Enumeration en = this.walls.elements();
                while (en.hasMoreElements()) {
                    WindWall w = (WindWall)en.nextElement();
                    Shape s = w.getShape();
                    if (!s.contains(pt)) continue;
                    this.wall[i][j] = true;
                    this.p[i][j] = 0.0;
                }
                ++j;
            }
            ++i;
        }
    }

    public void setBlowerOn(boolean b) {
        int i = 0;
        while (i < this.dheight) {
            this.p[0][i] = b ? this.drivingPressure : 0.0;
            this.np[0][i] = 0.0;
            this.p[this.dwidth - 1][i] = 0.0;
            this.np[this.dwidth - 1][i] = 0.0;
            ++i;
        }
        this.v0 = b ? 1 : 0;
    }

    public Color getColor1() {
        return this.cols[0];
    }

    public Color getColor2() {
        return this.cols[255];
    }

    public void setColor1(Color c) {
        this.color1 = c;
        this.setColors(this.color1, this.color2);
    }

    public void setColor2(Color c) {
        this.color2 = c;
        this.setColors(this.color1, this.color2);
    }

    public void setColors(Color c1, Color c2) {
        int i = 0;
        while (i < 256) {
            this.cols[i] = new Color(c1.getRed() + (c2.getRed() - c1.getRed()) * i / 255, c1.getGreen() + (c2.getGreen() - c1.getGreen()) * i / 255, c1.getBlue() + (c2.getBlue() - c1.getBlue()) * i / 255);
            ++i;
        }
    }

    public void run() {
        while (true) {
            if (this.running) {
                this.tick();
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Thread.yield();
        }
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    private void tick() {
        int it = 0;
        while (it < 10) {
            int j;
            int i = 1;
            while (i <= this.dwidth) {
                j = 1;
                while (j <= this.dheight) {
                    if (!this.wall[i][j]) {
                        this.vx[i][j] = !this.wall[i - 1][j] ? -this.d * (this.p[i][j] - this.p[i - 1][j]) : 0.0;
                        this.vy[i][j] = !this.wall[i][j - 1] ? -this.d * (this.p[i][j] - this.p[i][j - 1]) : 0.0;
                    } else {
                        this.vy[i][j] = 0.0;
                        this.vx[i][j] = 0.0;
                    }
                    ++j;
                }
                ++i;
            }
            i = 1;
            while (i < this.dwidth) {
                j = 1;
                while (j < this.dheight) {
                    double[] dArray = this.p[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.c * (this.vx[i][j] - this.vx[i + 1][j] + this.vy[i][j] - this.vy[i][j + 1]);
                    ++j;
                }
                ++i;
            }
            ++it;
        }
        int i = 0;
        while (i < 1000) {
            this.isHit(i);
            switch (this.a[i]) {
                case 0: {
                    int vy = 1;
                    break;
                }
                case 1: {
                    int vx = 1;
                    if (this.x[i] % 2 != 1) break;
                    int vy = 1;
                    break;
                }
                case 2: {
                    int vx = 1;
                    if (this.x[i] % 2 != 0) break;
                    int vy = -1;
                    break;
                }
                case 3: {
                    int vy = -1;
                    break;
                }
                case 4: {
                    int vx = -1;
                    if (this.x[i] % 2 != 0) break;
                    int n = -1;
                    break;
                }
                case 5: {
                    int vx = -1;
                    if (this.x[i] % 2 != 1) break;
                    int n = 1;
                }
            }
            ++i;
        }
        this.repaint();
    }

    final boolean isHit(int i) {
        return this.wall[this.x[i]][this.y[i]];
    }

    public WindTunnel() {
        this.restart();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                WindTunnel.this.createFrom = e.getPoint();
            }

            public void mouseReleased(MouseEvent e) {
                WindTunnel.this.createFrom = null;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                WindTunnel.this.createFrom = e.getPoint();
            }

            public void mouseMoved(MouseEvent e) {
                WindTunnel.this.mx = e.getX() / WindTunnel.this.sx;
                WindTunnel.this.my = e.getY() / WindTunnel.this.sy;
                if (WindTunnel.this.mx < 0 || WindTunnel.this.mx > WindTunnel.this.dwidth) {
                    WindTunnel.this.mx = 0;
                }
                if (WindTunnel.this.my < 0 || WindTunnel.this.my > WindTunnel.this.dheight) {
                    WindTunnel.this.my = 0;
                }
            }
        });
        this.thread.start();
    }

    public void doCreateParticle() {
        if (this.createFrom != null) {
            int px = (int)(this.createFrom.getX() / (double)this.sx);
            int py = (int)(this.createFrom.getY() / (double)this.sy);
            int disp = this.particleDispersion;
            if (px < this.dwidth && px > 0 && py < this.dheight && py > 0) {
                int i = 0;
                while (i < 5) {
                    this.particles.add(new Particle(this.me, this.createFrom.x + this.rand.nextInt() % disp - disp / 2, this.createFrom.y + this.rand.nextInt() % disp - disp / 2));
                    ++i;
                }
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.linesVisible) {
            int i = 0;
            while (i < this.dwidth) {
                int j = 0;
                while (j < this.dheight) {
                    if (!(this.rand.nextDouble() > this.linesProp)) {
                        g.setColor(this.cols[this.toIdx(this.p[i][j] * 128.0 + 128.0)]);
                        g.drawLine(i * this.sx, j * this.sy + i % this.sy, i * this.sx + (int)(this.vx[i][j] * (double)this.sx * this.arrowscale), j * this.sy + i % this.sy + (int)(this.vy[i][j] * (double)this.sy * this.arrowscale));
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.doCreateParticle();
        Enumeration en = this.particles.elements();
        while (en.hasMoreElements()) {
            Particle pa = (Particle)en.nextElement();
            int px = (int)(pa.x / (double)this.sx);
            int py = (int)(pa.y / (double)this.sy);
            boolean die = false;
            if (px < this.dwidth && px > 0 && py < this.dheight && py > 0) {
                pa.vx = this.vx[px][py] * 1000.0;
                pa.vy = this.vy[px][py] * 1000.0;
                if (pa.vx == 0.0 && pa.vy == 0.0) {
                    die = true;
                }
                pa.paint(g);
            } else {
                die = true;
            }
            if (!die) continue;
            this.particles.remove(pa);
        }
    }

    public int toIdx(double d) {
        if (d < 0.0) {
            return 0;
        }
        if (d < 256.0) {
            return (int)d;
        }
        return 255;
    }

    public double getDrivingPressure() {
        return this.drivingPressure;
    }

    public void setDrivingPressure(double drivingPressure) {
        this.drivingPressure = drivingPressure;
        this.setBlowerOn(true);
    }
}

