/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.server;

import com.cudos.server.client.LoginError;
import com.cudos.server.client.TestResult;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class Student {
    String firstName;
    String middleInitials;
    String lastName;
    String school;
    String userID;
    Date dob;
    Vector loginDates;
    InetAddress lastLoginAddress;
    private String password;
    Object details;
    Vector files = new Vector();
    Vector fileNames = new Vector();
    Vector testResults = new Vector();
    int sid;
    static int serialid = 0;

    public Student(String forename, String middleInitials, String surname, String sch) {
        this.firstName = forename;
        this.middleInitials = middleInitials;
        this.lastName = surname;
        this.school = sch;
        this.sid = serialid++;
    }

    public Student(String forename, String surname) {
        this(forename, "", surname, "");
    }

    public String getName() {
        return String.valueOf(this.firstName) + " " + this.middleInitials + ". " + this.lastName;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setDob(int year, int month, int date) {
        Calendar c = Calendar.getInstance();
        c.set(year, month, date);
        this.dob = c.getTime();
    }

    public void addTestResult(TestResult t) {
        this.testResults.add(t);
    }

    public Object getSavedFile(String name) {
        int i = 0;
        while (i < this.fileNames.size()) {
            if (((String)this.fileNames.get(i)).equalsIgnoreCase(name)) {
                return this.files.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean checkPassword(String pass) {
        return pass.equalsIgnoreCase(this.password);
    }

    public Date getLastLoginDate() {
        if (this.loginDates.size() == 0) {
            return null;
        }
        return (Date)this.loginDates.get(this.loginDates.size() - 1);
    }

    public void addLoginDate() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        this.loginDates.add(c.getTime());
    }

    protected void dump(PrintStream o) {
        o.println("Name: " + this.firstName + " " + this.lastName);
        o.println("DOB: " + this.dob);
        o.println("School: " + this.school);
        o.println("UserID: " + this.userID);
        o.print("Logins: ");
        int i = 0;
        while (i < this.loginDates.size()) {
            if (i > 0) {
                o.print(", ");
            }
            o.print(this.loginDates.get(i));
            ++i;
        }
        o.println();
        o.print("Files: ");
        i = 0;
        while (i < this.fileNames.size()) {
            if (i > 0) {
                o.print(", ");
            }
            o.print(this.fileNames.get(i));
            ++i;
        }
        o.println();
        o.print("Test results: ");
        i = 0;
        while (i < this.testResults.size()) {
            if (i > 0) {
                o.print(", ");
            }
            o.print(this.testResults.get(i));
            ++i;
        }
        o.println();
    }

    public void changePassword(String oldPassword, String newPassword) throws LoginError {
        if (!this.checkPassword(oldPassword)) {
            throw new LoginError("Incorrect password. Password not changed.");
        }
        this.password = newPassword;
    }
}

