/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.server;

import com.cudos.server.Student;
import com.cudos.server.StudentList;
import com.cudos.server.client.ClientHandle;
import com.cudos.server.client.LoginError;
import com.cudos.server.client.Server;
import com.cudos.server.client.TestResult;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;

public class CudosServer
extends UnicastRemoteObject
implements Server {
    private String studentFile = "E://students.ser";
    private StudentList students;
    private Hashtable connectionTable = new Hashtable();

    public static void main(String[] argv) {
        try {
            CudosServer s = new CudosServer();
            Naming.rebind("http:///www.cudos.ac.uk/CudosServer.obj", s);
        }
        catch (Exception e) {
            System.out.println("Server not initialised:");
            e.printStackTrace();
        }
    }

    public CudosServer() throws RemoteException {
        try {
            this.students = (StudentList)new ObjectInputStream(new FileInputStream(this.studentFile)).readObject();
        }
        catch (Exception e) {
            System.out.println("Student file could not be loaded:");
            e.printStackTrace();
        }
    }

    private void createID(Student s) {
        String id = "";
        while (this.students.getStudentByUserID(id = String.valueOf(s.firstName.substring(0, 3)) + s.lastName.substring(0, 3) + String.valueOf((int)(Math.random() * 1000.0))) != null) {
        }
        s.userID = id;
    }

    public ClientHandle login(String userName, String password) throws LoginError {
        Student s = this.students.getStudentByUserID(userName);
        if (s == null) {
            throw new LoginError("No such student '" + userName + "'");
        }
        if (!s.checkPassword(password)) {
            throw new LoginError("Incorrect password");
        }
        ClientHandle handle = new ClientHandle();
        this.connectionTable.put(handle, s);
        s.addLoginDate();
        return handle;
    }

    public void logout(ClientHandle h) {
        this.connectionTable.remove(h);
    }

    public String[] getFilenames(ClientHandle h) {
        return ((Student)this.connectionTable.get((Object)h)).fileNames.toArray(new String[0]);
    }

    public void saveFile(ClientHandle h, String filename, Object file) {
        Student s = (Student)this.connectionTable.get(h);
        int i = 0;
        while (i < s.fileNames.size()) {
            if (filename.equalsIgnoreCase((String)s.fileNames.get(i))) {
                s.files.set(i, file);
                return;
            }
            ++i;
        }
        s.fileNames.add(filename);
        s.files.add(file);
    }

    public void deleteFile(ClientHandle h, String filename) {
        Student s = (Student)this.connectionTable.get(h);
        int i = 0;
        while (i < s.fileNames.size()) {
            if (filename.equalsIgnoreCase((String)s.fileNames.get(i))) {
                s.files.remove(i);
                s.fileNames.remove(i);
                break;
            }
            ++i;
        }
    }

    public Object getFile(ClientHandle h, String filename) {
        Student s = (Student)this.connectionTable.get(h);
        int i = 0;
        while (i < s.fileNames.size()) {
            if (filename.equalsIgnoreCase((String)s.fileNames.get(i))) {
                return s.files.get(i);
            }
            ++i;
        }
        return null;
    }

    public void addTestResult(ClientHandle h, TestResult r) {
        ((Student)this.connectionTable.get(h)).addTestResult(r);
    }

    public Vector getTestResults(ClientHandle h) {
        return ((Student)this.connectionTable.get((Object)h)).testResults;
    }

    public ClientHandle createUser(String surname, String forename, String school, Calendar date) throws LoginError {
        Student s = new Student(forename, "", surname, school);
        s.dob = date.getTime();
        this.createID(s);
        return this.login(s.userID, "");
    }

    public void changePassword(ClientHandle h, String oldPassword, String newPassword) throws LoginError {
        ((Student)this.connectionTable.get(h)).changePassword(oldPassword, newPassword);
    }

    public String getUserID(ClientHandle handle) {
        return ((Student)this.connectionTable.get(handle)).getUserID();
    }
}

