/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.photon;

import com.cudos.common.GraphPaper;
import com.cudos.common.Spectrum;
import com.cudos.photon.PhotonSource;
import com.cudos.photon.Photoreceptor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.Vector;

public class WavelengthGraph
extends GraphPaper {
    int minW = 300;
    int maxW = 800;
    public Vector receptors = new Vector();
    public Vector sources = new Vector();
    Color[] color = new Color[]{new Color(92, 64, 255), Color.green, Color.red};
    int dw = 10;

    public WavelengthGraph() {
        this.setXRange(this.minW, this.maxW);
        this.setYRange(0.0, 1.0);
    }

    public void paint(Graphics g) {
        super.paint(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i = 0;
        while (i < this.receptors.size()) {
            g.setColor(this.color[i % this.color.length]);
            Photoreceptor r = (Photoreceptor)this.receptors.get(i);
            int ow = this.minW;
            double oa = r.getAbsorption(ow);
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            int w = this.minW;
            while (w < this.maxW) {
                double a = r.getAbsorption(w);
                this.drawLine(g, ow, oa, w, a);
                ow = w;
                oa = a;
                w += this.dw;
            }
            ++i;
        }
        i = 0;
        while (i < this.sources.size()) {
            PhotonSource s = (PhotonSource)this.sources.get(i);
            int w = s.getWavelength();
            g.setColor(Spectrum.getColorForWavelength(w));
            g.fillRect(this.xS(w) - 20, this.yS(0.0), 40, this.yS(s.getIntensity()));
            ((Graphics2D)g).setStroke(new BasicStroke(3.0f));
            this.drawLine(g, w, 0.0, w, s.getIntensity() * 10.0);
            Point rr = this.toScreen(new Point2D.Double(w, 10.0 * s.getIntensity()));
            if (s.isRunning()) {
                this.drawArrow(g, rr.x, this.getHeight() - rr.y);
            }
            ++i;
        }
    }

    void drawArrow(Graphics g, int x, int s) {
        g.fillRect(x - s / 9, 0, 2 * s / 9, s);
        g.fillPolygon(new int[]{x - s / 5, x + s / 5, x}, new int[]{s, s, s + 10}, 3);
    }
}

