/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.photon;

import com.cudos.common.CudosExhibit;
import com.cudos.common.DraggableComponent;
import com.cudos.photon.Photon;
import com.cudos.photon.PhotoreceptorPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JLabel;

public class Photoreceptor
extends DraggableComponent {
    public static int SHORT_WAVELENGTH = 300;
    public static int MEDIUM_WAVELENGTH = 510;
    public static int LONG_WAVELENGTH = 570;
    int freq;
    JLabel wlabel = new JLabel();
    static Image image;
    int baseWavelength;
    double[] absorptionSpectrum;
    int peakWavelengthRelative;
    public double activity;
    protected float overallSensitivity = 0.2f;
    public static int SHAPE_SCONE;
    public static int SHAPE_RGCONE;
    public static int SHAPE_ROD;
    public int absorptionShape = SHAPE_RGCONE;

    static {
        SHAPE_SCONE = 0;
        SHAPE_RGCONE = 1;
        SHAPE_ROD = 2;
    }

    public Photoreceptor(int freq) {
        this.setSize(new Dimension(64, 32));
        this.freq = freq;
        this.setLayout(null);
        this.setOpaque(false);
        this.add(this.wlabel);
        this.wlabel.setLocation(22, 19);
        this.wlabel.setSize(35, 12);
        this.wlabel.setFont(new Font("Dialog", 0, 9));
        this.wlabel.setBackground(Color.black);
        this.wlabel.setForeground(Color.green);
        this.wlabel.setOpaque(true);
        this.setup();
        this.wlabel.setText(String.valueOf(this.getPeakWavelength()) + " nm");
    }

    public void dragTo(Point p) {
        PhotoreceptorPanel pp = (PhotoreceptorPanel)this.getParent();
        p.x = pp.photoreceptorX;
        super.dragTo(p);
    }

    public void paint(Graphics g) {
        if (image != null) {
            g.drawImage(image, 0, 0, this);
            g.setColor(Color.red);
            g.fill3DRect(19, 11, (int)((double)this.getWidth() * this.activity * 0.5), 10, true);
        }
        super.paint(g);
    }

    public void addNotify() {
        super.addNotify();
        if (image == null) {
            image = CudosExhibit.getApplet(this).getImage("resources/icons/photoreceptors/photoreceptor.gif");
        }
    }

    public double getAbsorption(int wavelength) {
        int i = wavelength - this.baseWavelength;
        if (i > 0 && i < this.absorptionSpectrum.length) {
            return this.absorptionSpectrum[i];
        }
        return 0.0;
    }

    public int getPeakWavelength() {
        return this.peakWavelengthRelative + this.baseWavelength;
    }

    public void setPeakWavelength(int p) {
        this.baseWavelength = p - this.peakWavelengthRelative;
        this.setup();
    }

    public void setAbsorptionShape(int shape) {
        this.absorptionShape = shape;
        this.setup();
    }

    public void receivePhoton(Photon photon) {
        this.activity += (double)this.overallSensitivity * this.getAbsorption(photon.wavelength);
        this.repaint();
    }

    public void tick() {
        this.activity *= 0.96;
        this.repaint();
    }

    public void setup() {
        int mid;
        this.baseWavelength = this.freq;
        this.absorptionSpectrum = new double[300];
        this.peakWavelengthRelative = mid = this.absorptionSpectrum.length / 2;
        int i = 0;
        while (i < this.absorptionSpectrum.length) {
            this.absorptionSpectrum[i] = this.absorptionShape == SHAPE_SCONE ? 0.5 * Math.exp((double)(-(i - mid + 50) * (i - mid + 50)) / 11000.0) + 0.2 * Math.exp((double)(-(i - mid - 50) * (i - mid - 50)) / 4500.0) : 0.6 * Math.exp((double)(-(i - mid) * (i - mid)) / 4500.0);
            ++i;
        }
    }
}

