/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.photon;

import com.cudos.common.CudosExhibit;
import com.cudos.common.DraggableComponent;
import com.cudos.photon.Photon;
import com.cudos.photon.PhotoreceptorPanel;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;

public class PhotonSource
extends DraggableComponent
implements Runnable {
    public JToggleButton onoff = new JToggleButton();
    JLabel wlabel = new JLabel();
    int my;
    static Image image;
    int wavelength;
    int delay = 100;
    ActionListener actionlistener = null;
    Thread thread = new Thread(this);
    boolean running = false;

    public PhotonSource() {
        this.setLayout(null);
        this.setOpaque(false);
        this.setSize(new Dimension(64, 32));
        this.thread.start();
        this.add(this.onoff);
        this.onoff.setSize(new Dimension(8, 8));
        this.onoff.setLocation(4, 2);
        this.onoff.setBackground(Color.red);
        this.onoff.setCursor(new Cursor(12));
        this.onoff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PhotonSource.this.onoff.isSelected()) {
                    PhotonSource.this.start();
                    PhotonSource.this.onoff.setBackground(Color.green);
                } else {
                    PhotonSource.this.stop();
                    PhotonSource.this.onoff.setBackground(Color.red);
                }
                if (PhotonSource.this.actionlistener != null) {
                    PhotonSource.this.actionlistener.actionPerformed(new ActionEvent(this, 1001, "OnOffPressed"));
                }
                PhotonSource.this.repaint();
            }
        });
        this.onoff.setToolTipText("Photon source on/off");
        this.wlabel.setToolTipText("Photon frequency");
        this.add(this.wlabel);
        this.wlabel.setLocation(5, 19);
        this.wlabel.setSize(35, 12);
        this.wlabel.setFont(new Font("Dialog", 0, 9));
        this.wlabel.setBackground(Color.black);
        this.wlabel.setForeground(Color.green);
        this.wlabel.setOpaque(true);
        this.wlabel.setCursor(new Cursor(8));
        this.wlabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                PhotonSource.this.my = e.getY();
            }
        });
        this.wlabel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                int dy = e.getY() - PhotonSource.this.my;
                PhotonSource.this.my = e.getY();
                PhotonSource.this.setWavelength(PhotonSource.this.getWavelength() - dy);
            }
        });
        this.setForeground(Color.red);
        this.setWavelength(600);
    }

    public PhotonSource(int wavelength) {
        this();
        this.setWavelength(wavelength);
    }

    public void paint(Graphics g) {
        if (image != null) {
            g.drawImage(image, 0, 0, this);
            if (this.onoff.isSelected()) {
                g.fill3DRect(4, 11, (int)((double)this.getWidth() * this.getIntensity() * 15.0), 10, true);
            }
        }
        super.paint(g);
    }

    public void addNotify() {
        super.addNotify();
        if (image == null) {
            image = CudosExhibit.getApplet(this).getImage("resources/icons/photoreceptors/photonsource.gif");
        }
    }

    public void dragTo(Point p) {
        PhotoreceptorPanel pp = (PhotoreceptorPanel)this.getParent();
        p.x = Math.min(p.x, pp.maxSourceX - this.getWidth());
        super.dragTo(p);
    }

    public int getWavelength() {
        return this.wavelength;
    }

    public void setWavelength(int wavelength) {
        this.wavelength = wavelength = Math.max(Math.min(wavelength, 800), 300);
        this.wlabel.setText(String.valueOf(String.valueOf(wavelength)) + " nm");
        if (this.actionlistener != null) {
            this.actionlistener.actionPerformed(new ActionEvent(this, 1001, "WavelengthChange"));
        }
    }

    public double getIntensity() {
        return 1.0 / (double)this.delay;
    }

    public void setIntensity(double i) {
        this.delay = (int)(1.0 / i);
    }

    public void addActionListener(ActionListener al) {
        this.actionlistener = AWTEventMulticaster.add(al, this.actionlistener);
    }

    public void removeActionListener(ActionListener al) {
        this.actionlistener = AWTEventMulticaster.remove(al, this.actionlistener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            JComponent p;
            if (this.running) {
                p = (PhotoreceptorPanel)this.getParent();
                if (p == null) {
                    return;
                }
                Photon photon = new Photon();
                photon.setWavelength(this.wavelength);
                int h = (int)(Math.random() * (double)this.getHeight());
                photon.setLocation(this.getX() + this.getWidth(), this.getY() + h);
                ((PhotoreceptorPanel)p).photons.add(photon);
                ((PhotoreceptorPanel)p).add(photon);
                try {
                    Thread.sleep(this.delay);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                p = this;
                synchronized (p) {
                    this.wait();
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public synchronized void start() {
        this.running = true;
        this.notifyAll();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }
}

