/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.photon;

import java.awt.color.ColorSpace;

class MacleodBoyntonSpace
extends ColorSpace {
    float rt3 = (float)Math.sqrt(3.0);
    float rt2 = (float)Math.sqrt(2.0);
    float[] whitepoint = new float[]{0.5f, 0.5f, 0.5f};
    float[] ushort = new float[]{-1.0f / this.rt3, 0.6f / this.rt3, 1.0f / this.rt3};
    float[] ulong = new float[]{1.0f / this.rt2, -1.0f / this.rt2, 0.0f};
    static final String[] names = new String[]{"Brightness", "Shortwave", "Longwave"};

    public float[] fromCIEXYZ(float[] colorvalue) {
        return colorvalue;
    }

    public float[] fromRGB(float[] rgbvalue) {
        return rgbvalue;
    }

    public float[] toCIEXYZ(float[] colorvalue) {
        return colorvalue;
    }

    public float[] toRGB(float[] colorvalue) {
        float[] r = new float[3];
        float ampl = 0.0f;
        int i = 0;
        while (i < 3) {
            r[i] = this.whitepoint[i] + colorvalue[1] * this.ushort[i] + colorvalue[2] * this.ulong[i];
            ampl += r[i];
            ++i;
        }
        float scale = 3.0f * colorvalue[0] / ampl;
        int i2 = 0;
        while (i2 < 3) {
            int n = i2++;
            r[n] = r[n] * scale;
        }
        return r;
    }

    public String getName(int idx) {
        return names[idx];
    }

    public boolean isCS_sRGB() {
        return false;
    }

    public MacleodBoyntonSpace() {
        super(2, 3);
    }
}

