/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.photon;

import com.cudos.photon.MacleodBoyntonSpace;
import com.cudos.photon.Photoreceptor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.util.Vector;
import javax.swing.JPanel;

public class ColourTriangle
extends JPanel
implements Runnable {
    public Vector receptors;
    public Object notifier;
    int cw = 100;
    int ch = 100;
    public Raster colourRaster = Raster.createInterleavedRaster(0, this.cw, this.ch, 3, new Point(0, 0));
    public ColorSpace CIE = ColorSpace.getInstance(1001);
    public ColorSpace RGB = ColorSpace.getInstance(1000);
    public ColorSpace colourSpace;
    public ColorModel colourModel;
    ColorModel dataColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    Thread thread = new Thread((Runnable)this, "triangle updater");
    int[] pixels;
    Image image;
    MemoryImageSource imageSource;
    int indicatorRadius = 8;

    public ColourTriangle() {
        this.setColourSpace(new MacleodBoyntonSpace());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ColourTriangle.this.init();
            }
        });
        this.thread.start();
    }

    public void addNotify() {
        super.addNotify();
        this.init();
    }

    public void setColourSpace(ColorSpace c) {
        this.colourSpace = c;
        this.setModel();
    }

    public ColorSpace getColourSpace() {
        return this.colourSpace;
    }

    public void setModel() {
        this.colourModel = new ComponentColorModel(this.colourSpace, new int[]{8, 8, 8}, false, false, 1, 0);
        this.fillPixels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (this.notifier != null) {
                Object object = this.notifier;
                synchronized (object) {
                    try {
                        this.notifier.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.repaint();
        }
    }

    void init() {
        this.pixels = new int[this.getWidth() * this.getHeight()];
        this.fillPixels();
    }

    void fillPixels() {
        int w = this.getWidth();
        int h = this.getHeight();
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                this.pixels[i + j * w] = this.getRGBIntFromLUV(new float[]{0.5f, (float)i / (float)w - 0.5f, (float)j / (float)h - 0.5f});
                ++j;
            }
            ++i;
        }
        this.imageSource = new MemoryImageSource(w, h, this.pixels, 0, w);
        this.imageSource.setAnimated(true);
        this.image = this.createImage(this.imageSource);
    }

    public void paint(Graphics g_) {
        super.paint(g_);
        Graphics2D g = (Graphics2D)g_;
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this);
        }
        float[] f = this.getReceived();
        f[1] = Math.min(Math.max(f[1] + 0.5f, 0.0f), 1.0f);
        f[2] = Math.min(Math.max(f[2] + 0.5f, 0.0f), 1.0f);
        int x = (int)(f[1] * (float)this.getWidth());
        int y = (int)(f[2] * (float)this.getHeight());
        g.setColor(Color.white);
        int r = this.indicatorRadius;
        g.drawLine(0, y, x, y);
        g.drawLine(x, 0, x, y);
        g.fillOval(x - r, y - r, 2 * r, 2 * r);
        g.setColor(Color.black);
        g.fillOval(x - r + 2, y - r + 2, 2 * r - 4, 2 * r - 4);
    }

    public float[] getReceived() {
        float total;
        float lw;
        float mw;
        float sw;
        try {
            sw = (float)((Photoreceptor)this.receptors.get((int)0)).activity;
            mw = (float)((Photoreceptor)this.receptors.get((int)1)).activity;
            lw = (float)((Photoreceptor)this.receptors.get((int)2)).activity;
            total = sw + mw + lw;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return new float[]{total / 3.0f, sw / (mw + lw) - 0.5f, lw / mw - 0.5f};
    }

    public int getRGBReceived() {
        return this.getRGBIntFromLUV(this.getReceived());
    }

    public float[] getRGBfromLUV(float[] c) {
        return this.colourSpace.toRGB(c);
    }

    public float[] getLUVfromRGB(float[] c) {
        return this.colourSpace.fromRGB(c);
    }

    public Color getColourFromLUV(float[] c) {
        float[] t = this.getRGBfromLUV(c);
        return new Color(this.ftr(t[0]), this.ftr(t[1]), this.ftr(t[2]));
    }

    public int getRGBIntFromLUV(float[] c) {
        float[] t = this.getRGBfromLUV(c);
        return 0xFF000000 | this.ftr(t[0]) << 16 | this.ftr(t[1]) << 8 | this.ftr(t[2]);
    }

    int ftr(float f) {
        return Math.max(Math.min((int)(f * 256.0f), 255), 0);
    }

    int fts(float f) {
        return Math.max(Math.min((int)f, 255), 0);
    }
}

