/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.mechanics;

import com.cudos.mechanics.MechanicsComponent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Spring
extends MechanicsComponent {
    transient JPanel panel;
    transient JSlider lslider;
    transient JSlider kslider;
    transient JLabel llabel;
    transient JLabel klabel;
    double linefrac = 0.1;
    int nzigs = 7;
    int dx = 20;
    double minimumLength = 2.0 * this.linefrac * this.getNaturalLength();
    double springConstant = 2.0;

    public Spring() {
        this.createPanel();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.createPanel();
    }

    void createPanel() {
        this.panel = new JPanel();
        this.lslider = new JSlider();
        this.kslider = new JSlider();
        this.llabel = new JLabel("Natural length");
        this.klabel = new JLabel("Spring constant");
        this.lslider.setPreferredSize(new Dimension(100, 30));
        this.lslider.setMinimum(30);
        this.lslider.setMaximum(150);
        this.lslider.setValue((int)this.getNaturalLength());
        this.kslider.setPreferredSize(new Dimension(100, 30));
        this.kslider.setMaximum(150);
        this.kslider.setValue((int)(this.getSpringConstant() * 10.0));
        this.panel.add(this.llabel);
        this.panel.add(this.lslider);
        this.panel.add(this.klabel);
        this.panel.add(this.kslider);
        this.lslider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Spring.this.setNaturalLength(Spring.this.lslider.getValue());
            }
        });
        this.kslider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Spring.this.setSpringConstant((double)Spring.this.kslider.getValue() / 10.0);
            }
        });
    }

    public void paint(Graphics g) {
        Point next;
        int y1 = (int)this.top.y;
        int y2 = (int)this.bottom.y;
        g.drawLine(this.top.x, y1, this.x, y1);
        g.drawLine(this.x, y2, this.bottom.x, y2);
        double dy = (double)(y2 - y1) * (1.0 - 2.0 * this.linefrac) / ((double)this.nzigs + 0.5);
        Point last = new Point(this.x, y1 + (int)((double)(y2 - y1) * this.linefrac + 0.5 * dy));
        g.drawLine(this.x, y1, last.x, last.y);
        double cy = (double)y1 + (double)(y2 - y1) * this.linefrac;
        int i = 0;
        while (i < this.nzigs - 1) {
            next = i % 2 == 0 ? new Point(this.x + this.dx, (int)cy) : new Point(this.x - this.dx, (int)(cy += dy));
            g.drawLine(last.x, last.y, next.x, next.y);
            last = next;
            ++i;
        }
        next = new Point(this.x, y1 + (int)((double)(y2 - y1) * (1.0 - this.linefrac) - dy));
        g.drawLine(last.x, last.y, next.x, next.y);
        g.drawLine(next.x, next.y, this.x, y2);
    }

    public boolean contains(Point p) {
        Rectangle bounds = new Rectangle(this.x - this.dx, (int)this.top.y + 4, this.dx * 2, (int)(this.bottom.y - this.top.y - 8.0));
        return bounds.contains(p);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public double getSpringConstant() {
        return this.springConstant;
    }

    public void setSpringConstant(double d) {
        this.springConstant = d;
    }

    public double getTension() {
        double length = this.bottom.y - this.top.y;
        double tension = this.springConstant * (length - this.naturalLength);
        if (length < this.minimumLength) {
            tension += this.bottom.getImpulsiveStop(this.top);
        }
        return tension;
    }

    public boolean canResizeBy(double dl) {
        return dl < 0.0 ? this.getLength() >= this.minimumLength : true;
    }
}

