/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.mechanics;

import com.cudos.mechanics.BaseComponent;
import com.cudos.mechanics.MechanicsComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Node
extends BaseComponent {
    transient JPanel panel;
    transient JSlider massSlider;
    transient JLabel massLabel;
    transient JCheckBox fixedcheck;
    public int x;
    public double y;
    public double mass = 1.0;
    private Vector components = new Vector();
    int radius = 5;
    int labelx = 25;
    int leftLabelx = -25;
    double forceScale = 0.33;
    boolean drawExternalForces = true;
    boolean drawInternalForces = true;
    double force = 0.0;
    double externalForce;
    double internalForce;
    double v = 0.0;
    boolean fixed = false;
    static double dt = 0.1;
    static double g = 9.8;
    static boolean gravity = true;

    public Node() {
        this.createPanel();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.createPanel();
    }

    void createPanel() {
        this.panel = new JPanel();
        this.massLabel = new JLabel("Mass");
        this.massSlider = new JSlider();
        this.fixedcheck = new JCheckBox("Fixed");
        this.massSlider.setMinimum(1);
        this.massSlider.setMaximum(500);
        this.massSlider.setPreferredSize(new Dimension(100, 30));
        this.massSlider.setValue((int)(this.mass * 100.0));
        this.panel.add(this.massLabel);
        this.panel.add(this.massSlider);
        this.panel.add(this.fixedcheck);
        this.massSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Node.this.mass = (double)Node.this.massSlider.getValue() / 100.0;
            }
        });
        this.fixedcheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Node.this.fixed = Node.this.fixedcheck.isSelected();
            }
        });
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        int i = 0;
        while (i < this.components.size()) {
            MechanicsComponent c = (MechanicsComponent)this.components.get(i);
            double dl = 0.0;
            dl = this == c.top ? this.y - d : d - this.y;
            if (!c.canResizeBy(dl)) {
                return;
            }
            ++i;
        }
        this.y = d;
    }

    public void addComponent(MechanicsComponent c) {
        this.components.add(c);
        this.setPos();
    }

    public void removeComponent(MechanicsComponent c) {
        this.components.remove(c);
        this.setPos();
    }

    public int nComponents() {
        return this.components.size();
    }

    public Vector getComponents() {
        return this.components;
    }

    public void setPos() {
        if (this.components.size() == 0) {
            return;
        }
        if (this.components.size() == 1) {
            this.x = ((MechanicsComponent)this.components.get((int)0)).x;
        } else {
            int totalx = 0;
            int i = 0;
            while (i < this.components.size()) {
                totalx += ((MechanicsComponent)this.components.get((int)i)).x;
                ++i;
            }
            this.x = totalx / this.components.size();
        }
    }

    Point getPoint() {
        return new Point(this.x, (int)this.y);
    }

    public void paint(Graphics g) {
        String string;
        Point end;
        Point c = this.getPoint();
        g.fillOval(c.x - this.radius, c.y - this.radius, this.radius * 2, this.radius * 2);
        if (this.drawExternalForces && this.externalForce != 0.0) {
            end = new Point(c.x + this.labelx, (int)((double)c.y + this.externalForce * this.forceScale));
            g.setColor(Color.blue);
            this.drawForceArrow(g, c.x + this.labelx, c.y, end.x, end.y);
            string = String.valueOf(Math.abs((double)((int)(this.externalForce * 10.0)) / 10.0));
            g.drawString(string, c.x + this.labelx + this.radius, c.y);
        }
        if (this.drawInternalForces && this.internalForce != 0.0) {
            end = new Point(c.x + this.leftLabelx, (int)((double)c.y + this.internalForce * this.forceScale));
            g.setColor(new Color(0, 128, 0));
            this.drawForceArrow(g, c.x + this.leftLabelx, c.y, end.x, end.y);
            string = String.valueOf(Math.abs((int)(this.internalForce * 10.0) / 10));
            g.drawString(string, c.x + this.leftLabelx - this.radius - 20, c.y);
        }
    }

    public void drawForceArrow(Graphics g, int x1, int y1, int x2, int y2) {
        ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
        g.drawLine(x1, y1, x2, y2);
        int bhat = y2 - y1 > 0 ? 1 : -1;
        g.fillPolygon(new int[]{x2, x2 - this.radius / 2, x2 + this.radius / 2}, new int[]{y2, y2 - this.radius * bhat, y2 - this.radius * bhat}, 3);
    }

    public boolean contains(Point p) {
        return p.distance(this.getPoint()) < (double)this.radius;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void pull(double forceDownwards) {
        this.force += forceDownwards;
    }

    public double getImpulsiveStop(Node relativeTo) {
        double dv = this.v - relativeTo.v;
        return dv * this.mass / dt;
    }

    public void move() {
        this.externalForce = 0.0;
        if (gravity) {
            this.externalForce += this.mass * g;
        }
        if (this.fixed) {
            this.externalForce += -this.force - this.externalForce - this.v / dt * this.mass;
        }
        this.force += this.externalForce;
        double dv = dt * this.force / this.mass;
        this.v += dv;
        this.y += dt * this.v;
        this.internalForce = this.force;
        this.force = 0.0;
    }
}

