/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.mechanics;

import com.cudos.common.SelectionRecipient;
import com.cudos.mechanics.BaseComponent;
import com.cudos.mechanics.MechanicsComponent;
import com.cudos.mechanics.MechanicsData;
import com.cudos.mechanics.Node;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;

public class MechanicsDisplay
extends JPanel {
    MechanicsData data;
    Point lastMouse;
    boolean tempfixed;
    BaseComponent selectedComponent;
    public SelectionRecipient selectionListener;

    public MechanicsDisplay() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setData(MechanicsData d) {
        this.data = d;
        this.repaint();
        this.setSelected(null);
    }

    public MechanicsData getData() {
        return this.data;
    }

    public void paint(Graphics g_) {
        super.paint(g_);
        Graphics2D g = (Graphics2D)g_;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(4.0f));
        if (this.data != null) {
            BaseComponent[] c = this.data.getAllComponents();
            int i = 0;
            while (i < c.length) {
                if (c[i].isSelected()) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                c[i].paint(g);
                ++i;
            }
        }
    }

    private void jbInit() throws Exception {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                MechanicsDisplay.this.this_componentResized(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                MechanicsDisplay.this.this_mouseDragged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                MechanicsDisplay.this.this_mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                MechanicsDisplay.this.this_mouseReleased(e);
            }
        });
    }

    void this_mousePressed(MouseEvent e) {
        Point p;
        this.lastMouse = p = e.getPoint();
        Node[] n = this.data.getNodes();
        int i = 0;
        while (i < n.length) {
            if (n[i].contains(p)) {
                this.setSelected(n[i]);
                this.tempfixed = n[i].fixed;
                n[i].fixed = true;
                return;
            }
            ++i;
        }
        MechanicsComponent[] c = this.data.getComponents();
        int i2 = 0;
        while (i2 < c.length) {
            if (c[i2].contains(p)) {
                this.setSelected(c[i2]);
                return;
            }
            ++i2;
        }
        this.setSelected(null);
    }

    void this_mouseReleased(MouseEvent e) {
        if (this.getSelected() instanceof Node) {
            Node n = (Node)this.getSelected();
            n.fixed = this.tempfixed;
        }
    }

    void this_mouseDragged(MouseEvent e) {
        if (this.getSelected() != null) {
            if (this.getSelected() instanceof Node) {
                Node n = (Node)this.getSelected();
                n.setY(n.getY() + (double)e.getY() - (double)this.lastMouse.y);
            } else if (this.getSelected() instanceof MechanicsComponent) {
                MechanicsComponent c = (MechanicsComponent)this.getSelected();
                c.x += e.getX() - this.lastMouse.x;
                c.top.setPos();
                c.bottom.setPos();
            }
            this.repaint();
        }
        this.lastMouse = e.getPoint();
    }

    public void setSelectionRecipient(SelectionRecipient r) {
        this.selectionListener = r;
    }

    public SelectionRecipient getSelectionRecipient() {
        return this.selectionListener;
    }

    public void setSelected(BaseComponent c) {
        if (this.selectedComponent != null) {
            this.selectedComponent.setSelected(false);
        }
        this.selectedComponent = c;
        if (c != null) {
            c.setSelected(true);
        }
        this.selectionListener.setSelected(c);
        this.repaint();
    }

    public BaseComponent getSelected() {
        return this.selectedComponent;
    }

    void this_componentResized(ComponentEvent e) {
        this.data.getRoot().x = this.getWidth() / 2;
        this.repaint();
    }
}

