/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.mechanics;

import com.cudos.mechanics.BaseComponent;
import com.cudos.mechanics.MechanicsComponent;
import com.cudos.mechanics.Node;
import java.io.Serializable;
import java.util.Vector;

public class MechanicsData
implements Serializable {
    Vector components = new Vector();
    Vector nodes = new Vector();
    Node root;

    public MechanicsData() {
        this.clearAll();
    }

    public void add(MechanicsComponent c) {
        this.components.add(c);
    }

    public void add(Node n) {
        this.nodes.add(n);
    }

    public void remove(BaseComponent b) {
        if (b instanceof MechanicsComponent) {
            this.remove((MechanicsComponent)b);
        } else if (b instanceof Node) {
            this.remove((Node)b);
        }
    }

    public void remove(MechanicsComponent c) {
        if (c.top.nComponents() == 1 && c.top != this.root) {
            this.nodes.remove(c.top);
        }
        if (c.bottom.nComponents() == 1 && c.bottom != this.root) {
            this.nodes.remove(c.bottom);
        }
        this.components.remove(c);
        c.top.removeComponent(c);
        c.bottom.removeComponent(c);
    }

    public void remove(Node n) {
        if (n.nComponents() > 0) {
            return;
        }
        this.nodes.remove(n);
    }

    public MechanicsComponent[] getComponents() {
        MechanicsComponent[] ca = new MechanicsComponent[]{};
        return this.components.toArray(ca);
    }

    public Node[] getNodes() {
        Node[] na = new Node[]{};
        return this.nodes.toArray(na);
    }

    public BaseComponent[] getAllComponents() {
        Vector v = new Vector(this.components);
        v.addAll(this.nodes);
        BaseComponent[] b = new BaseComponent[]{};
        b = v.toArray(b);
        return b;
    }

    public Node getRoot() {
        return this.root;
    }

    public void joinNodes(Node n1, Node n2) {
        if (n2 == this.root) {
            Node t = n1;
            n1 = n2;
            n2 = t;
        }
        Vector c = n2.getComponents();
        int i = 0;
        while (i < c.size()) {
            MechanicsComponent co = (MechanicsComponent)c.get(i);
            if (co.top == n2) {
                co.setTop(n1);
            } else if (co.bottom == n2) {
                co.setBottom(n1);
            } else {
                throw new Error("Whoops");
            }
            ++i;
        }
        this.remove(n2);
    }

    public void tick() {
        int i = 0;
        while (i < this.components.size()) {
            MechanicsComponent c = (MechanicsComponent)this.components.get(i);
            c.pull();
            ++i;
        }
        i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.get(i);
            n.move();
            ++i;
        }
    }

    public void clearAll() {
        int ox = 100;
        if (this.root != null) {
            ox = this.root.x;
        }
        this.components = new Vector();
        this.nodes = new Vector();
        this.root = new Node();
        this.add(this.root);
        this.root.y = 10.0;
        this.root.x = ox;
        this.root.fixed = true;
    }
}

