/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.mechanics;

import com.cudos.mechanics.BaseComponent;
import com.cudos.mechanics.Node;

public abstract class MechanicsComponent
extends BaseComponent {
    Node top;
    Node bottom;
    public int x;
    double tension;

    public void setTop(Node t) {
        this.x = this.bottom == null ? t.x : (this.bottom.x + t.x) / 2;
        if (this.top != null) {
            this.top.removeComponent(this);
        }
        this.top = t;
        this.top.addComponent(this);
    }

    public void setBottom(Node b) {
        this.x = this.top == null ? b.x : (this.top.x + b.x) / 2;
        if (this.bottom != null) {
            this.bottom.removeComponent(this);
        }
        this.bottom = b;
        this.bottom.addComponent(this);
    }

    public double getLength() {
        return this.bottom.y - this.top.y;
    }

    public Node getOtherNode(Node node) {
        if (this.top == node) {
            return this.bottom;
        }
        if (this.bottom == node) {
            return this.top;
        }
        return null;
    }

    public abstract double getTension();

    public void pull() {
        double t = this.getTension();
        this.top.pull(t);
        this.bottom.pull(-t);
    }

    public boolean canResizeBy(double changeLength) {
        return true;
    }
}

