/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.mechanics;

import com.cudos.mechanics.MechanicsComponent;
import com.cudos.mechanics.Node;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Dashpot
extends MechanicsComponent {
    transient JPanel panel;
    transient JSlider dslider;
    transient JLabel dlabel = new JLabel();
    int dx = 20;
    int dy = 5;
    int ddx = 2;
    int lineLen = 10;
    double maximumLength = 2.0 * this.getNaturalLength() - (double)(2 * this.dy) - (double)this.lineLen;
    double minimumLength = this.getNaturalLength() + (double)this.dy;
    double oldLen = this.naturalLength;
    double damping = 0.4;

    public Dashpot() {
        this.createPanel();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.createPanel();
    }

    void createPanel() {
        this.panel = new JPanel();
        this.dslider = new JSlider();
        this.dlabel = new JLabel("Damping");
        this.dslider.setMinimum(1);
        this.dslider.setPreferredSize(new Dimension(50, 30));
        this.dslider.setValue((int)(this.damping * 20.0));
        this.dslider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Dashpot.this.damping = (double)Dashpot.this.dslider.getValue() / 20.0;
            }
        });
        this.panel.add(this.dlabel);
        this.panel.add(this.dslider);
    }

    public boolean contains(Point p) {
        Rectangle bounds = new Rectangle(this.x - this.dx, (int)this.top.y + 4, this.dx * 2, (int)(this.bottom.y - this.top.y - 8.0));
        return bounds.contains(p);
    }

    public void paint(Graphics g) {
        int y1 = (int)this.top.y;
        int y2 = (int)this.bottom.y;
        g.drawLine(this.top.x, y1, this.x, y1);
        g.drawLine(this.x, y2, this.bottom.x, y2);
        int piston = (int)((double)y1 + this.naturalLength - (double)this.dy - (double)this.lineLen);
        g.drawLine(this.x, y1, this.x, piston);
        g.drawLine(this.x - this.dx + this.ddx, piston, this.x + this.dx - this.ddx, piston);
        int topdash = (int)((double)y2 - this.naturalLength + (double)this.dy);
        int botdash = y2 - this.lineLen;
        g.drawLine(this.x - this.dx, topdash, this.x - this.dx, botdash);
        g.drawLine(this.x - this.dx, botdash, this.x + this.dx, botdash);
        g.drawLine(this.x + this.dx, botdash, this.x + this.dx, topdash);
        g.drawLine(this.x, botdash, this.x, y2);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public double getTension() {
        double newLen = this.bottom.y - this.top.y;
        double tension = this.damping * (newLen - this.oldLen) / Node.dt;
        this.oldLen = newLen;
        if (newLen > this.maximumLength || newLen < this.minimumLength) {
            return tension + this.bottom.getImpulsiveStop(this.top);
        }
        return tension;
    }

    public boolean canResizeBy(double dl) {
        return dl < 0.0 ? this.getLength() + dl >= this.minimumLength : this.getLength() + dl <= this.maximumLength;
    }
}

