/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.genetic;

import com.cudos.common.CudosExhibit;
import com.cudos.genetic.Gene;
import com.cudos.genetic.GeneImpl;
import com.cudos.genetic.Genome;
import com.cudos.genetic.PhenoImpl;
import java.awt.Graphics;
import java.awt.Image;

public class SickleCell {
    public static final String W = "HbW";
    public static final String S = "HbS";
    public static final String[] alleles = new String[]{"HbS", "HbW"};

    public static class SickleGene
    extends GeneImpl.TextGene {
        SickleGene() {
            this.setAllele(SickleCell.W);
        }

        public String[] getPossibleAlleles() {
            return alleles;
        }
    }

    public static class SickleGenome
    extends Genome {
        public String[] getYChromosomeAlleles() {
            return null;
        }

        public Object[] getAllAlleles() {
            return new String[][]{alleles};
        }

        public SickleGenome() {
            this.loci.add(new SickleGene[]{new SickleGene(), new SickleGene()});
        }

        public double linkage(int locus) {
            return 0.0;
        }
    }

    public static class SicklePhenotype
    extends PhenoImpl {
        boolean sickler = false;
        Image s0;
        Image s1;

        public void updateGenes() {
            Gene[] g = this.genome.getGenesAtLocus(0);
            int s = g[0].getAlleleIndex() + g[1].getAlleleIndex();
            boolean bl = this.sickler = s == 0;
            this.setToolTipText(this.sickler ? "Sickler" : (s == 1 ? "Carrier" : "Normal"));
            this.repaint();
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.sickler) {
                if (this.s1 == null) {
                    this.s1 = CudosExhibit.getApplet(this).getImage("resources/images/rbc_sickle.jpg");
                }
                g.drawImage(this.s1, 0, 0, this);
            } else {
                if (this.s0 == null) {
                    this.s0 = CudosExhibit.getApplet(this).getImage("resources/images/rbc_norm.jpg");
                }
                g.drawImage(this.s0, 0, 0, this);
            }
        }

        public boolean isLethal() {
            return false;
        }

        public int compareTo(Object o) {
            boolean os = ((SicklePhenotype)o).sickler;
            if (os == this.sickler) {
                return 0;
            }
            if (os == this.sickler) {
                return 1;
            }
            return -1;
        }
    }
}

