/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.genetic;

import com.cudos.common.CudosExhibit;
import com.cudos.genetic.Genome;
import com.cudos.genetic.GenomeFromFile;
import com.cudos.genetic.HaplotypePanel;
import com.cudos.genetic.Individual;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class PunnettPanel
extends JPanel {
    static final String CROSS_CORNER = "resources/images/crosscorner.gif";
    GridLayout gridLayout1 = new GridLayout();
    JLabel topleft = new JLabel();
    BorderLayout borderlayout = new BorderLayout();
    JPanel main = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            if (PunnettPanel.this.hs1 == null || PunnettPanel.this.hs2 == null) {
                return;
            }
            g.setColor(this.getForeground());
            ((Graphics2D)g).setStroke(new BasicStroke(3.0f));
            int h = this.getHeight() / (PunnettPanel.this.hs1.haplos.length + 1) - 2;
            int v = this.getWidth() / (PunnettPanel.this.hs2.haplos.length + 1) - 2;
            g.drawLine(0, h, this.getWidth(), h);
            g.drawLine(v, 0, v, this.getHeight());
        }
    };
    Genome.HaplotypeSet hs1;
    Genome.HaplotypeSet hs2;
    Genome.ChildSet children;
    JLabel jLabel1 = new JLabel();
    Border border1;
    Border border2;
    public boolean showPhenotype = false;

    public void addNotify() {
        super.addNotify();
        this.topleft.setIcon(new ImageIcon(CudosExhibit.getApplet(this).getImage(CROSS_CORNER)));
    }

    public PunnettPanel(Individual p1, Individual p2, boolean showPhenotype) {
        this();
        HaplotypePanel htp;
        this.showPhenotype = showPhenotype;
        this.hs1 = p1.genome.getPossibleHaplotypes();
        this.hs2 = p2.genome.getPossibleHaplotypes();
        this.children = this.hs1.combine(this.hs2);
        this.gridLayout1.setRows(this.hs1.haplos.length + 1);
        this.gridLayout1.setColumns(this.hs2.haplos.length + 1);
        this.main.add(this.topleft);
        int i = 0;
        while (i < this.hs2.haplos.length) {
            htp = new HaplotypePanel(this.hs2.haplos[i]);
            this.main.add(htp);
            ++i;
        }
        i = 0;
        while (i < this.hs1.haplos.length) {
            htp = new HaplotypePanel(this.hs1.haplos[i]);
            this.main.add(htp);
            int j = 0;
            while (j < this.hs2.haplos.length) {
                GenomeFromFile g = (GenomeFromFile)this.children.genomes[i * this.hs2.haplos.length + j];
                Individual child = g.createNewBlankIndividual();
                child.genome.setFrom(g);
                child.genome.setMutable(false);
                if (showPhenotype) {
                    child.phenopanel.setVisible(false);
                }
                child.namelabel.setVisible(false);
                child.linkagedisp.setVisible(false);
                this.main.add(child);
                ++j;
            }
            ++i;
        }
    }

    public PunnettPanel(Individual i1, Individual i2) {
        this(i1, i2, false);
    }

    public PunnettPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border2 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.gridLayout1.setHgap(15);
        this.gridLayout1.setVgap(15);
        this.topleft.setToolTipText("Punnett square");
        this.topleft.setHorizontalAlignment(0);
        this.main.setLayout(this.gridLayout1);
        this.setLayout(this.borderlayout);
        this.jLabel1.setText("Maternal gametes vertically, paternal gametes horizontally");
        this.setBorder(this.border1);
        this.main.setBorder(this.border2);
        this.main.setBackground(this.getBackground().darker());
        this.add(this.main);
        this.add((Component)this.jLabel1, "South");
    }
}

