/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.genetic;

import com.cudos.genetic.Gene;
import com.cudos.genetic.GeneImpl;
import com.cudos.genetic.Genome;
import com.cudos.genetic.PhenoImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.JPanel;

public class Pea {
    static GeneralPath wrinkshape;
    static Color[] colors;
    static Shape[] shapes;
    static Object[][] allValues;
    static String[] colAlleles;
    static String[] shapeAlleles;
    static String[][] allAlleles;

    static {
        int N = 100;
        int np = 10;
        int r1 = 10;
        int r2 = 15;
        double q = 0.03;
        wrinkshape = new GeneralPath(1, N);
        wrinkshape.moveTo(r2, 0.0f);
        int i = 0;
        while (i < N) {
            int r = 2 * i / np % 2 == 0 ? r1 : r2;
            int ro = r == r1 ? r2 : r1;
            double t = (double)i * Math.PI * 2.0 / (double)N;
            double cs = Math.cos(t);
            double sn = Math.sin(t);
            wrinkshape.curveTo((float)((double)r * cs - q * sn), (float)((double)r * sn - q * cs), (float)((double)ro * cs), (float)((double)ro * sn), (float)((double)r * cs), (float)((double)r * sn));
            ++i;
        }
        wrinkshape.closePath();
        wrinkshape.transform(AffineTransform.getTranslateInstance(r2, r2));
        colors = new Color[]{Color.green, Color.yellow};
        shapes = new Shape[]{wrinkshape, new Ellipse2D.Float(0.0f, 0.0f, 30.0f, 30.0f)};
        allValues = new Object[][]{colors, shapes};
        colAlleles = new String[]{"y", "Y"};
        shapeAlleles = new String[]{"r", "R"};
        allAlleles = new String[][]{colAlleles, shapeAlleles};
    }

    public static class PeaGene
    extends GeneImpl.TextGene {
        Object value;
        Diagram diagram;

        public PeaGene() {
            this.remove(this.label);
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "Center");
            this.diagram = new Diagram();
            this.diagram.setPreferredSize(new Dimension(30, 30));
            this.add((Component)this.diagram, "West");
        }

        public PeaGene(Object o) {
            this();
            this.value = o;
            int i = 0;
            while (i < allValues.length) {
                int j = 0;
                while (j < allValues[i].length) {
                    if (allValues[i][j].equals(o)) {
                        this.setAllele(allAlleles[i][j].toString());
                    }
                    ++j;
                }
                ++i;
            }
        }

        public void setAllele(String s) {
            super.setAllele(s);
            int i = 0;
            while (i < allAlleles.length) {
                int j = 0;
                while (j < allAlleles[i].length) {
                    if (allAlleles[i][j].equals(s)) {
                        this.value = allValues[i][j];
                    }
                    ++j;
                }
                ++i;
            }
        }

        public String[] getPossibleAlleles() {
            if (this.value instanceof Color) {
                return colAlleles;
            }
            if (this.value instanceof Shape) {
                return shapeAlleles;
            }
            throw new RuntimeException("No such gene type");
        }

        class Diagram
        extends JPanel {
            Diagram() {
            }

            public void paint(Graphics g) {
                super.paint(g);
                if (PeaGene.this.value instanceof Color) {
                    g.setColor((Color)PeaGene.this.value);
                    g.fill3DRect(0, 0, this.getWidth(), this.getHeight(), true);
                } else if (PeaGene.this.value instanceof Shape) {
                    ((Graphics2D)g).fill((Shape)PeaGene.this.value);
                }
            }
        }
    }

    public static class PeaGenome
    extends Genome {
        public String[] getYChromosomeAlleles() {
            return null;
        }

        public double linkage(int locus) {
            return 0.0;
        }

        public Object[] getAllAlleles() {
            return allAlleles;
        }

        PeaGenome() {
            this.loci.add(new PeaGene[]{new PeaGene(colors[1]), new PeaGene(colors[1])});
            this.loci.add(new PeaGene[]{new PeaGene(shapes[1]), new PeaGene(shapes[1])});
        }
    }

    public static class PeaPhenotype
    extends PhenoImpl {
        AffineTransform scale = AffineTransform.getScaleInstance(3.0, 3.0);
        Shape s = shapes[0];

        public void updateGenes() {
            Gene[] colg = this.genome.getGenesAtLocus(0);
            Gene[] shg = this.genome.getGenesAtLocus(1);
            this.setForeground(colg[0].getAlleleIndex() + colg[1].getAlleleIndex() == 0 ? colors[0] : colors[1]);
            this.s = shg[0].getAlleleIndex() + shg[1].getAlleleIndex() == 0 ? shapes[0] : shapes[1];
            this.setToolTipText(String.valueOf(this.getForeground() == colors[0] ? "Green " : "Yellow ") + (this.s == shapes[0] ? "wrinkled seed" : "round seed"));
            this.s = this.scale.createTransformedShape(this.s);
        }

        public void paint(Graphics g) {
            super.paint(g);
            ((Graphics2D)g).fill(this.s);
        }

        public boolean isLethal() {
            return false;
        }

        public int compareTo(Object o) {
            int q = ((PeaPhenotype)o).s.hashCode() - this.s.hashCode();
            if (q == 0) {
                q = ((PeaPhenotype)o).getForeground().getRGB() - this.getForeground().getRGB();
            }
            return q;
        }
    }
}

