/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.genetic;

import com.cudos.genetic.Gene;
import com.cudos.genetic.GeneticDisplay;
import com.cudos.genetic.Genome;
import com.cudos.genetic.Phenotype;
import com.cudos.genetic.WrongSex;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class Individual
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel top = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton namelabel = new JButton();
    JPanel main = new JPanel();
    JPanel genopanel = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel phenopanel = new JPanel();
    JPanel bottom = new JPanel();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    GridLayout genegrid = new GridLayout();
    JPanel linkagedisp = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(this.getForeground());
            ((Graphics2D)g).setStroke(new BasicStroke(3.0f));
            int N = Individual.this.genome.getNLoci();
            int i = 1;
            while (i < N) {
                double p = Individual.this.genome.linkage(i);
                if (p > 0.0) {
                    int h = this.getHeight() / N;
                    int y1 = (int)((double)h * ((double)i - 0.4));
                    int y2 = (int)((double)h * ((double)i + 0.4));
                    int x2 = this.getWidth();
                    int x1 = x2 - 10;
                    g.drawLine(x1, y1, x2, y1);
                    g.drawLine(x1, y1, x1, y2);
                    g.drawLine(x1, y2, x2, y2);
                    g.drawString(String.valueOf(Integer.toString((int)(p * 100.0))) + "%", 0, h * i);
                }
                ++i;
            }
        }
    };
    public static int serial = 0;
    public String name = "Individual" + serial++;
    public Genome genome;
    public Phenotype phenotype;
    JPopupMenu changeMenu = new JPopupMenu("Change:");
    Action randomiseAction = new AbstractAction("Set to random genotype"){

        public void actionPerformed(ActionEvent e) {
            int i = 0;
            while (i < Individual.this.genome.getNLoci()) {
                Gene[] genes = Individual.this.genome.getGenesAtLocus(i);
                String[] a = Individual.this.genome.getPossibleAlleles(i);
                genes[0].setAllele(a[(int)(Math.random() * (double)a.length)]);
                genes[1].setAllele(a[(int)(Math.random() * (double)a.length)]);
                ++i;
            }
        }
    };
    Action testhomoAction = new AbstractAction("Set to test homozygote"){

        public void actionPerformed(ActionEvent e) {
            int i = 0;
            while (i < Individual.this.genome.getNLoci()) {
                Gene[] genes = Individual.this.genome.getGenesAtLocus(i);
                String[] a = genes[0].getPossibleAlleles();
                genes[0].setAllele(a[0]);
                genes[1].setAllele(a[0]);
                ++i;
            }
        }
    };
    Action heteroAction = new AbstractAction("Set to heterozygote"){

        public void actionPerformed(ActionEvent e) {
            int i = 0;
            while (i < Individual.this.genome.getNLoci()) {
                Gene[] genes = Individual.this.genome.getGenesAtLocus(i);
                String[] a = genes[0].getPossibleAlleles();
                genes[0].setAllele(a[Math.min(a.length - 1, 1)]);
                genes[1].setAllele(a[0]);
                ++i;
            }
        }
    };
    Action useAsMother = new AbstractAction("Use as mother"){

        public void actionPerformed(ActionEvent e) {
            GeneticDisplay p = Individual.findDisplayParent(Individual.this);
            try {
                Individual.this.changeSex(0);
                if (p != null) {
                    p.setParent(0, Individual.this);
                }
            }
            catch (WrongSex x) {
                x.printStackTrace();
            }
        }
    };
    Action useAsFather = new AbstractAction("Use as father"){

        public void actionPerformed(ActionEvent e) {
            GeneticDisplay p = Individual.findDisplayParent(Individual.this);
            try {
                Individual.this.changeSex(1);
                if (p != null) {
                    p.setParent(1, Individual.this);
                }
            }
            catch (WrongSex x) {
                x.printStackTrace();
            }
        }
    };
    BorderLayout borderLayout5 = new BorderLayout();

    public void changeSex(int s) {
        this.genome.changeSex(s);
    }

    public Individual() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    JComponent getComponent() {
        return this;
    }

    public void create(Class genomeClass, Class phenoclass) {
        try {
            Phenotype p = (Phenotype)phenoclass.newInstance();
            Genome g = (Genome)genomeClass.newInstance();
            this.create(g, p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void create(Genome g, Phenotype p) {
        this.genome = g;
        this.phenotype = p;
        this.genome.setupGeneListeners();
        this.phenotype.setGenome(this.genome);
        boolean li = false;
        int i = 1;
        while (i < this.genome.getNLoci()) {
            if (this.genome.linkage(i) > 0.0) {
                li = true;
            }
            ++i;
        }
        if (li) {
            this.linkagedisp.setPreferredSize(new Dimension(35, 0));
        }
        this.setImages();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.top.setLayout(this.borderLayout2);
        this.namelabel.setText("Individual 0");
        this.namelabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Individual.this.namelabel_actionPerformed(e);
            }
        });
        this.main.setLayout(this.borderLayout3);
        this.genopanel.setLayout(this.genegrid);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanel1.setLayout(this.borderLayout4);
        this.linkagedisp.setForeground(new Color(0, 0, 128));
        this.linkagedisp.setPreferredSize(new Dimension(1, 1));
        this.linkagedisp.setToolTipText("The genes exhibit linkage as shown, and do not segregate independently.");
        this.bottom.setLayout(this.borderLayout5);
        this.add((Component)this.top, "North");
        this.top.add((Component)this.namelabel, "Center");
        this.add((Component)this.main, "Center");
        this.main.add((Component)this.phenopanel, "Center");
        this.main.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.genopanel, "Center");
        this.jPanel1.add((Component)this.linkagedisp, "West");
        this.add((Component)this.bottom, "South");
    }

    public void setImages() {
        this.namelabel.setText(this.name);
        this.genopanel.removeAll();
        this.genegrid.setColumns(2);
        int N = this.genome.getNLoci();
        this.genegrid.setRows(N);
        int i = 0;
        while (i < N) {
            Gene[] genes = this.genome.getGenesAtLocus(i);
            this.genopanel.add(genes[0].getComponent());
            this.genopanel.add(genes[1].getComponent());
            ++i;
        }
        this.phenopanel.removeAll();
        this.phenopanel.add(this.phenotype.getComponent());
    }

    void namelabel_actionPerformed(ActionEvent e) {
        this.changeMenu.removeAll();
        this.changeMenu.add(this.testhomoAction);
        this.changeMenu.add(this.heteroAction);
        this.changeMenu.add(this.randomiseAction);
        GeneticDisplay p = Individual.findDisplayParent(this);
        if (p == null || this != p.mother && this != p.father) {
            this.changeMenu.add(this.useAsMother);
            this.changeMenu.add(this.useAsFather);
        }
        Component s = (Component)e.getSource();
        this.changeMenu.show(s, 0, s.getHeight());
    }

    static GeneticDisplay findDisplayParent(Component c) {
        while (c != null && !(c instanceof GeneticDisplay)) {
            c = c.getParent();
        }
        return (GeneticDisplay)c;
    }
}

