/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.genetic;

import com.cudos.genetic.Gene;
import com.cudos.genetic.GeneImpl;
import com.cudos.genetic.Genome;
import com.cudos.genetic.PhenoImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JLabel;

public class HairColour {
    public static final String A0 = "A0";
    public static final String A1 = "A1";
    public static final String A2 = "A2";
    public static final String B0 = "B0";
    public static final String B1 = "B1";
    public static final String B2 = "B2";
    public static final String[] typeA = new String[]{"A0", "A1", "A2"};
    public static final String[] typeB = new String[]{"B0", "B1", "B2"};
    public static final String[][] allAlleles = new String[][]{typeA, typeB};

    public static Color calculateColor(int a, int b) {
        int hr = 255;
        int hg = 255;
        int hb = 220;
        int ar = 60;
        int ag = 80;
        int ab = 90;
        int br = 0;
        int bg = 10;
        int bb = 20;
        return new Color(Math.max(0, Math.min(255, hr -= ar * a + br * b)), Math.max(0, Math.min(255, hg -= ag * a + bg * b)), Math.max(0, Math.min(255, hb -= ab * a + bb * b)));
    }

    public static class HairGene
    extends GeneImpl.TextGene {
        int type = 0;
        JLabel colour = new JLabel("");

        HairGene() {
            this.remove(this.label);
            this.colour.setPreferredSize(new Dimension(10, 10));
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "Center");
            this.add((Component)this.colour, "West");
            this.colour.setOpaque(true);
        }

        public void setAllele(String allele) {
            super.setAllele(allele);
            int a = 0;
            int b = 0;
            if (allele.equals(HairColour.A1)) {
                a = 1;
            } else if (allele.equals(HairColour.A2)) {
                a = 2;
            }
            if (allele.equals(HairColour.B1)) {
                b = 1;
            } else if (allele.equals(HairColour.B2)) {
                b = 2;
            }
            this.colour.setBackground(HairColour.calculateColor(a, b));
        }

        HairGene(int type) {
            this();
            this.type = type;
            if (type == 0) {
                this.setAllele(HairColour.A1);
            } else {
                this.setAllele(HairColour.B1);
            }
        }

        public String[] getPossibleAlleles() {
            if (this.type == 0) {
                return typeA;
            }
            return typeB;
        }
    }

    public static class HairGenome
    extends Genome {
        public String[] getYChromosomeAlleles() {
            return null;
        }

        public Object[] getAllAlleles() {
            return allAlleles;
        }

        public HairGenome() {
            this.loci.add(new HairGene[]{new HairGene(0), new HairGene(0)});
            this.loci.add(new HairGene[]{new HairGene(1), new HairGene(1)});
        }

        public double linkage(int locus) {
            return 0.0;
        }
    }

    public static class HairPhenotype
    extends PhenoImpl {
        int pigA;
        int pigB;
        Image s0;
        Image s1;

        public void updateGenes() {
            this.pigA = 0;
            this.pigB = 0;
            Gene[] g = this.genome.getGenesAtLocus(0);
            int i = 0;
            while (i < 2) {
                this.pigA += g[i].getAlleleIndex();
                ++i;
            }
            g = this.genome.getGenesAtLocus(1);
            i = 0;
            while (i < 2) {
                this.pigB += g[i].getAlleleIndex();
                ++i;
            }
            this.setToolTipText("Pigment A = " + this.pigA + ", Pigment B = " + this.pigB);
            this.repaint();
        }

        public void paint(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paint(g);
            g.setColor(HairColour.calculateColor(this.pigA, this.pigB));
            g.fillOval(0, 0, this.getWidth(), this.getHeight());
        }

        public boolean isLethal() {
            return false;
        }

        public int compareTo(Object o) {
            int oc = HairColour.calculateColor(((HairPhenotype)o).pigA, ((HairPhenotype)o).pigB).getRGB();
            int c = HairColour.calculateColor(this.pigA, this.pigB).getRGB();
            return oc - c;
        }
    }
}

