/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.genetic;

import com.cudos.common.CudosExhibit;
import com.cudos.common.CudosIndexReader;
import com.cudos.common.Filter;
import com.cudos.genetic.Gene;
import com.cudos.genetic.GeneImpl;
import com.cudos.genetic.Genome;
import com.cudos.genetic.Individual;
import com.cudos.genetic.PhenoImpl;
import java.awt.Component;
import java.awt.Image;
import java.net.URL;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class GenomeFromFile
extends Genome {
    CudosIndexReader ir;
    String section;
    public String info;
    String[] geneNames;
    Object[] allAlleles;
    double[] linkage;
    String[] YChromosomeAlleles;

    public static String[] getGenomeTypes(URL resourceURL) {
        return new CudosIndexReader(resourceURL).getSectionNames();
    }

    public static String getGenomeTypeDescription(URL resourceURL, String type) {
        return new CudosIndexReader(resourceURL).getProperty(type, "Info");
    }

    private static GenomeFromFile getGenome(CudosIndexReader ir, String section) {
        Map m = ir.getMapFromSection(section);
        return new GenomeFromFile(ir, section);
    }

    public static Individual getIndividual(CudosIndexReader ir, String section) {
        Individual i = new Individual();
        GenomeFromFile g = GenomeFromFile.getGenome(ir, section);
        i.create(g, g.new PhenotypeFromFile());
        return i;
    }

    public Individual createNewBlankIndividual() {
        return GenomeFromFile.getIndividual(this.ir, this.section);
    }

    public GenomeFromFile createNewBlankGenome() {
        return GenomeFromFile.getGenome(this.ir, this.section);
    }

    protected GenomeFromFile(CudosIndexReader ir, String section) {
        this.ir = ir;
        this.section = section;
        this.info = ir.getProperty(section, "Info");
        this.geneNames = ir.getStringList(section, "Genes");
        this.allAlleles = new Object[this.geneNames.length];
        int i = 0;
        while (i < this.geneNames.length) {
            String[] alleles;
            this.allAlleles[i] = alleles = ir.getStringList(section, this.geneNames[i]);
            ++i;
        }
        try {
            String[] link = ir.getStringList(section, "Linkage");
            this.linkage = new double[link.length];
            int i2 = 0;
            while (i2 < link.length) {
                this.linkage[i2] = Double.parseDouble(link[i2]);
                ++i2;
            }
        }
        catch (Exception e) {
            this.linkage = new double[this.geneNames.length];
        }
        i = 0;
        while (i < this.allAlleles.length) {
            this.loci.add(new GeneFromFile[]{new GeneFromFile(i), new GeneFromFile(i)});
            ++i;
        }
        try {
            this.YChromosomeAlleles = ir.getStringList(section, "Y Chromosome");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String[] getAlleleStrings(String allele) {
        try {
            return this.ir.getStringList(this.section, allele);
        }
        catch (Exception x) {
            throw new RuntimeException("Allele " + allele + " not defined in file.");
        }
    }

    String[] getPhenotypeStringsForCurrentAlleles() {
        String prop = "";
        int i = 0;
        while (i < this.loci.size()) {
            Gene[] g = this.getGenesAtLocus(i);
            int q = g[0].getAlleleIndex() < g[1].getAlleleIndex() ? 0 : 1;
            prop = String.valueOf(prop) + g[q].getAllele() + " " + g[(q + 1) % 2].getAllele() + " ";
            ++i;
        }
        String s = this.ir.getProperty(this.section, prop.trim());
        if (s != null && s.length() > 0) {
            return s.split("\\s*,\\s*");
        }
        throw new RuntimeException("The index file section " + this.section + " does not contain an entry " + "for the genotype " + prop);
    }

    public Object[] getAllAlleles() {
        return this.allAlleles;
    }

    public double linkage(int locus) {
        return this.linkage[locus];
    }

    public String[] getYChromosomeAlleles() {
        return this.YChromosomeAlleles;
    }

    public boolean isPhenotypicallyIdenticalTo(Genome g1) {
        if (this.isGeneticallyIdenticalTo(g1)) {
            return true;
        }
        PhenotypeFromFile f = new PhenotypeFromFile();
        f.setGenome(this);
        String i0 = f.imageName;
        f.setGenome(g1);
        return i0 == f.imageName || i0 != null && i0.equals(f.imageName);
    }

    public boolean isLethal() {
        PhenotypeFromFile f = new PhenotypeFromFile();
        f.setGenome(this);
        return f.isLethal();
    }

    class GeneFromFile
    extends GeneImpl.TextGene {
        JLabel pic = new JLabel();
        String[] descriptions;
        String[] imageNames;
        int locus;
        boolean canChangeSex = true;

        public int getAlleleIndex() {
            String[] aa = (String[])GenomeFromFile.this.getAllAlleles()[this.locus];
            String allele = this.getAllele();
            int i = 0;
            while (i < aa.length) {
                if (aa[i].equals(allele)) {
                    return i;
                }
                ++i;
            }
            throw new IllegalStateException("This gene has an invalid allele " + allele);
        }

        protected GeneFromFile(int locus) {
            this.locus = locus;
            String[] pa = this.getPossibleAlleles();
            this.descriptions = new String[pa.length];
            this.imageNames = new String[pa.length];
            int i = 0;
            while (i < pa.length) {
                String[] s = GenomeFromFile.this.getAlleleStrings(pa[i]);
                if (s.length > 1) {
                    this.imageNames[i] = s[0];
                    this.descriptions[i] = s[1];
                } else {
                    this.descriptions[i] = s[0];
                }
                ++i;
            }
            this.add((Component)this.pic, "West");
            this.pic.addMouseListener(this.ml);
            this.setAllele(pa[1]);
        }

        public void setAllele(String allele) {
            super.setAllele(allele);
            int i = this.getAlleleIndex();
            if (this.imageNames[i] != null && this.imageNames[i].length() > 0) {
                try {
                    this.pic.setIcon(new ImageIcon(CudosExhibit.getApplet(this).getImage(this.imageNames[i])));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.pic.setToolTipText(this.descriptions[i]);
            this.label.setToolTipText(this.descriptions[i]);
        }

        public void addNotify() {
            super.addNotify();
            String t = this.imageNames[this.getAlleleIndex()];
            if (t != null && t.length() > 0) {
                this.pic.setIcon(new ImageIcon(CudosExhibit.getApplet(this).getImage(t)));
            }
        }

        public void setCanChangeSex(boolean b) {
            this.canChangeSex = b;
        }

        public String[] getPossibleAlleles() {
            if (GenomeFromFile.this.isSexLinked() && GenomeFromFile.this.isLocusSexLinked(this.locus) && !this.canChangeSex) {
                return GenomeFromFile.this.isAlleleOnYChromosome(this.getAllele()) ? Filter.and((String[])GenomeFromFile.this.allAlleles[this.locus], GenomeFromFile.this.getYChromosomeAlleles()) : Filter.andnot((String[])GenomeFromFile.this.allAlleles[this.locus], GenomeFromFile.this.getYChromosomeAlleles());
            }
            return (String[])GenomeFromFile.this.allAlleles[this.locus];
        }
    }

    class PhenotypeFromFile
    extends PhenoImpl {
        public static final String LETHAL_IMAGE = "resources/images/lethal.jpg";
        JLabel pic = new JLabel();
        String imageName;
        boolean lethal;
        Image image;
        String description;

        protected PhenotypeFromFile() {
            this.add(this.pic);
        }

        public void updateGenes() {
            this.lethal = false;
            String[] s = ((GenomeFromFile)this.genome).getPhenotypeStringsForCurrentAlleles();
            if (s.length > 1) {
                this.imageName = s[0];
                this.description = s[1];
            } else {
                this.imageName = null;
                this.description = s[0];
                if (this.description.equalsIgnoreCase("Lethal")) {
                    this.lethal = true;
                    this.imageName = LETHAL_IMAGE;
                }
            }
            try {
                this.image = CudosExhibit.getApplet(this).getImage(this.imageName);
                this.pic.setIcon(new ImageIcon(this.image));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pic.setToolTipText(this.description);
        }

        public boolean isLethal() {
            return this.lethal;
        }

        public void addNotify() {
            super.addNotify();
            if (this.imageName != null) {
                this.image = CudosExhibit.getApplet(this).getImage(this.imageName);
                this.pic.setIcon(new ImageIcon(this.image));
            }
        }

        public int compareTo(Object o) {
            int i = ((PhenotypeFromFile)o).image.hashCode() - this.image.hashCode();
            if (i == 0) {
                i = ((PhenotypeFromFile)o).description.compareTo(this.description);
            }
            return i;
        }
    }
}

