/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.genetic;

import com.cudos.genetic.Gene;
import com.cudos.genetic.GenomeFromFile;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;

public abstract class Genome {
    protected Vector loci = new Vector();
    ActionListener mylistener = null;
    ActionListener genechanged = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (Genome.this.mylistener != null) {
                Genome.this.mylistener.actionPerformed(e);
            }
        }
    };

    protected Genome() {
    }

    public int getNLoci() {
        return this.loci.size();
    }

    public abstract Object[] getAllAlleles();

    public abstract String[] getYChromosomeAlleles();

    public boolean isSexLinked() {
        return this.getYChromosomeAlleles() != null;
    }

    public boolean isAlleleOnYChromosome(String allele) {
        if (this.isSexLinked()) {
            String[] yca = this.getYChromosomeAlleles();
            int i = 0;
            while (i < yca.length) {
                if (yca[i].equals(allele)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        throw new IllegalStateException("Can't check for Y-chromosome; this isn't a sex linked trait.");
    }

    public boolean hasYChromosome() {
        int i = 0;
        while (i < this.loci.size()) {
            Gene[] g = this.getGenesAtLocus(i);
            if (this.isAlleleOnYChromosome(g[0].getAllele()) || this.isAlleleOnYChromosome(g[1].getAllele())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setCanChangeSex(boolean b) {
        int i = 0;
        while (i < this.getNLoci()) {
            int j = 0;
            while (j < 2) {
                this.getGenesAtLocus(i)[j].setCanChangeSex(b);
                ++j;
            }
            ++i;
        }
    }

    public void changeSex(int s) {
        block8: {
            boolean y;
            block7: {
                if (!this.isSexLinked()) {
                    return;
                }
                y = this.hasYChromosome();
                if (!y || s != 0) break block7;
                int i = 0;
                while (i > this.getNLoci()) {
                    if (this.isLocusSexLinked(i)) {
                        Gene[] g = this.getGenesAtLocus(i);
                        int q = 0;
                        while (q < 2) {
                            if (this.isAlleleOnYChromosome(g[q].getAllele())) {
                                g[q].setAllele(this.getFirstNonYAlleleForLocus(i));
                            }
                            ++q;
                        }
                    }
                    ++i;
                }
                break block8;
            }
            if (y || s != 1) break block8;
            int i = 0;
            while (i < this.getNLoci()) {
                if (this.isLocusSexLinked(i)) {
                    Gene[] g = this.getGenesAtLocus(i);
                    g[1].setAllele(this.getFirstYAlleleForLocus(i));
                }
                ++i;
            }
        }
    }

    public boolean isLocusSexLinked(int loc) {
        String[] poss = (String[])this.getAllAlleles()[loc];
        int i = 0;
        while (i < poss.length) {
            if (this.isAlleleOnYChromosome(poss[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getFirstYAlleleForLocus(int loc) {
        String[] poss = (String[])this.getAllAlleles()[loc];
        int i = 0;
        while (i < poss.length) {
            if (this.isAlleleOnYChromosome(poss[i])) {
                return poss[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("Cannot find any Y-chromosome alleles at locus " + loc);
    }

    public String getFirstNonYAlleleForLocus(int loc) {
        String[] poss = (String[])this.getAllAlleles()[loc];
        int i = 0;
        while (i < poss.length) {
            if (!this.isAlleleOnYChromosome(poss[i])) {
                return poss[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("Cannot find any Non-Y-chromosome alleles at locus " + loc);
    }

    public int getLocusForAllele(String a) {
        Object[] aa = this.getAllAlleles();
        int i = 0;
        while (i < aa.length) {
            String[] pa = (String[])aa[i];
            int j = 0;
            while (j < pa.length) {
                if (pa[j].equals(a)) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        throw new IllegalArgumentException("No such allele " + a + " in this genome");
    }

    public Gene[] getGenesAtLocus(int locus) {
        return (Gene[])this.loci.get(locus);
    }

    private void setGenesAtLocus(int locus, Gene[] genes) {
        String[] poss = (String[])this.getAllAlleles()[locus];
        int nfound = 0;
        int i = 0;
        while (i < poss.length) {
            int j = 0;
            while (j < 2) {
                if (genes[j].getAllele().equals(poss[i])) {
                    ++nfound;
                }
                ++j;
            }
            ++i;
        }
        if (nfound < 2) {
            throw new IllegalArgumentException("Genes " + genes + " are of wrong type for locus " + locus);
        }
        this.loci.set(locus, genes);
    }

    public String[] getPossibleAlleles(int locus) {
        return (String[])this.getAllAlleles()[locus];
    }

    public abstract double linkage(int var1);

    public Genome duplicate() {
        try {
            Genome g = this instanceof GenomeFromFile ? ((GenomeFromFile)this).createNewBlankGenome() : (Genome)this.getClass().newInstance();
            int i = 0;
            while (i < this.loci.size()) {
                Gene[] g2 = g.getGenesAtLocus(i);
                g2[0].setAllele(this.getGenesAtLocus(i)[0].getAllele());
                g2[1].setAllele(this.getGenesAtLocus(i)[1].getAllele());
                ++i;
            }
            return g;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setFrom(Genome g) {
        if (g.loci.size() != this.loci.size()) {
            throw new IllegalArgumentException("Genome not compatible");
        }
        int i = 0;
        while (i < this.loci.size()) {
            int j = 0;
            while (j < 2) {
                this.getGenesAtLocus(i)[j].setAllele(g.getGenesAtLocus(i)[j].getAllele());
                ++j;
            }
            ++i;
        }
    }

    public void setupGeneListeners() {
        int i = 0;
        while (i < this.loci.size()) {
            Gene[] g = this.getGenesAtLocus(i);
            g[0].addActionListener(this.genechanged);
            g[1].addActionListener(this.genechanged);
            ++i;
        }
    }

    public void addActionListener(ActionListener al) {
        this.mylistener = AWTEventMulticaster.add(al, this.mylistener);
    }

    public void removeActionListener(ActionListener al) {
        this.mylistener = AWTEventMulticaster.remove(al, this.mylistener);
    }

    public HaplotypeSet getPossibleHaplotypes() {
        HaplotypeSet hs = new HaplotypeSet(this);
        return hs;
    }

    public void setMutable(boolean m) {
        int i = 0;
        while (i < this.loci.size()) {
            int j = 0;
            while (j < 2) {
                this.getGenesAtLocus(i)[j].setMutable(m);
                ++j;
            }
            ++i;
        }
    }

    public boolean isGeneticallyIdenticalTo(Genome g1) {
        if (g1.getNLoci() != this.getNLoci()) {
            return false;
        }
        int i = 0;
        while (i < this.loci.size()) {
            Gene[] gi1 = g1.getGenesAtLocus(i);
            Gene[] gi2 = this.getGenesAtLocus(i);
            if (!(gi1[0].getAllele().equals(gi2[0].getAllele()) && gi1[1].getAllele().equals(gi2[1].getAllele()) || gi1[0].getAllele().equals(gi2[1].getAllele()) && gi1[1].getAllele().equals(gi2[0].getAllele()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isPhenotypicallyIdenticalTo(Genome g1) {
        return this.isGeneticallyIdenticalTo(g1);
    }

    public boolean isLethal() {
        return false;
    }

    public static class ChildSet {
        public Genome[] genomes;
        public double[] probs;
    }

    public static class HaplotypeSet {
        public Vector[] haplos;
        public double[] probs;
        Genome genome;

        public void setGenome(Genome g) {
            this.genome = g;
            int n = 1 << this.genome.loci.size();
            this.haplos = new Vector[n];
            this.probs = new double[n];
            int i = 0;
            while (i < n) {
                this.haplos[i] = new Vector();
                double prob = 1.0;
                int laststrand = 0;
                Genome temp = this.genome.duplicate();
                int j = 0;
                while (j < this.genome.loci.size()) {
                    int strand = this.bit(j, i);
                    this.haplos[i].add(temp.getGenesAtLocus(j)[strand]);
                    if (j > 0 && strand != laststrand) {
                        prob *= 1.0 - this.genome.linkage(j);
                    }
                    laststrand = strand;
                    ++j;
                }
                this.probs[i] = prob;
                ++i;
            }
            this.collate();
        }

        public HaplotypeSet(Genome g) {
            this.setGenome(g);
        }

        public int bit(int n, int i) {
            return i >> n & 1;
        }

        public ChildSet combine(HaplotypeSet o) {
            int N = this.haplos.length * o.haplos.length;
            Genome[] poss = new Genome[N];
            double[] prob = new double[N];
            int n = 0;
            int i = 0;
            while (i < this.haplos.length) {
                int j = 0;
                while (j < o.haplos.length) {
                    Genome g = this.genome.duplicate();
                    int k = 0;
                    while (k < g.loci.size()) {
                        Gene[] gk = g.getGenesAtLocus(k);
                        gk[0].setAllele(((Gene)this.haplos[i].get(k)).getAllele());
                        gk[1].setAllele(((Gene)o.haplos[j].get(k)).getAllele());
                        ++k;
                    }
                    poss[n] = g;
                    prob[n] = this.probs[i] * o.probs[j];
                    ++n;
                    ++j;
                }
                ++i;
            }
            ChildSet cs = new ChildSet();
            cs.probs = prob;
            cs.genomes = poss;
            return cs;
        }

        public void collate() {
            Vector<Vector> hap = new Vector<Vector>();
            hap.addAll(Arrays.asList(this.haplos));
            boolean[] deleted = new boolean[this.probs.length];
            Vector gdeleted = new Vector();
            int ndeleted = 0;
            int i = 0;
            while (i < this.probs.length) {
                if (!deleted[i]) {
                    int j = i + 1;
                    while (j < this.probs.length) {
                        if (!deleted[j] && HaplotypeSet.areHaplotypesIdentical((Vector)hap.get(i), (Vector)hap.get(j))) {
                            int n = i;
                            this.probs[n] = this.probs[n] + this.probs[j];
                            this.probs[j] = 0.0;
                            deleted[j] = true;
                            gdeleted.add(hap.get(j));
                            ++ndeleted;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            double tprob = 0.0;
            double[] probabilities = new double[this.probs.length - ndeleted];
            int i2 = 0;
            while (i2 < this.probs.length) {
                if (!deleted[i2]) {
                    tprob += this.probs[i2];
                }
                ++i2;
            }
            i2 = 0;
            int j = 0;
            while (i2 < this.probs.length) {
                if (!deleted[i2]) {
                    probabilities[j++] = this.probs[i2] / tprob;
                }
                ++i2;
            }
            hap.removeAll(gdeleted);
            this.haplos = hap.toArray(new Vector[hap.size()]);
            this.probs = probabilities;
        }

        public static boolean areHaplotypesIdentical(Vector h1, Vector h2) {
            if (h1.size() != h2.size()) {
                return false;
            }
            int i = 0;
            while (i < h1.size()) {
                if (!((Gene)h1.get(i)).getAllele().equals(((Gene)h2.get(i)).getAllele())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

