/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.genetic;

import com.cudos.common.CudosIndexReader;
import com.cudos.genetic.GametesPanel;
import com.cudos.genetic.Genome;
import com.cudos.genetic.GenomeFromFile;
import com.cudos.genetic.Individual;
import com.cudos.genetic.Phenotype;
import com.cudos.genetic.PunnettPanel;
import com.cudos.genetic.WrongSex;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class GeneticDisplay
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel toppanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel motherpanel = new JPanel();
    JPanel fatherpanel = new JPanel();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel childrenprobs = new JPanel();
    GridLayout childrenprobsgrid = new GridLayout();
    JPanel middlepanel = new JPanel();
    JPanel jPanel5 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JButton jButton1 = new JButton();
    BorderLayout borderLayout5 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    BorderLayout borderLayout6 = new BorderLayout();
    JPanel motherindividualpanel = new JPanel();
    JPanel fatherindividualpanel = new JPanel();
    JButton mothergametes = new JButton();
    JButton fathergametes = new JButton();
    BorderLayout borderLayout7 = new BorderLayout();
    JPanel jPanel6 = new JPanel();
    JButton jButton4 = new JButton();
    JPanel jPanel7 = new JPanel();
    BorderLayout borderLayout8 = new BorderLayout();
    JPanel jPanel8 = new JPanel();
    JRadioButton byphenotype = new JRadioButton();
    JRadioButton bygenotype = new JRadioButton();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JPanel betweenparents = new JPanel();
    JRadioButton bycombination = new JRadioButton();
    BorderLayout borderLayout9 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    Border border1;
    BorderLayout borderLayout10 = new BorderLayout();
    JPanel jPanel9 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JRadioButton ratioradio = new JRadioButton();
    JRadioButton percentradio = new JRadioButton();
    ButtonGroup buttonGroup2 = new ButtonGroup();
    JPanel childstempanel = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(this.getForeground());
            g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
        }
    };
    JPanel marriagepanel = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            int h = this.getHeight();
            int w = this.getWidth();
            g.drawLine(0, h / 2, w, h / 2);
            g.drawLine(w / 2, h / 2, w / 2, h);
        }
    };
    JPanel childrenlines = new JPanel(){

        public void paint(Graphics g) {
            int n = GeneticDisplay.this.children.size();
            if (n == 0) {
                return;
            }
            if (!GeneticDisplay.this.childrenAreClean) {
                return;
            }
            int w = this.getWidth();
            int h = this.getHeight();
            int wc = this.getWidth() / n;
            g.drawLine(wc / 2, 0, wc * (n * 2 - 1) / 2, 0);
            int i = 0;
            while (i < n) {
                int x = (2 * i + 1) * wc / 2;
                g.drawLine(x, 0, x, h);
                ++i;
            }
        }
    };
    boolean childrenAreClean = false;
    double[] probabilities = null;
    JPanel childrenpanel = new JPanel();
    GridLayout childrengridlayout = new GridLayout();
    Vector children = new Vector();
    Individual mother = new Individual();
    Individual father = new Individual();
    Class genomeClass;
    Class phenoClass;
    CudosIndexReader ir;
    boolean showPercent = true;
    ActionListener genechangelisten = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            GeneticDisplay.this.dirtyChildren();
        }
    };
    boolean collate = true;
    boolean collatePhenos = false;
    FlowLayout flowLayout1 = new FlowLayout();
    JButton jButton2 = new JButton();
    int totalPossibleChildren = 1;

    public GeneticDisplay() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setupType(String[] params) {
        this.dirtyChildren();
        int i = 0;
        while (i < params.length) {
            int e = params[i].indexOf(61);
            String lt = params[i].substring(0, e).trim();
            String rt = params[i].substring(e + 1).trim();
            try {
                if (lt.equalsIgnoreCase("Genome")) {
                    this.genomeClass = Class.forName("com.cudos.genetic." + rt);
                }
                if (lt.equalsIgnoreCase("Phenotype")) {
                    this.phenoClass = Class.forName("com.cudos.genetic." + rt);
                }
            }
            catch (ClassNotFoundException x) {
                x.printStackTrace();
            }
            ++i;
        }
        this.mother.name = "Mother " + Individual.serial++;
        this.mother.create(this.genomeClass, this.phenoClass);
        this.mother.genome.addActionListener(this.genechangelisten);
        this.father.name = "Father " + Individual.serial++;
        this.father.create(this.genomeClass, this.phenoClass);
        this.father.genome.addActionListener(this.genechangelisten);
        this.updateImages();
    }

    public void setupType(URL resource, String section) {
        this.ir = new CudosIndexReader(resource);
        this.removeAllChildren();
        try {
            Individual[] par = new Individual[]{GenomeFromFile.getIndividual(this.ir, section), GenomeFromFile.getIndividual(this.ir, section)};
            int i = 0;
            while (i < 2) {
                par[i].changeSex(i);
                this.setParent(i, par[i]);
                ++i;
            }
        }
        catch (WrongSex x) {
            x.printStackTrace();
        }
    }

    public void setParent(int p, Individual i) throws WrongSex {
        int j = 0;
        while (j < this.children.size()) {
            if (this.children.get(j) == i) {
                this.children.remove(i);
            }
            ++j;
        }
        if (i.genome.isSexLinked() && i.genome.hasYChromosome() ^ p != 0) {
            throw new WrongSex();
        }
        if (p == 0) {
            this.mother = i;
        } else {
            this.father = i;
        }
        i.name = String.valueOf(i.name) + (p == 0 ? " (Mother)" : " (Father)");
        i.genome.addActionListener(this.genechangelisten);
        i.genome.setCanChangeSex(false);
        i.genopanel.setVisible(true);
        this.dirtyChildren();
        this.updateImages();
    }

    public void updateImages() {
        this.motherindividualpanel.removeAll();
        this.motherindividualpanel.add((Component)this.mother.getComponent(), "Center");
        this.fatherindividualpanel.removeAll();
        this.fatherindividualpanel.add((Component)this.father.getComponent(), "Center");
        this.childrenpanel.removeAll();
        this.childrenprobs.removeAll();
        this.childrengridlayout.setColumns(this.children.size());
        this.childrenprobsgrid.setColumns(this.children.size());
        int i = 0;
        while (i < this.children.size()) {
            this.childrenpanel.add(((Individual)this.children.get(i)).getComponent());
            int nm = (int)((double)this.totalPossibleChildren * this.probabilities[i]);
            String s = this.showPercent ? String.valueOf(NumberFormat.getNumberInstance().format(0.1f * (float)Math.round(1000.0 * this.probabilities[i]))) + "%" : Integer.toString(nm);
            JLabel childLabel = new JLabel(s);
            childLabel.setFont(new Font("Sans serif", 1, 16));
            childLabel.setHorizontalAlignment(0);
            this.childrenprobs.add(childLabel);
            ++i;
        }
        this.validateTree();
        this.repaint();
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder();
        this.setLayout(this.borderLayout1);
        this.toppanel.setLayout(this.borderLayout2);
        this.middlepanel.setLayout(this.borderLayout3);
        this.jButton1.setText("Breed");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneticDisplay.this.jButton1_actionPerformed(e);
            }
        });
        this.childrenpanel.setLayout(this.childrengridlayout);
        this.jPanel2.setLayout(this.borderLayout4);
        this.childrenprobs.setLayout(this.childrenprobsgrid);
        this.childrenlines.setPreferredSize(new Dimension(50, 25));
        this.motherpanel.setLayout(this.borderLayout5);
        this.jLabel1.setText("Mother");
        this.jLabel2.setText("Father");
        this.fatherpanel.setLayout(this.borderLayout6);
        this.mothergametes.setText("Gametes");
        this.mothergametes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneticDisplay.this.showgametes(e);
            }
        });
        this.fathergametes.setText("Gametes");
        this.fathergametes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneticDisplay.this.showgametes(e);
            }
        });
        this.betweenparents.setLayout(this.borderLayout7);
        this.jButton4.setText("Punnett cross");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneticDisplay.this.showcross(e);
            }
        });
        this.jPanel7.setLayout(this.borderLayout8);
        this.byphenotype.setText("By phenotype");
        this.byphenotype.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneticDisplay.this.changechildview(e);
            }
        });
        this.bygenotype.setSelected(true);
        this.bygenotype.setText("By genotype");
        this.bygenotype.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneticDisplay.this.changechildview(e);
            }
        });
        this.bycombination.setText("By combination");
        this.bycombination.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneticDisplay.this.changechildview(e);
            }
        });
        this.childrengridlayout.setHgap(8);
        this.jPanel6.setLayout(this.borderLayout9);
        this.jScrollPane1.setBorder(this.border1);
        this.jPanel5.setLayout(this.borderLayout10);
        this.jPanel9.setLayout(this.flowLayout1);
        this.flowLayout1.setHgap(5);
        this.flowLayout1.setVgap(0);
        this.childstempanel.setPreferredSize(new Dimension(25, 25));
        this.jButton2.setText("Full cross");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneticDisplay.this.showcross(e);
            }
        });
        this.ratioradio.setText("Ratios");
        this.ratioradio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneticDisplay.this.changechildview(e);
            }
        });
        this.percentradio.setSelected(true);
        this.percentradio.setText("Percentages");
        this.percentradio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneticDisplay.this.changechildview(e);
            }
        });
        this.add((Component)this.toppanel, "North");
        this.toppanel.add((Component)this.motherpanel, "West");
        this.motherpanel.add((Component)this.jLabel1, "North");
        this.motherpanel.add((Component)this.motherindividualpanel, "Center");
        this.motherpanel.add((Component)this.mothergametes, "South");
        this.toppanel.add((Component)this.fatherpanel, "East");
        this.fatherpanel.add((Component)this.jLabel2, "North");
        this.fatherpanel.add((Component)this.fatherindividualpanel, "Center");
        this.fatherpanel.add((Component)this.fathergametes, "South");
        this.toppanel.add((Component)this.betweenparents, "Center");
        this.betweenparents.add((Component)this.jPanel6, "South");
        this.jPanel6.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.jButton4, null);
        this.jPanel3.add((Component)this.jButton2, null);
        this.jPanel6.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jButton1, null);
        this.betweenparents.add((Component)this.marriagepanel, "Center");
        this.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.jScrollPane1, "Center");
        this.jPanel5.add((Component)this.childstempanel, "North");
        this.jScrollPane1.getViewport().add((Component)this.jPanel9, null);
        this.jPanel9.add((Component)this.middlepanel, null);
        this.middlepanel.add((Component)this.childrenpanel, "South");
        this.middlepanel.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.childrenlines, "Center");
        this.jPanel2.add((Component)this.childrenprobs, "South");
        this.add((Component)this.jPanel7, "South");
        this.jPanel7.add((Component)this.jPanel8, "West");
        this.jPanel8.add((Component)this.bygenotype, null);
        this.jPanel8.add((Component)this.byphenotype, null);
        this.jPanel8.add((Component)this.bycombination, null);
        this.jPanel7.add((Component)this.jPanel4, "East");
        this.jPanel4.add((Component)this.percentradio, null);
        this.jPanel4.add((Component)this.ratioradio, null);
        this.buttonGroup1.add(this.bygenotype);
        this.buttonGroup1.add(this.byphenotype);
        this.buttonGroup1.add(this.bycombination);
        this.bycombination.setVisible(false);
        this.buttonGroup2.add(this.percentradio);
        this.buttonGroup2.add(this.ratioradio);
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.doBreed();
    }

    public void removeAllChildren() {
        this.children.removeAllElements();
        this.dirtyChildren();
    }

    public void doBreed() {
        this.children.removeAllElements();
        try {
            this.children.addAll(this.createBreed());
            this.childrenAreClean = true;
            int i = 0;
            while (i < this.children.size()) {
                ((Individual)this.children.get((int)i)).genome.addActionListener(this.genechangelisten);
                ++i;
            }
            this.updateImages();
        }
        catch (IllegalStateException x) {
            this.error("You have selected incompatible parents! Please reselect which example you want to try.");
        }
    }

    void dirtyChildren() {
        this.childrenAreClean = false;
        this.childrenprobs.removeAll();
        this.validateTree();
        this.repaint();
    }

    public Vector createBreed() {
        Genome.ChildSet cs = this.mother.genome.getPossibleHaplotypes().combine(this.father.genome.getPossibleHaplotypes());
        Vector<Genome> childGenos = new Vector<Genome>(Arrays.asList(cs.genomes));
        double[] probs = cs.probs;
        this.totalPossibleChildren = probs.length;
        boolean[] deleted = new boolean[probs.length];
        Vector<Genome> gdeleted = new Vector<Genome>();
        int ndeleted = 0;
        if (this.collate) {
            int i = 0;
            while (i < probs.length) {
                if (!deleted[i]) {
                    if (this.collatePhenos && childGenos.get(i).isLethal()) {
                        probs[i] = 0.0;
                        deleted[i] = true;
                        gdeleted.add(childGenos.get(i));
                        ++ndeleted;
                    } else {
                        int j = i + 1;
                        while (j < probs.length) {
                            if (!deleted[j] && (childGenos.get(i).isGeneticallyIdenticalTo(childGenos.get(j)) || this.collatePhenos && childGenos.get(i).isPhenotypicallyIdenticalTo(childGenos.get(j)))) {
                                int n = i;
                                probs[n] = probs[n] + probs[j];
                                probs[j] = 0.0;
                                deleted[j] = true;
                                gdeleted.add(childGenos.get(j));
                                ++ndeleted;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        double tprob = 0.0;
        this.probabilities = new double[probs.length - ndeleted];
        int i = 0;
        while (i < probs.length) {
            tprob += probs[i];
            ++i;
        }
        i = 0;
        int j = 0;
        while (i < probs.length) {
            if (!deleted[i]) {
                this.probabilities[j++] = probs[i] / tprob;
            }
            ++i;
        }
        childGenos.removeAll(gdeleted);
        Vector<Individual> children = new Vector<Individual>();
        int i2 = 0;
        while (i2 < childGenos.size()) {
            Individual c = new Individual();
            if (this.mother.genome instanceof GenomeFromFile) {
                c = ((GenomeFromFile)this.mother.genome).createNewBlankIndividual();
                c.genome.setFrom(childGenos.get(i2));
            } else {
                try {
                    Phenotype p = (Phenotype)this.phenoClass.newInstance();
                    c.create(childGenos.get(i2), p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            c.name = "Child " + Individual.serial++;
            if (this.collatePhenos) {
                c.genopanel.setVisible(false);
            }
            children.add(c);
            ++i2;
        }
        return children;
    }

    public int bit(int n, int i) {
        return i >> n & 1;
    }

    void changechildview(ActionEvent e) {
        if (this.bygenotype.isSelected()) {
            this.collate = true;
            this.collatePhenos = false;
        } else if (this.byphenotype.isSelected()) {
            this.collate = true;
            this.collatePhenos = true;
        } else if (this.bycombination.isSelected()) {
            this.collate = false;
            this.collatePhenos = false;
        }
        if (this.percentradio.isSelected()) {
            this.showPercent = true;
        } else if (this.ratioradio.isSelected()) {
            this.showPercent = false;
        }
        this.doBreed();
    }

    void showgametes(ActionEvent e) {
        Individual from = null;
        JComponent src = (JComponent)e.getSource();
        if (src.equals(this.mothergametes)) {
            from = this.mother;
        } else if (src.equals(this.fathergametes)) {
            from = this.father;
        }
        final JPopupMenu p = new JPopupMenu();
        GametesPanel gp = new GametesPanel(from);
        p.add(gp);
        gp.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                p.pack();
            }
        });
        p.pack();
        p.show(src, 0, src.getHeight());
    }

    void showcross(ActionEvent e) {
        JComponent src = (JComponent)e.getSource();
        boolean showPhenotypes = src.equals(this.jButton4);
        final JPopupMenu p = new JPopupMenu();
        try {
            PunnettPanel pp = new PunnettPanel(this.mother, this.father, showPhenotypes);
            p.add(pp);
            pp.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    p.pack();
                }
            });
            p.pack();
            p.show(src, 0, src.getHeight());
        }
        catch (IllegalStateException x) {
            this.error("You have selected incompatible parents! Please reselect which example you want to try.");
        }
    }

    void error(String e) {
        JOptionPane.showMessageDialog(this, e, "An error has occurred", 0);
    }
}

