/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.genetic;

import com.cudos.genetic.Gene;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

abstract class GeneImpl
extends JPanel
implements Gene {
    private String allele = "W";
    ActionListener phenolisten = null;
    boolean mutable = true;
    MouseListener ml = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            if (!GeneImpl.this.mutable) {
                return;
            }
            String[] a = GeneImpl.this.getPossibleAlleles();
            int x = -1;
            int i = 0;
            while (i < a.length) {
                if (a[i].equals(GeneImpl.this.allele)) {
                    x = i;
                }
                ++i;
            }
            x = (x + 1) % a.length;
            GeneImpl.this.setAllele(a[x]);
        }

        public void mouseReleased(MouseEvent e) {
            if (!GeneImpl.this.mutable) {
                return;
            }
            if (e.isPopupTrigger()) {
                GeneImpl.this.popup(e);
            }
        }
    };
    JPopupMenu alleleMenu = new JPopupMenu("Alleles:");

    public GeneImpl() {
        this.addMouseListener(this.ml);
    }

    public JComponent getComponent() {
        return this;
    }

    public void setAllele(String allele) {
        this.allele = allele;
        if (this.phenolisten != null) {
            this.phenolisten.actionPerformed(new ActionEvent(this, 0, "Allele changed"));
        }
    }

    public void addActionListener(ActionListener a) {
        this.phenolisten = AWTEventMulticaster.add(a, this.phenolisten);
    }

    public void removeActionListener(ActionListener a) {
        this.phenolisten = AWTEventMulticaster.remove(a, this.phenolisten);
    }

    public String getAllele() {
        return this.allele;
    }

    public int getAlleleIndex() {
        String[] aa = this.getPossibleAlleles();
        int i = 0;
        while (i < aa.length) {
            if (aa[i].equals(this.allele)) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("This gene has an invalid allele " + this.allele);
    }

    public void setMutable(boolean m) {
        this.mutable = m;
    }

    public void popup(MouseEvent e) {
        this.alleleMenu.removeAll();
        String[] a = this.getPossibleAlleles();
        int i = 0;
        while (i < a.length) {
            this.alleleMenu.add(new AlleleAction(a[i]));
            ++i;
        }
        this.alleleMenu.show(this, e.getX(), e.getY());
    }

    public void setCanChangeSex(boolean b) {
    }

    class AlleleAction
    extends AbstractAction {
        String newallele;

        AlleleAction(String a) {
            super(a);
            this.newallele = a;
        }

        public void actionPerformed(ActionEvent e) {
            GeneImpl.this.setAllele(this.newallele);
        }
    }

    public static abstract class TextGene
    extends GeneImpl {
        public JLabel label = new JLabel(this){
            final /* synthetic */ TextGene this$1;
            {
                this.this$1 = textGene;
            }

            public void paint(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paint(g);
            }
        };

        public TextGene() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "Center");
            this.label.setOpaque(false);
            this.label.setBorder(BorderFactory.createBevelBorder(0));
            this.label.addMouseListener(this.ml);
            this.label.setCursor(Cursor.getPredefinedCursor(12));
            this.label.setHorizontalTextPosition(0);
            this.label.setFont(new Font("Serif", 1, 14));
        }

        public void setAllele(String s) {
            super.setAllele(s);
            this.label.setText(s);
            try {
                this.label.setToolTipText("Allele = '" + this.getAllele() + "' (type " + this.getAlleleIndex() + " of " + this.getPossibleAlleles().length + ")");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

