/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.function;

import com.cudos.common.FormulaGraphPanel;
import com.cudos.common.ParametricExpression;
import com.cudos.common.PolarExpression;
import evaluator.Expression;
import evaluator.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import optimization.Uncmin_f77;
import optimization.Uncmin_methods;

public class DataPanel
extends JPanel {
    JPanel buttonPanel = new JPanel();
    JButton loadButton = new JButton();
    JScrollPane scroll = new JScrollPane();
    JEditorPane editor = new JEditorPane();
    JLabel messageArea = new JLabel("Type or paste data points here");
    JButton regressButton = new JButton();
    JToggleButton drawButton = new JToggleButton();
    PopupMenu popup = new PopupMenu();
    FormulaGraphPanel graphPanel;
    Action regressAction = new AbstractAction("Fit curve"){

        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    1.access$0(this.this$1).doRegression();
                }
            }).start();
        }

        static /* synthetic */ DataPanel access$0(1 var0) {
            return var0.DataPanel.this;
        }
    };
    String[] messageString = new String[]{"Probably optimal", "Probably optimal", "Probably optimal", "Problem: No optimum found", "Problem: Function may be unbounded", ""};
    Action drawAction = new AbstractAction("Draw points"){

        public void actionPerformed(ActionEvent e) {
            if (DataPanel.this.drawButton.isSelected()) {
                DataPanel.this.graphPanel.startDrawData(DataPanel.this);
            } else {
                DataPanel.this.graphPanel.stopDrawData();
            }
        }
    };

    public DataPanel() {
        this.init();
    }

    void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "North");
        this.buttonPanel.add(this.regressButton);
        this.add((Component)this.scroll, "Center");
        this.scroll.setViewportView(this.editor);
        this.regressButton.setAction(this.regressAction);
        this.add((Component)this.messageArea, "South");
        this.buttonPanel.add(this.drawButton);
        this.messageArea.setBorder(new BevelBorder(1));
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                DataPanel.this.updateGraphData();
            }

            public void insertUpdate(DocumentEvent e) {
                DataPanel.this.updateGraphData();
            }

            public void removeUpdate(DocumentEvent e) {
                DataPanel.this.updateGraphData();
            }
        });
        this.drawButton.setAction(this.drawAction);
    }

    public void updateGraphData() {
        Vector<Point2D.Double> points = new Vector<Point2D.Double>();
        int len = this.editor.getDocument().getLength();
        if (len > 0) {
            String s;
            try {
                s = this.editor.getDocument().getText(0, len);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
                return;
            }
            boolean coordIsX = true;
            double xcoord = Double.NaN;
            double ycoord = Double.NaN;
            Throwable exception = null;
            StringBuffer b = new StringBuffer();
            int i = 0;
            while (i < len) {
                block11: {
                    boolean numericChar;
                    char c = s.charAt(i);
                    boolean bl = numericChar = Character.isDigit(c) || c == '.' || c == 'e' || c == '-' || c == '+';
                    if (numericChar) {
                        b.append(c);
                    }
                    if (!(numericChar && i != len - 1 || b.length() <= 0)) {
                        try {
                            double d = Double.parseDouble(b.toString());
                            if (coordIsX) {
                                xcoord = d;
                                coordIsX = false;
                            } else {
                                ycoord = d;
                                points.add(new Point2D.Double(xcoord, ycoord));
                                coordIsX = true;
                            }
                            b = new StringBuffer();
                        }
                        catch (NumberFormatException e) {
                            if (exception != null) break block11;
                            exception = e;
                        }
                    }
                }
                ++i;
            }
            if (exception != null) {
                this.messageArea.setText(exception.toString());
            }
        }
        this.graphPanel.setDataPoints(points);
    }

    public void setGraphPanel(FormulaGraphPanel g) {
        this.graphPanel = g;
    }

    public void doRegression() {
        this.messageArea.setText("Optimizing...");
        Vector points = this.graphPanel.getDataPoints();
        double[] x = new double[points.size()];
        double[] y = new double[points.size()];
        int i = 0;
        while (i < points.size()) {
            Point2D p = (Point2D)points.get(i);
            x[i] = p.getX();
            y[i] = p.getY();
            ++i;
        }
        OptimisationFunction f = new OptimisationFunction(this.graphPanel, Variable.getDefinedNames(), x, y);
        int N = OptimisationFunction.varNames.size();
        if (N == 0) {
            JOptionPane.showMessageDialog(this, "Your curve equation needs at least one free parameter.");
            return;
        }
        if (this.graphPanel.getExpression() instanceof PolarExpression || this.graphPanel.getExpression() instanceof ParametricExpression) {
            JOptionPane.showMessageDialog(this, "Fitting parametric or polar curves is not yet supported.");
            return;
        }
        if (x.length < 1) {
            JOptionPane.showMessageDialog(this, "You need to enter at least one data point, in the form x,y");
            return;
        }
        double[] oldParamValues = new double[N];
        double[] newParamValues = new double[N + 1];
        double[] finalParamValues = new double[N + 1];
        double[] finalMinValue = new double[2];
        double[] finalMinGradient = new double[N + 1];
        double[][] workspace1 = new double[N + 1][N + 1];
        double[] workspace2 = new double[N + 1];
        int[] terminationCode = new int[2];
        int i2 = 0;
        while (i2 < N) {
            double d = Variable.get((String)OptimisationFunction.varNames.get(i2));
            newParamValues[i2 + 1] = d;
            oldParamValues[i2] = d;
            ++i2;
        }
        Uncmin_f77.optif0_f77(OptimisationFunction.varNames.size(), newParamValues, f, finalParamValues, finalMinValue, finalMinGradient, terminationCode, workspace1, workspace2);
        i2 = 0;
        while (i2 < N) {
            Variable.set((String)OptimisationFunction.varNames.get(i2), finalParamValues[i2 + 1]);
            ++i2;
        }
        this.messageArea.setText("Optimised: " + this.messageString[terminationCode[1]]);
        this.graphPanel.repaint();
    }

    public void addDataPoint(double x, double y) {
        try {
            this.editor.getDocument().insertString(this.editor.getDocument().getLength(), "\n" + x + "," + y, null);
            this.updateGraphData();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    static class OptimisationFunction
    implements Uncmin_methods {
        static Exception exception = null;
        static Vector varNames;
        static FormulaGraphPanel graphPanel;
        static double[] x;
        static double[] y;

        OptimisationFunction(FormulaGraphPanel fgp, Vector v, double[] xs, double[] ys) {
            x = xs;
            y = ys;
            varNames = v;
            graphPanel = fgp;
        }

        public static double y(double[] pars) {
            int i = 0;
            while (i < varNames.size()) {
                Variable.set((String)varNames.get(i), pars[i + 1]);
                ++i;
            }
            Expression e = graphPanel.getExpression();
            try {
                double ersqu = 0.0;
                int i2 = 0;
                while (i2 < x.length) {
                    FormulaGraphPanel.x = x[i2];
                    double yf = Double.NaN;
                    yf = e.value();
                    double error = y[i2] - yf;
                    ersqu += error * error;
                    ++i2;
                }
                return ersqu;
            }
            catch (Exception x) {
                exception = x;
                return Double.NaN;
            }
        }

        public double f_to_minimize(double[] x) {
            return OptimisationFunction.y(x);
        }

        public void gradient(double[] x, double[] g) {
        }

        public void hessian(double[] x, double[][] h) {
        }
    }
}

