/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.waves;

import com.cudos.common.waves.RippleSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SourcePanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JRadioButton isPoint = new JRadioButton();
    JRadioButton isLine = new JRadioButton();
    JPanel jPanel2 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JSlider freqSlider = new JSlider();
    JSlider amplSlider = new JSlider();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    ButtonGroup bg = new ButtonGroup();
    RippleSource src;
    JPanel jPanel3 = new JPanel();
    GridLayout gridLayout2 = new GridLayout();

    public SourcePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bg.add(this.isPoint);
        this.bg.add(this.isLine);
    }

    public void setSource(RippleSource rs) {
        this.src = rs;
        if (this.src.getType() == 0) {
            this.isPoint.setSelected(true);
        } else {
            this.isLine.setSelected(true);
        }
        this.freqSlider.setValue((int)(this.src.getFrequency() * 400.0));
        this.amplSlider.setValue((int)(this.src.getAmplitude() * 70.0));
    }

    public RippleSource getSource() {
        return this.src;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.isPoint.setSelected(true);
        this.isPoint.setText("Point");
        this.isPoint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SourcePanel.this.isPoint_actionPerformed(e);
            }
        });
        this.isLine.setText("Line");
        this.isLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SourcePanel.this.isLine_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setRows(2);
        this.jLabel1.setText("Frequency");
        this.jLabel2.setText("Amplitude");
        this.freqSlider.setMajorTickSpacing(50);
        this.freqSlider.setPaintTicks(true);
        this.freqSlider.setMinorTickSpacing(10);
        this.freqSlider.setPaintLabels(true);
        this.freqSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SourcePanel.this.freqSlider_stateChanged(e);
            }
        });
        this.amplSlider.setMajorTickSpacing(50);
        this.amplSlider.setPaintTicks(true);
        this.amplSlider.setMinorTickSpacing(10);
        this.amplSlider.setPaintLabels(true);
        this.amplSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SourcePanel.this.amplSlider_stateChanged(e);
            }
        });
        this.jPanel3.setLayout(this.gridLayout2);
        this.gridLayout2.setRows(2);
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.isPoint, null);
        this.jPanel1.add((Component)this.isLine, null);
        this.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.amplSlider, null);
        this.jPanel2.add((Component)this.freqSlider, null);
        this.add((Component)this.jPanel3, "West");
        this.jPanel3.add((Component)this.jLabel2, null);
        this.jPanel3.add((Component)this.jLabel1, null);
    }

    void freqSlider_stateChanged(ChangeEvent e) {
        this.src.setFrequency((double)this.freqSlider.getValue() / 400.0);
    }

    void amplSlider_stateChanged(ChangeEvent e) {
        this.src.setAmplitude((double)this.amplSlider.getValue() / 70.0);
    }

    void isPoint_actionPerformed(ActionEvent e) {
        this.src.setType(0);
    }

    void isLine_actionPerformed(ActionEvent e) {
        this.src.setType(1);
    }
}

