/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.waves;

import com.cudos.common.DraggableComponent;
import com.cudos.common.waves.RippleTank;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class RippleWall
extends DraggableComponent {
    static int sid = 0;
    int id;
    Rectangle rect;
    RippleWall me = this;
    public static final int TYPE_RECTANGLE = 0;
    public static final int TYPE_PARABOLA = 1;
    public static final int TYPE_LINE = 2;
    public static final int TYPE_RECTSTEP = 3;
    int type;

    public RippleWall() {
        this(0, 0, 10, 20);
    }

    public RippleWall(int x1, int y1, int w, int h) {
        this.rect = new Rectangle(x1, y1, w, h);
        this.setLocation(x1, y1);
        this.setSize(w, h);
        this.type = 0;
        this.id = sid++;
        this.name = "Wall" + sid;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ((RippleTank)RippleWall.this.getParent()).setSelected(RippleWall.this.me);
            }
        });
    }

    public boolean wallcontains(int x, int y) {
        if (this.type == 0 || this.type == 3) {
            return this.contains(x - this.getX(), y - this.getY());
        }
        if (this.type == 1) {
            int h = this.getHeight();
            int sx = ((RippleTank)this.getParent()).sx;
            return x - this.getX() < sx + 4 * this.getWidth() * (y - h / 2) * (y - h / 2) / (h * h) && x > this.getX();
        }
        if (this.type == 2) {
            int sx = ((RippleTank)this.getParent()).sx;
            int sy = ((RippleTank)this.getParent()).sy;
            return this.contains(x - this.getX(), y - this.getY()) && ((x - this.getX()) / sx == (y - this.getY()) * this.getWidth() / this.getHeight() / sy || (y - this.getY()) / sy == (x - this.getX()) * this.getHeight() / this.getWidth() / sx);
        }
        return false;
    }

    public void paint(Graphics g_) {
        Graphics2D g = (Graphics2D)g_;
        g.setColor(new Color(0, 0, 128));
        if (this.type == 0) {
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (this.type == 1) {
            int h = this.getHeight();
            int yst = 2;
            int sx = ((RippleTank)this.getParent()).sx;
            int i = 0;
            while (i < h) {
                g.fillRect(0, i, sx + 4 * this.getWidth() * (i - h / 2) * (i - h / 2) / (h * h), yst);
                i += yst;
            }
        } else if (this.type == 2) {
            g.setStroke(new BasicStroke(3.0f));
            g.drawLine(0, 0, this.getWidth(), this.getHeight());
        } else if (this.type == 3) {
            g.setPaint(new Color(0, 0, 128, 32));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.selected) {
            g.setColor(Color.yellow);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    public void setLocation(int x, int y) {
        if (this.type == 1) {
            super.setLocation(x, 0);
        } else {
            super.setLocation(x, y);
        }
        if (this.getParent() != null) {
            ((RippleTank)this.getParent()).setupWalls();
        }
    }

    public void setSize(int w, int h) {
        if (this.type == 1) {
            RippleTank p = (RippleTank)this.getParent();
            super.setSize(w, p.dheight * p.sy);
        } else {
            super.setSize(w, h);
        }
        if (this.getParent() != null) {
            ((RippleTank)this.getParent()).setupWalls();
        }
    }

    public void setType(int t) {
        this.type = t;
    }

    public int getType() {
        return this.type;
    }
}

