/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.waves;

import com.cudos.common.DraggableComponent;
import com.cudos.common.DraggableContainer;
import com.cudos.common.SelectionRecipient;
import com.cudos.common.waves.RippleSource;
import com.cudos.common.waves.RippleWall;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Vector;

public class RippleTank
extends DraggableContainer
implements Runnable {
    int sx = 5;
    int sy = 5;
    int dwidth = 80;
    int dheight = 50;
    int command;
    static final int COMMAND_SELECT = 0;
    static final int COMMAND_CREATESOURCE = 1;
    static final int COMMAND_CREATEWALL = 2;
    int mx = 0;
    int my = 0;
    boolean stimulus = false;
    float[][] px = new float[this.dwidth][this.dheight];
    float[][] vx = new float[this.dwidth][this.dheight];
    BufferedImage bi;
    Color color1 = Color.black;
    Color color2 = Color.white;
    public DraggableComponent selected = null;
    byte[][] walltype = new byte[this.dwidth][this.dheight];
    Thread thread = new Thread(this);
    int ticks = 0;
    boolean threadpaused = false;
    public Vector sources = new Vector();
    public Vector walls = new Vector();
    int contrast = 50;

    public boolean intank(Point p) {
        return !(p.getX() > (double)(this.sx * this.dwidth)) && !(p.getY() > (double)(this.sy * this.dheight));
    }

    public RippleSource createSource(int x, int y) {
        RippleSource rs = new RippleSource(x, y);
        this.sources.add(rs);
        this.addDraggable(rs);
        return rs;
    }

    public RippleWall createWall(int x, int y, int w, int h) {
        RippleWall rw = new RippleWall(x, y, w, h);
        this.walls.add(rw);
        this.addDraggable(rw);
        this.setupWalls();
        return rw;
    }

    public void removeAll() {
        Vector owalls = (Vector)this.walls.clone();
        int i = 0;
        while (i < owalls.size()) {
            this.destroyDraggable((DraggableComponent)owalls.get(i));
            ++i;
        }
        Vector osources = (Vector)this.sources.clone();
        int i2 = 0;
        while (i2 < osources.size()) {
            this.destroyDraggable((DraggableComponent)osources.get(i2));
            ++i2;
        }
        this.setupWalls();
    }

    public void deleteSelected() {
        if (this.selected != null) {
            this.destroyDraggable(this.selected);
        }
        this.setupWalls();
    }

    public void destroyDraggable(DraggableComponent m) {
        super.destroyDraggable(m);
        if (m instanceof RippleSource) {
            this.sources.remove(m);
        } else if (m instanceof RippleWall) {
            this.walls.remove(m);
        } else {
            System.out.println("cannot remove object");
        }
        if (this.selected == m) {
            this.setSelected(null);
        }
        this.setupWalls();
    }

    public void setSelected(DraggableComponent s) {
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.selected = s;
        if (s != null) {
            s.setSelected(true);
        }
        this.getSelectionRecipient().setSelected(s);
    }

    SelectionRecipient getSelectionRecipient() {
        Container t = this;
        while (t != null && !(t instanceof SelectionRecipient)) {
            t = t.getParent();
        }
        return (SelectionRecipient)((Object)t);
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int c) {
        this.command = c;
    }

    public RippleTank() {
        this.bi = new BufferedImage(this.dwidth, this.dheight, 13, this.icm());
        int i = 0;
        while (i < this.dwidth * this.dheight) {
            this.px[i % this.dwidth][i / this.dwidth] = 0.0f;
            this.vx[i % this.dwidth][i / this.dwidth] = 0.0f;
            ++i;
        }
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                switch (RippleTank.this.getCommand()) {
                    case 0: {
                        RippleTank.this.setSelected(null);
                        break;
                    }
                    case 1: {
                        if (!RippleTank.this.intank(e.getPoint())) break;
                        RippleTank.this.createSource(e.getX(), e.getY());
                        break;
                    }
                    case 2: {
                        if (!RippleTank.this.intank(e.getPoint())) break;
                        RippleTank.this.createWall(e.getX(), e.getY(), 15, 100);
                    }
                }
            }
        });
        this.thread.start();
    }

    IndexColorModel icm() {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        Color c1 = this.color1;
        Color c2 = this.color2;
        int i = 0;
        while (i < 256) {
            r[i] = (byte)(c1.getRed() + (c2.getRed() - c1.getRed()) * i / 255);
            g[i] = (byte)(c1.getGreen() + (c2.getGreen() - c1.getGreen()) * i / 255);
            b[i] = (byte)(c1.getBlue() + (c2.getBlue() - c1.getBlue()) * i / 255);
            ++i;
        }
        return new IndexColorModel(8, 256, r, g, b);
    }

    public Color getColor1() {
        return this.color1;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor1(Color c) {
        this.color1 = c;
        this.setColors();
    }

    public void setColor2(Color c) {
        this.color2 = c;
        this.setColors();
    }

    public void setColors() {
        BufferedImage bi2 = new BufferedImage(this.dwidth, this.dheight, 13, this.icm());
        this.bi.copyData(bi2.getRaster());
        this.bi = bi2;
    }

    public void paint(Graphics g_) {
        super.paint(g_);
        Graphics2D g = (Graphics2D)g_;
        g.drawImage(this.bi, 0, 0, this.dwidth * this.sx, this.dheight * this.sy, this);
        Enumeration e = this.walls.elements();
        while (e.hasMoreElements()) {
            RippleWall rw = (RippleWall)e.nextElement();
            rw.paint(g.create(rw.getX(), rw.getY(), rw.getWidth(), rw.getHeight()));
        }
        e = this.sources.elements();
        while (e.hasMoreElements()) {
            RippleSource rs = (RippleSource)e.nextElement();
            rs.paint(g.create(rs.getX(), rs.getY(), rs.getWidth(), rs.getHeight()));
        }
        if (this.selected != null) {
            this.selected.repaint();
        }
    }

    public void setupWalls() {
        int i = 1;
        while (i < this.dwidth - 1) {
            int j = 1;
            while (j < this.dheight - 1) {
                int wall = 0;
                Enumeration e = this.walls.elements();
                while (e.hasMoreElements()) {
                    RippleWall cwall = (RippleWall)e.nextElement();
                    if (!cwall.wallcontains(i * this.sx, j * this.sy)) continue;
                    wall = cwall.getType() != 3 ? 32 : 127;
                }
                this.walltype[i][j] = wall;
                ++j;
            }
            ++i;
        }
    }

    public void tick() {
        Enumeration e = this.sources.elements();
        while (e.hasMoreElements()) {
            RippleSource rs = (RippleSource)e.nextElement();
            if (rs.getType() == 0) {
                this.px[rs.getX() / this.sx][rs.getY() / this.sy] = rs.getNextValue();
                continue;
            }
            if (rs.getType() != 1) continue;
            float value = rs.getNextValue();
            int i = 0;
            while (i < this.dheight) {
                this.px[rs.getX() / this.sx][i] = value;
                ++i;
            }
        }
        int i = 1;
        while (i < this.dwidth - 1) {
            int j = 1;
            while (j < this.dheight - 1) {
                float k = this.getForce(i, j);
                float[] fArray = this.vx[i];
                int n = j++;
                fArray[n] = (float)((double)fArray[n] + (double)k * 0.5);
            }
            ++i;
        }
        DataBuffer db = this.bi.getRaster().getDataBuffer();
        int i2 = 1;
        while (i2 < this.dwidth - 1) {
            int j = 1;
            while (j < this.dheight - 1) {
                float[] fArray = this.px[i2];
                int n = j;
                fArray[n] = fArray[n] + this.vx[i2][j];
                int c = Math.abs((int)((double)(this.px[i2][j] * (float)(this.contrast + 50)) / 100.0) + 128);
                if (c > 255) {
                    c = 255;
                } else if (c < 0) {
                    c = 0;
                }
                db.setElem(i2 + j * this.dwidth, c);
                ++j;
            }
            ++i2;
        }
        this.repaint();
    }

    float getForce(int i, int j) {
        return this.getDH(i - 1, j, i, j) + this.getDH(i + 1, j, i, j) + this.getDH(i, j - 1, i, j) + this.getDH(i, j + 1, i, j);
    }

    public float getDH(int i, int j, int i0, int j0) {
        if (i == 0 || i == this.dwidth - 1 || j == 0 || j == this.dheight - 1) {
            return -this.vx[i0][j0];
        }
        if (this.walltype[i][j] == 0) {
            return this.px[i][j] - this.px[i0][j0];
        }
        if (this.walltype[i][j] < 127) {
            return -this.px[i0][j0];
        }
        return (this.px[i][j] - this.px[i0][j0]) / 2.5f;
    }

    public void run() {
        while (true) {
            if (!this.threadpaused) {
                this.tick();
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void start() {
        this.threadpaused = false;
    }

    public void pause() {
        this.threadpaused = true;
    }

    public void clear() {
        int i = 0;
        while (i < this.dwidth) {
            int j = 0;
            while (j < this.dheight) {
                this.vx[i][j] = 0.0f;
                this.px[i][j] = 0.0f;
                ++j;
            }
            ++i;
        }
        this.repaint();
    }

    public void setContrast(int c) {
        this.contrast = c;
    }
}

