/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.waves;

import com.cudos.common.DraggableComponent;
import com.cudos.common.waves.RippleTank;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class RippleSource
extends DraggableComponent {
    static int sid = 0;
    int id;
    double frequency;
    double amplitude;
    RippleSource me = this;
    int tick = 0;
    public static final int TYPE_POINT = 0;
    public static final int TYPE_LINE = 1;
    int type;

    public void setFrequency(double f) {
        this.frequency = f;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setAmplitude(double a) {
        this.amplitude = a;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public RippleSource(int x, int y) {
        this(x, y, 0.1, 0.5);
    }

    public RippleSource(int u, int v, double f, double a) {
        this.setLocation(u - 2, v - 2);
        this.setSize(10, 10);
        this.frequency = f;
        this.amplitude = a;
        this.id = sid++;
        this.name = "Source" + sid;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ((RippleTank)RippleSource.this.getParent()).setSelected(RippleSource.this.me);
            }
        });
    }

    public RippleSource() {
        this(60, 60);
    }

    public float getNextValue() {
        return (float)(this.amplitude * 127.0 * Math.sin((double)this.tick++ * this.frequency * 2.0 * Math.PI));
    }

    public void paint(Graphics g) {
        g.setColor(new Color(128, 0, 0));
        g.fillOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (this.selected) {
            g.setColor(Color.yellow);
            g.drawOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    public void setType(int t) {
        this.type = t;
    }

    public int getType() {
        return this.type;
    }
}

