/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.systems;

import com.cudos.common.CudosApplet;
import com.cudos.common.SelectionRecipient;
import com.cudos.common.systems.DummyComponent;
import com.cudos.common.systems.Source;
import com.cudos.common.systems.SystemsComponent;
import com.cudos.common.systems.SystemsCustomComponent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Timer;

public class SystemsDiagram
extends JPanel {
    public Timer timer;
    CudosApplet applet = null;
    Vector components;
    SystemsComponent selection;
    double timestep;
    transient SelectionRecipient sr;
    String diagramName = "MainDiagram";
    SystemsComponent dummy;

    public Rectangle getRect() {
        return new Rectangle(this.getWidth(), this.getHeight());
    }

    public SystemsDiagram() {
        this.initialise();
    }

    public void postinit() {
        this.dummy.setParent(this);
        this.dummy.postinit();
        this.setParents();
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            SystemsComponent sc = (SystemsComponent)e.nextElement();
            if (sc instanceof SystemsCustomComponent) {
                ((SystemsCustomComponent)sc).postload();
            }
            sc.postinit();
        }
    }

    public void setParents() {
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            SystemsComponent sc = (SystemsComponent)e.nextElement();
            if (sc.getParent() != null) continue;
            sc.setParent(this);
        }
    }

    public void setApplet(CudosApplet a) {
        this.applet = a;
    }

    public CudosApplet getApplet() {
        return this.applet;
    }

    public void setSelectionRecipient(SelectionRecipient ssr) {
        this.sr = ssr;
    }

    public void setSelection(SystemsComponent sc) {
        if (this.selection != null) {
            this.selection.selected = false;
        }
        if (sc != null) {
            sc.selected = true;
        }
        this.selection = sc;
        if (this.sr != null) {
            this.sr.setSelected(sc);
        }
        this.repaint();
    }

    public void addComponent(SystemsComponent s) {
        this.components.add(s);
        s.setParent(this);
        s.postinit();
        this.setSelection(s);
        s.centreComponent();
    }

    public void removeComponent(SystemsComponent s) {
        if (this.selection == s) {
            this.setSelection(null);
        }
        s.disconnectAll();
        this.components.remove(s);
        this.repaint();
    }

    public void clearDiagram() {
        while (!this.components.isEmpty()) {
            this.removeComponent((SystemsComponent)this.components.get(0));
        }
    }

    public Vector getSystemComponents() {
        return this.components;
    }

    public void setSystemComponents(Vector c) {
        this.components = c;
    }

    public void paint(Graphics g) {
        super.paint(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            SystemsComponent sc = (SystemsComponent)e.nextElement();
            sc.paintSystems(g);
        }
    }

    public void untickAll() {
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            SystemsComponent sc = (SystemsComponent)e.nextElement();
            sc.ticked = false;
        }
    }

    public void tick() {
        this.untickAll();
        int i = 0;
        while (i < this.components.size()) {
            ((SystemsComponent)this.components.get(i)).tick();
            ++i;
        }
    }

    boolean allConnectedInputsTicked(SystemsComponent sc) {
        boolean allTicked = true;
        Enumeration e = sc.inputs.elements();
        while (e.hasMoreElements()) {
            SystemsComponent in = (SystemsComponent)e.nextElement();
            if (in.ticked) continue;
            allTicked = false;
        }
        return allTicked;
    }

    public void resetAllPhases() {
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            SystemsComponent sc = (SystemsComponent)e.nextElement();
            if (sc instanceof Source) {
                ((Source)sc).time = 0;
                continue;
            }
            if (!(sc instanceof SystemsCustomComponent)) continue;
            ((SystemsCustomComponent)sc).csd.resetAllPhases();
        }
    }

    public void initialise() {
        this.components = new Vector();
        this.selection = null;
        this.timestep = 0.05;
        this.setBackground(new Color(192, 222, 192));
        this.dummy = new DummyComponent();
        DiagramMouseAdapter dma = new DiagramMouseAdapter();
        this.addMouseListener(dma);
        this.addMouseMotionListener(dma);
        this.timer = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SystemsDiagram.this.tick();
            }
        });
    }

    public void initialiseComponents() {
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            SystemsComponent sc = (SystemsComponent)e.nextElement();
            sc.initialise();
        }
    }

    public String getDiagramName() {
        return this.diagramName;
    }

    public void setDiagramName(String s) {
        this.diagramName = s;
    }

    class DiagramMouseAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        int inode;
        int dragging;
        Point prel;
        static final int DRAG_COMPONENT = 1;
        static final int DRAG_OUTPUT = 2;
        static final int DRAG_INPUT = 3;
        static final int DRAG_NONE = 4;
        SystemsComponent previous;

        DiagramMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            this.dragging = 4;
            SystemsComponent newSelection = null;
            int i = SystemsDiagram.this.components.size() - 1;
            while (i >= 0) {
                SystemsComponent sc;
                newSelection = sc = (SystemsComponent)SystemsDiagram.this.components.get(i);
                if (sc.getRect().contains(e.getPoint())) {
                    this.dragging = 1;
                    this.prel = new Point(e.getX() - sc.pos.x, e.getY() - sc.pos.y);
                    break;
                }
                if (sc.hitOutputNode(e.getPoint())) {
                    this.dragging = 2;
                    break;
                }
                this.inode = sc.hitInputNode(e.getPoint());
                if (this.inode != -1) {
                    this.dragging = 3;
                    this.previous = this.inode < sc.inputs.size() ? (SystemsComponent)sc.inputs.get(this.inode) : null;
                    SystemsDiagram.this.dummy.moveComponent(e.getPoint());
                    this.inode = sc.setInput(this.inode, SystemsDiagram.this.dummy);
                    break;
                }
                --i;
            }
            if (this.dragging == 4) {
                newSelection = null;
            }
            SystemsDiagram.this.setSelection(newSelection);
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragging == 1) {
                SystemsDiagram.this.selection.moveComponent(new Point(e.getX() - this.prel.x, e.getY() - this.prel.y));
            } else if (this.dragging == 3) {
                boolean foundtarget = false;
                Enumeration f = SystemsDiagram.this.components.elements();
                while (f.hasMoreElements()) {
                    SystemsComponent sc = (SystemsComponent)f.nextElement();
                    if (!sc.hitOutputNode(e.getPoint()) && !sc.getRect().contains(e.getPoint())) continue;
                    SystemsDiagram.this.selection.setInput(this.inode, sc);
                    foundtarget = true;
                }
                if (!foundtarget) {
                    SystemsDiagram.this.selection.setInput(this.inode, null);
                }
            }
            this.dragging = 4;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.dragging == 1) {
                SystemsDiagram.this.selection.moveComponent(new Point(e.getX() - this.prel.x, e.getY() - this.prel.y));
            } else if (this.dragging == 3) {
                SystemsDiagram.this.dummy.moveComponent(e.getPoint());
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

