/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.systems;

import com.cudos.common.systems.Input;
import com.cudos.common.systems.Output;
import com.cudos.common.systems.SystemsComponent;
import com.cudos.common.systems.SystemsDiagram;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;

public class SystemsCustomComponent
extends SystemsComponent {
    transient SystemsDiagram csd;
    Vector inputs;
    SystemsComponent output;
    String type = "Custom";

    public void setType(String s) {
        this.type = s;
        this.getPane().type.setText(this.type);
        this.sname = String.valueOf(this.getType()) + serial++;
        this.getPane().name.setText(this.sname);
    }

    public String getType() {
        return this.type;
    }

    public String getImageFileName() {
        return "resources/icons/systems/CustomComponent.jpg";
    }

    public double getOutput() {
        return this.currentValue;
    }

    public int getNInputs() {
        return this.inputs.size();
    }

    public SystemsDiagram getDiagram() {
        return this.csd;
    }

    public boolean setDiagram(SystemsDiagram d) {
        int inps = 0;
        int oups = 0;
        Vector<SystemsComponent> inplist = new Vector<SystemsComponent>();
        SystemsComponent out = null;
        Enumeration e = d.components.elements();
        while (e.hasMoreElements()) {
            SystemsComponent sc = (SystemsComponent)e.nextElement();
            if (sc instanceof Output) {
                ++oups;
                out = sc;
            }
            if (!(sc instanceof Input)) continue;
            ++inps;
            inplist.add(sc);
        }
        if (oups != 1) {
            JOptionPane.showMessageDialog(this.sd, "This file does not have one output", "Error creating custom component", 0);
            return false;
        }
        this.csd = d;
        this.inputs = inplist;
        this.output = out;
        this.csd.setParents();
        return true;
    }

    public void postload() {
        this.csd.setApplet(this.getApplet());
        this.csd.postinit();
        this.csd.initialiseComponents();
    }

    public void tick() {
        int i = 0;
        while (i < this.inputs.size()) {
            Input sc = (Input)this.inputs.get(i);
            sc.setValue(this.getInput(i));
            ++i;
        }
        this.csd.tick();
        this.currentValue = this.output.getOutput();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Vector c = (Vector)stream.readObject();
        SystemsDiagram s = new SystemsDiagram();
        s.setSystemComponents(c);
        this.setDiagram(s);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.csd.getSystemComponents());
    }
}

