/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.systems;

import com.cudos.common.CudosApplet;
import com.cudos.common.systems.SystemsDiagram;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SystemsComponent
implements ImageObserver,
Serializable {
    String sname = "Component1";
    Vector inputs = new Vector();
    Vector outputs = new Vector();
    transient SystemsDiagram sd;
    Point pos = new Point();
    transient Image image;
    Rectangle bounds;
    public boolean selected;
    double currentValue;
    boolean ticked = false;
    static int serial = 1;
    static final int tRad = 4;
    transient Container compsd;
    protected transient SystemsComponentPane pane;

    public int getNInputs() {
        return 0;
    }

    public double getOutput() {
        return 0.0;
    }

    public void tick() {
    }

    public String getImageFileName() {
        return null;
    }

    public String getType() {
        return "Component";
    }

    public boolean isConnected() {
        return this.getNInputs() == this.inputs.size();
    }

    public void setParent(SystemsDiagram s) {
        this.sd = s;
    }

    public SystemsDiagram getParent() {
        return this.sd;
    }

    public void centreComponent() {
        this.moveComponent(new Point((this.getParent().getWidth() + this.image.getWidth(this)) / 2, (this.getParent().getHeight() + this.image.getHeight(this)) / 2));
    }

    public void moveComponent(Point p) {
        Point br = new Point(p.x + this.image.getWidth(this), p.y + this.image.getHeight(this));
        if (!this.getParent().getRect().contains(p) || !this.getParent().getRect().contains(br)) {
            return;
        }
        if (!this.bounds.contains(p) || !this.bounds.contains(br)) {
            return;
        }
        this.pos = p;
        this.repaint();
    }

    public void setLocation(int x, int y) {
        this.moveComponent(new Point(x, y));
    }

    public double getInput(int i) {
        if (i < this.inputs.size()) {
            return ((SystemsComponent)this.inputs.get(i)).getOutput();
        }
        return 0.0;
    }

    public Rectangle getRect() {
        return new Rectangle(this.pos.x, this.pos.y, this.image.getWidth(this), this.image.getHeight(this));
    }

    Point getInputNodeCentre(int i) {
        if (i > this.getNInputs()) {
            return null;
        }
        int dh = this.image.getHeight(this) / (this.getNInputs() + 1);
        return new Point(this.pos.x - 4, this.pos.y + dh * (i + 1));
    }

    Point getOutputNodeCentre() {
        return new Point(this.pos.x + this.image.getWidth(this) + 4, this.pos.y + this.image.getHeight(this) / 2);
    }

    public int hitInputNode(Point p) {
        int i = 0;
        while (i < this.getNInputs()) {
            if (p.distance(this.getInputNodeCentre(i)) < 4.0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hitOutputNode(Point p) {
        return p.distance(this.getOutputNodeCentre()) < 4.0;
    }

    public void paintSystems(Graphics g_) {
        Graphics2D g = (Graphics2D)g_;
        if (this.image != null) {
            g.drawImage(this.image, this.pos.x, this.pos.y, this);
        }
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(3.0f));
        int i = 0;
        while (i < this.getNInputs()) {
            Point pt = this.getInputNodeCentre(i);
            g.fillOval(pt.x - 4, pt.y - 4, 8, 8);
            if (i < this.inputs.size()) {
                SystemsComponent sc = (SystemsComponent)this.inputs.get(i);
                Point p1 = sc.getOutputNodeCentre();
                Point p2 = this.getInputNodeCentre(i);
                GeneralPath gp = new GeneralPath();
                gp.moveTo(p1.x, p1.y);
                if (p1.x > p2.x) {
                    int connectorExtension = 15 + 5 * i;
                    gp.lineTo(p1.x + connectorExtension, p1.y);
                    gp.lineTo(p1.x + connectorExtension, p1.y / 10);
                    gp.lineTo(p2.x - connectorExtension, p1.y / 10);
                    gp.lineTo(p2.x - connectorExtension, p2.y);
                    gp.lineTo(p2.x, p2.y);
                } else {
                    gp.lineTo(p2.x, p2.y);
                }
                g.draw(gp);
            }
            ++i;
        }
        Point pt = this.getOutputNodeCentre();
        g.fillOval(pt.x - 4, pt.y - 4, 8, 8);
        if (this.selected) {
            g.setColor(Color.red);
            g.drawRect(this.pos.x, this.pos.y, this.image.getWidth(this), this.image.getHeight(this));
        }
        g.setFont(this.getParent().getFont());
        int tw = this.getApplet().getTextWidth(g, this.sname);
        int th = this.getApplet().getTextHeight(g, this.sname);
        g.drawString(this.sname, this.pos.x + (this.image.getWidth(this) - tw) / 2, this.pos.y + this.image.getHeight(this) + th);
    }

    public boolean imageUpdate(Image i, int flags, int x, int y, int w, int h) {
        if ((flags & 0x20) > 0) {
            this.repaint();
            return false;
        }
        return true;
    }

    public int setInput(int i, SystemsComponent sc) {
        if (i >= this.getNInputs()) {
            System.out.println("Cannot add input " + i + " to " + sc);
        }
        if (i < this.inputs.size()) {
            SystemsComponent prev = (SystemsComponent)this.inputs.get(i);
            prev.outputs.remove(this);
            if (sc != null) {
                this.inputs.set(i, sc);
            } else {
                this.inputs.remove(prev);
            }
        } else if (sc != null) {
            this.inputs.add(sc);
            i = this.inputs.size() - 1;
        }
        if (sc != null) {
            sc.outputs.add(this);
        }
        this.repaint();
        return i;
    }

    public void disconnectAll() {
        SystemsComponent sc;
        Enumeration e = this.inputs.elements();
        while (e.hasMoreElements()) {
            sc = (SystemsComponent)e.nextElement();
            sc.outputs.remove(this);
        }
        e = this.outputs.elements();
        while (e.hasMoreElements()) {
            sc = (SystemsComponent)e.nextElement();
            sc.inputs.remove(this);
        }
        this.inputs.removeAllElements();
        this.outputs.removeAllElements();
        this.repaint();
    }

    public String getName() {
        return this.sname;
    }

    public void setName(String s) {
        this.sname = s;
        this.getPane().name.setText(s);
    }

    public void createPane() {
        this.pane = new SystemsComponentPane();
    }

    public SystemsComponentPane getPane() {
        return this.pane;
    }

    public void initialise() {
        this.selected = false;
        this.currentValue = 0.0;
        this.ticked = false;
        this.createPane();
    }

    public void postinit() {
        this.bounds = this.getParent().getRect();
        this.setImage();
    }

    public SystemsComponent() {
        this.initialise();
        this.getPane().type.setText(this.getType());
        this.sname = String.valueOf(this.getType()) + serial++;
        this.getPane().name.setText(this.sname);
    }

    public void setImage() {
        String f = this.getImageFileName();
        if (f != null) {
            this.image = this.getApplet().getImage(f);
        }
    }

    public void repaint() {
        this.getParent().repaint();
    }

    protected CudosApplet getApplet() {
        return this.getParent().getApplet();
    }

    public class SystemsComponentPane
    extends JPanel {
        JLabel jLabel1 = new JLabel();
        JLabel type = new JLabel();
        Border border1;
        JLabel jLabel3 = new JLabel();
        JTextField name = new JTextField();
        Border border2;

        public SystemsComponentPane() {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.border1 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(134, 134, 134), new Color(93, 93, 93));
            this.border2 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
            this.jLabel1.setPreferredSize(new Dimension(40, 17));
            this.jLabel1.setText("Type");
            this.type.setBorder(this.border1);
            this.type.setPreferredSize(new Dimension(80, 21));
            this.jLabel3.setPreferredSize(new Dimension(40, 17));
            this.jLabel3.setText("Name");
            this.name.setPreferredSize(new Dimension(80, 21));
            this.name.setText(SystemsComponent.this.sname);
            this.type.setText(SystemsComponent.this.getType());
            this.name.getDocument().addDocumentListener(new DocumentListener(this){
                final /* synthetic */ SystemsComponentPane this$1;
                {
                    this.this$1 = systemsComponentPane;
                }

                public void changedUpdate(DocumentEvent e) {
                    this.namechange();
                }

                public void insertUpdate(DocumentEvent e) {
                    this.namechange();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.namechange();
                }

                void namechange() {
                    SystemsComponentPane.access$0((SystemsComponentPane)this.this$1).sname = this.this$1.name.getText();
                }
            });
            this.setBorder(this.border2);
            this.setPreferredSize(new Dimension(140, 60));
            this.add((Component)this.jLabel1, null);
            this.add((Component)this.type, null);
            this.add((Component)this.jLabel3, null);
            this.add((Component)this.name, null);
        }

        static /* synthetic */ SystemsComponent access$0(SystemsComponentPane systemsComponentPane) {
            return systemsComponentPane.SystemsComponent.this;
        }
    }
}

