/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.systems;

import com.cudos.common.systems.SystemsComponent;
import evaluator.MathExtra;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Source
extends SystemsComponent {
    int time = 0;
    double amplitude = 2.0;
    double frequency = 0.2;
    int selection = 0;
    public static final int TYPE_CONSTANT = 0;
    public static final int TYPE_SINUSOIDAL = 1;
    public static final int TYPE_SQUARE = 2;
    public static final int TYPE_SAWTOOTH = 3;
    public static final int TYPE_COMB = 4;
    public static final int TYPE_RAMP = 5;
    public static final int TYPE_TRUNCATED = 6;

    public int getNInputs() {
        return 0;
    }

    public String getImageFileName() {
        return "resources/icons/systems/Source.jpg";
    }

    public String getType() {
        return "Source";
    }

    public double getOutput() {
        return this.currentValue;
    }

    public void tick() {
        ++this.time;
        double p = (double)this.time * this.frequency * this.sd.timestep;
        double q = p - Math.floor(p);
        switch (this.selection) {
            case 0: {
                this.currentValue = this.amplitude;
                break;
            }
            case 1: {
                this.currentValue = this.amplitude * Math.sin((double)this.time * this.frequency * 2.0 * Math.PI * this.sd.timestep);
                break;
            }
            case 2: {
                this.currentValue = this.amplitude * (double)(q < 0.5 ? 1 : -1);
                break;
            }
            case 3: {
                this.currentValue = this.amplitude * (2.0 * q - 1.0);
                break;
            }
            case 4: {
                this.currentValue = (double)this.time % (1.0 / (this.frequency * this.sd.timestep)) <= 1.0 ? this.amplitude : 0.0;
                break;
            }
            case 5: {
                this.currentValue = 4.0 * this.amplitude * (q < 0.5 ? q - 0.25 : 0.75 - q);
                break;
            }
            case 6: {
                this.currentValue = this.amplitude * (MathExtra.truncatedRamp(2.0 * q) * 2.0 - 1.0);
                break;
            }
            default: {
                this.currentValue = 0.0;
            }
        }
    }

    public Source() {
        SourcePane sp = (SourcePane)this.pane;
        sp.setSelection();
        sp.setAmplitude();
        sp.setFrequency();
    }

    public void createPane() {
        double f = this.frequency;
        double a = this.amplitude;
        SourcePane sp = new SourcePane();
        this.pane = sp;
        sp.setSelection();
        this.amplitude = a;
        sp.setAmplitude();
        this.frequency = f;
        sp.setFrequency();
    }

    public int getSelection() {
        return this.selection;
    }

    public void setSelection(int selection) {
        this.selection = selection;
        ((SourcePane)this.pane).setSelection();
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double amplitude) {
        this.amplitude = amplitude;
        ((SourcePane)this.pane).setAmplitude();
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
        ((SourcePane)this.pane).setFrequency();
    }

    public class SourcePane
    extends SystemsComponent.SystemsComponentPane
    implements ActionListener {
        JPanel jPanel1 = new JPanel();
        JRadioButton sinusoidal = new JRadioButton();
        JRadioButton square = new JRadioButton();
        JRadioButton sawtooth = new JRadioButton();
        JRadioButton constant = new JRadioButton();
        GridLayout gridLayout1 = new GridLayout();
        JRadioButton ramp = new JRadioButton();
        JRadioButton trunc = new JRadioButton();
        JRadioButton comb = new JRadioButton();
        ButtonGroup bg = new ButtonGroup();
        JLabel jLabel1 = new JLabel();
        JSlider amplSlider = new JSlider();
        JLabel jLabel2 = new JLabel();
        JSlider freqSlider = new JSlider();
        JTextField amplText = new JTextField();
        JTextField freqText = new JTextField();
        Border border1;
        Border border2;

        public SourcePane() {
            super(Source.this);
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.border1 = BorderFactory.createLineBorder(SystemColor.control, 1);
            this.border2 = BorderFactory.createLineBorder(SystemColor.control, 1);
            this.sinusoidal.setPreferredSize(new Dimension(84, 23));
            this.sinusoidal.setText("Sine");
            this.sinusoidal.addActionListener(this);
            this.square.setPreferredSize(new Dimension(65, 23));
            this.square.setText("Square");
            this.square.addActionListener(this);
            this.sawtooth.setPreferredSize(new Dimension(76, 23));
            this.sawtooth.setText("Saw");
            this.sawtooth.addActionListener(this);
            this.jPanel1.setPreferredSize(new Dimension(140, 93));
            this.jPanel1.setLayout(this.gridLayout1);
            this.constant.setToolTipText("");
            this.constant.setPreferredSize(new Dimension(75, 23));
            this.constant.setText("Const");
            this.constant.addActionListener(this);
            this.jLabel1.setText("Amplitude");
            this.amplSlider.setMaximum(200);
            this.amplSlider.setMajorTickSpacing(100);
            this.amplSlider.setPaintTicks(true);
            this.amplSlider.setMinorTickSpacing(20);
            this.amplSlider.setPreferredSize(new Dimension(140, 27));
            this.amplSlider.setBorder(this.border1);
            this.amplSlider.addChangeListener(new ChangeListener(this){
                final /* synthetic */ SourcePane this$1;
                {
                    this.this$1 = sourcePane;
                }

                public void stateChanged(ChangeEvent e) {
                    this.this$1.amplSlider_stateChanged(e);
                }
            });
            this.jLabel2.setText("Frequency");
            this.freqSlider.setMajorTickSpacing(20);
            this.freqSlider.setPaintTicks(true);
            this.freqSlider.setPreferredSize(new Dimension(150, 27));
            this.freqSlider.setBorder(this.border2);
            this.freqSlider.addChangeListener(new ChangeListener(this){
                final /* synthetic */ SourcePane this$1;
                {
                    this.this$1 = sourcePane;
                }

                public void stateChanged(ChangeEvent e) {
                    this.this$1.freqSlider_stateChanged(e);
                }
            });
            this.freqSlider.setMaximum(200);
            this.amplText.setPreferredSize(new Dimension(60, 21));
            this.freqText.setPreferredSize(new Dimension(60, 21));
            this.setPreferredSize(new Dimension(150, 275));
            this.gridLayout1.setColumns(2);
            this.gridLayout1.setRows(4);
            this.ramp.setText("Ramp");
            this.ramp.addActionListener(this);
            this.trunc.setText("Truncate");
            this.trunc.addActionListener(this);
            this.comb.setActionCommand("jRadioButton1");
            this.comb.setText("Comb");
            this.comb.addActionListener(this);
            this.add((Component)this.jPanel1, null);
            this.jPanel1.add((Component)this.constant, null);
            this.jPanel1.add((Component)this.ramp, null);
            this.jPanel1.add((Component)this.sawtooth, null);
            this.jPanel1.add((Component)this.square, null);
            this.jPanel1.add((Component)this.sinusoidal, null);
            this.add((Component)this.jLabel1, null);
            this.add((Component)this.amplText, null);
            this.add((Component)this.amplSlider, null);
            this.add((Component)this.jLabel2, null);
            this.add((Component)this.freqText, null);
            this.add((Component)this.freqSlider, null);
            this.bg.add(this.constant);
            this.bg.add(this.sinusoidal);
            this.bg.add(this.sawtooth);
            this.bg.add(this.square);
            this.bg.add(this.ramp);
            this.bg.add(this.trunc);
            this.bg.add(this.comb);
            this.jPanel1.add((Component)this.trunc, null);
            this.jPanel1.add((Component)this.comb, null);
        }

        void amplSlider_stateChanged(ChangeEvent e) {
            Source.this.amplitude = (double)(this.amplSlider.getValue() - 100) / 10.0;
            this.amplText.setText(String.valueOf(Source.this.amplitude));
        }

        public void setAmplitude() {
            this.amplSlider.setValue((int)(Source.this.amplitude * 10.0 + 100.0));
        }

        void freqSlider_stateChanged(ChangeEvent e) {
            double prevp = (double)Source.this.time * Source.this.frequency;
            Source.this.frequency = (double)this.freqSlider.getValue() / 100.0;
            this.freqText.setText(String.valueOf(Source.this.frequency));
            Source.this.time = (int)(prevp / Source.this.frequency);
        }

        public void setFrequency() {
            this.freqSlider.setValue((int)(Source.this.frequency * 100.0));
        }

        public void actionPerformed(ActionEvent e) {
            if (this.constant.isSelected()) {
                this.freqSlider.setEnabled(false);
            } else {
                this.freqSlider.setEnabled(true);
            }
            if (this.constant.isSelected()) {
                Source.this.selection = 0;
            } else if (this.sinusoidal.isSelected()) {
                Source.this.selection = 1;
            } else if (this.square.isSelected()) {
                Source.this.selection = 2;
            } else if (this.sawtooth.isSelected()) {
                Source.this.selection = 3;
            } else if (this.comb.isSelected()) {
                Source.this.selection = 4;
            } else if (this.ramp.isSelected()) {
                Source.this.selection = 5;
            } else if (this.trunc.isSelected()) {
                Source.this.selection = 6;
            }
        }

        public void setSelection() {
            switch (Source.this.selection) {
                case 0: {
                    this.constant.setSelected(true);
                    break;
                }
                case 1: {
                    this.sinusoidal.setSelected(true);
                    break;
                }
                case 2: {
                    this.square.setSelected(true);
                    break;
                }
                case 3: {
                    this.sawtooth.setSelected(true);
                    break;
                }
                case 4: {
                    this.comb.setSelected(true);
                    break;
                }
                case 5: {
                    this.ramp.setSelected(true);
                    break;
                }
                case 6: {
                    this.trunc.setSelected(true);
                }
            }
        }
    }
}

