/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.systems;

import com.cudos.common.systems.SystemsComponent;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LowPassFilter
extends SystemsComponent {
    double q = 0.0;
    double f = 0.5;

    public int getNInputs() {
        return 1;
    }

    public String getImageFileName() {
        return "resources/icons/systems/LowPass.gif";
    }

    public String getType() {
        return "LowPass";
    }

    public double getOutput() {
        return this.currentValue;
    }

    public void tick() {
        if (this.getNInputs() == 0) {
            this.currentValue = 0.0;
            return;
        }
        this.currentValue = this.q = (1.0 - this.f) * this.q + this.f * this.getInput(0);
    }

    public void createPane() {
        this.pane = new LowPassSourcePane();
        this.pane.setPreferredSize(new Dimension(100, 100));
    }

    class LowPassSourcePane
    extends SystemsComponent.SystemsComponentPane
    implements ChangeListener {
        JSlider slider = new JSlider(1, 100, 50);
        JLabel label = new JLabel("0.5");

        public LowPassSourcePane() {
            super(LowPassFilter.this);
            this.add(this.slider);
            this.add(this.label);
            this.slider.addChangeListener(this);
            this.slider.setPreferredSize(new Dimension(90, this.slider.getPreferredSize().height));
        }

        public void stateChanged(ChangeEvent e) {
            LowPassFilter.this.f = (double)this.slider.getValue() / 100.0;
            this.label.setText(String.valueOf(LowPassFilter.this.f));
        }
    }
}

