/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.systems;

import com.cudos.common.systems.SystemsComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class Integrator
extends SystemsComponent {
    double integral;

    public String getType() {
        return "Integral";
    }

    public String getImageFileName() {
        return "resources/icons/systems/Integral.jpg";
    }

    public int getNInputs() {
        return 1;
    }

    public double getOutput() {
        return this.currentValue;
    }

    public void tick() {
        this.integral += this.getInput(0) * this.sd.timestep;
        this.currentValue = this.integral = this.limit(this.integral, -100.0, 100.0);
    }

    public double limit(double a, double min, double max) {
        if (a < min) {
            return min;
        }
        if (a > max) {
            return max;
        }
        return a;
    }

    public void createPane() {
        this.pane = new IntegratorPane();
    }

    class IntegratorPane
    extends SystemsComponent.SystemsComponentPane {
        JButton reset = new JButton();

        public IntegratorPane() {
            super(Integrator.this);
            this.jbInit();
        }

        private void jbInit() {
            this.reset.setText("Reset");
            this.reset.addActionListener(new ActionListener(this){
                final /* synthetic */ IntegratorPane this$1;
                {
                    this.this$1 = integratorPane;
                }

                public void actionPerformed(ActionEvent e) {
                    IntegratorPane.access$0((IntegratorPane)this.this$1).integral = 0.0;
                }
            });
            this.setPreferredSize(new Dimension(140, 90));
            this.add((Component)this.reset, null);
        }

        static /* synthetic */ Integrator access$0(IntegratorPane integratorPane) {
            return integratorPane.Integrator.this;
        }
    }
}

