/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.systems;

import com.cudos.common.systems.SystemsComponent;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HighPassFilter
extends SystemsComponent {
    double q = 0.0;
    double oi = 0.0;
    double f = 0.5;

    public int getNInputs() {
        return 1;
    }

    public String getImageFileName() {
        return "resources/icons/systems/HighPass.gif";
    }

    public String getType() {
        return "HighPass";
    }

    public double getOutput() {
        return this.currentValue;
    }

    public void tick() {
        if (this.getNInputs() == 0) {
            this.currentValue = 0.0;
            return;
        }
        double i = this.getInput(0);
        this.currentValue = this.q = this.f * (i - this.oi) + (1.0 - this.f) * this.q;
        this.oi = i;
    }

    public void createPane() {
        this.pane = new HighPassSourcePane();
        this.pane.setPreferredSize(new Dimension(100, 100));
    }

    class HighPassSourcePane
    extends SystemsComponent.SystemsComponentPane
    implements ChangeListener {
        JSlider slider = new JSlider(1, 100, 50);
        JLabel label = new JLabel("0.5");

        public HighPassSourcePane() {
            super(HighPassFilter.this);
            this.add(this.slider);
            this.add(this.label);
            this.slider.addChangeListener(this);
            this.slider.setPreferredSize(new Dimension(90, this.slider.getPreferredSize().height));
        }

        public void stateChanged(ChangeEvent e) {
            HighPassFilter.this.f = (double)this.slider.getValue() / 100.0;
            this.label.setText(String.valueOf(HighPassFilter.this.f));
        }
    }
}

