/*
 * Decompiled with CFR 0.152.
 */
package com.cudos.common.systems;

import com.cudos.common.systems.SystemsComponent;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Gain
extends SystemsComponent {
    double gain = 1.0;

    public int getNInputs() {
        return 1;
    }

    public String getImageFileName() {
        return "resources/icons/systems/Multiplier.jpg";
    }

    public String getType() {
        return "Gain";
    }

    public double getOutput() {
        return this.currentValue;
    }

    public void tick() {
        this.currentValue = this.gain * this.getInput(0);
    }

    public double getGain() {
        return this.gain;
    }

    public void setGain(double d) {
        this.gain = d;
        ((GainPanel)this.getPane()).updateSliderFromGain();
    }

    public void createPane() {
        this.pane = new GainPanel();
    }

    class GainPanel
    extends SystemsComponent.SystemsComponentPane
    implements ChangeListener {
        JSlider gainslider = new JSlider(0, 100);
        JLabel label = new JLabel("1.0");
        JCheckBox invert = new JCheckBox("Invert");
        JPanel p0 = new JPanel();
        final double precision = 100.0;

        public GainPanel() {
            super(Gain.this);
            this.gainslider.setPreferredSize(new Dimension(100, this.gainslider.getPreferredSize().height));
            Box b = Box.createVerticalBox();
            b.add(this.gainslider);
            b.add(this.p0);
            this.p0.add(this.label);
            this.p0.add(this.invert);
            this.add(b);
            this.gainslider.setValue(50);
            this.gainslider.addChangeListener(this);
            this.invert.addChangeListener(this);
            this.setPreferredSize(new Dimension(140, 118));
        }

        public void stateChanged(ChangeEvent e) {
            Gain.this.gain = (double)(this.invert.isSelected() ? -1 : 1) * Math.pow(10.0, (double)(this.gainslider.getValue() - 50) / 25.0);
            this.updateLabel();
        }

        void updateSliderFromGain() {
            double g = Gain.this.gain;
            this.invert.setSelected(g < 0.0);
            this.gainslider.setValue((int)(50.0 + 25.0 * Math.log(Math.abs(g)) / Math.log(10.0)));
            this.updateLabel();
        }

        void updateLabel() {
            this.label.setText(String.valueOf((double)((int)(100.0 * Gain.this.gain)) / 100.0));
        }
    }
}

